/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import org.tizen.emulator.manager.platform.VersionList;

public class Version
implements Comparable<Version> {
    private final String version;

    public static Version createNew(String name) {
        Version version = VersionList.get(name);
        if (version == null) {
            version = new Version(name);
        }
        return version;
    }

    private Version(String version) {
        this.version = version;
        VersionList.getList().add(this);
    }

    public String getValue() {
        return this.version;
    }

    public String toString() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            return false;
        }
        Version target = (Version)obj;
        return target.getValue().equals(this.version);
    }

    public int hashCode() {
        return 100;
    }

    @Override
    public int compareTo(Version o) {
        assert (this.version != null && o != null && o.getValue() != null);
        String[] vals1 = this.version.split("\\.");
        String[] vals2 = o.getValue().split("\\.");
        return this.compare(vals1, vals2);
    }

    @Override
    public int compareTo(String o) {
        assert (this.version != null && o != null);
        String[] vals1 = this.version.split("\\.");
        String[] vals2 = o.split("\\.");
        return this.compare(vals1, vals2);
    }

    private int compare(String[] src, String[] dest) {
        for (int i = 0; i < Math.max(src.length, dest.length); ++i) {
            int version1 = 0;
            int version2 = 0;
            if (src.length > i) {
                version1 = Integer.parseInt(src[i]);
            }
            if (dest.length > i) {
                version2 = Integer.parseInt(dest[i]);
            }
            assert (version1 >= 0 && version2 >= 0);
            if (version1 == version2) continue;
            return version1 - version2;
        }
        return 0;
    }
}

