/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.control;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import org.tizen.emulator.manager.ui.resources.ImageKind;
import org.tizen.emulator.manager.ui.resources.Images;

public class StepLabel {
    private static final String BREEZE_SANS_BOLD = "\"Breeze Sans Bold\"";
    private static final String FX_FONT_FAMILY = "-fx-font-family";
    private Label label;
    private StackPane normalPane = new StackPane();
    private StackPane selectPane = new StackPane();
    private StackPane completePane = new StackPane();
    private STATE state;

    public StepLabel(int index) {
        this.label = new Label();
        ImageView nor = new ImageView(Images.get(ImageKind.STEP_NUMBER_NOR));
        Text norText = new Text(String.valueOf(index));
        norText.setStyle("-fx-fill: #E2E2E2;-fx-font-family: \"Breeze Sans Bold\";");
        this.normalPane.getChildren().add((Object)nor);
        this.normalPane.getChildren().add((Object)norText);
        this.normalPane.setAlignment(Pos.CENTER);
        ImageView sel = new ImageView(Images.get(ImageKind.STEP_NUMBER_SEL));
        Text selText = new Text(String.valueOf(index));
        selText.setStyle("-fx-fill: #008AEE;-fx-font-family: \"Breeze Sans Bold\";");
        this.selectPane.getChildren().add((Object)sel);
        this.selectPane.getChildren().add((Object)selText);
        this.selectPane.setAlignment(Pos.CENTER);
        ImageView com = new ImageView(Images.get(ImageKind.STEP_NUMBER_SEL));
        Text comText = new Text(String.valueOf(index));
        comText.setStyle("-fx-fill: #7FC4F6;-fx-font-family: \"Breeze Sans Bold\";");
        this.completePane.getChildren().add((Object)com);
        this.completePane.getChildren().add((Object)comText);
        this.completePane.setAlignment(Pos.CENTER);
        this.label.setMaxWidth(Double.MAX_VALUE);
        this.label.setPrefHeight(34.0);
        this.label.setAlignment(Pos.CENTER);
        this.setState(STATE.NORMAL);
    }

    public void setState(STATE state) {
        this.state = state;
        switch (state) {
            case NORMAL: {
                this.label.setStyle("-fx-text-fill: #585858;-fx-background-color: #D7D7D7");
                this.label.setGraphic((Node)this.normalPane);
                break;
            }
            case SELECT: {
                this.label.setStyle("-fx-text-fill: #FFFFFF;-fx-background-color: #008AEE");
                this.label.setGraphic((Node)this.selectPane);
                break;
            }
            case COMPLETE: {
                this.label.setStyle("-fx-text-fill: #FFFFFF;-fx-background-color: #7FC4F6");
                this.label.setGraphic((Node)this.completePane);
                break;
            }
        }
    }

    public STATE getState() {
        return this.state;
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public Node getNode() {
        return this.label;
    }

    public static enum STATE {
        NORMAL,
        SELECT,
        COMPLETE;

    }
}

