/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.CommandList;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.processor.ConsoleException;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.util.OutputUtil;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.tool.About;

public class CommandLineParser {
    private Command mAction = null;
    private boolean isHelp = false;
    private boolean isVerbose = false;

    public CommandLineParser() {
        CommandList.makeCommandList();
    }

    public void parseArgs(String[] args) {
        Command action = null;
        try {
            int count = args.length;
            for (int i = 0; i < count; ++i) {
                String a = args[i];
                if (a.startsWith("-")) {
                    String temp = a.substring(a.startsWith("--") ? 2 : 1);
                    if (CommandList.isGlobalOption(temp)) {
                        this.checkGlobalOption(a);
                        continue;
                    }
                    if (action == null) {
                        throw new ConsoleException(a + " " + Messages.getString("CommandLineParser.Error.NotExistGOpiton"));
                    }
                }
                if (action == null) {
                    action = CommandList.findCommand(a);
                    if (action != null) continue;
                    throw new ConsoleException("'" + a + "' " + Messages.getString("CommandLineParser.Error.NotExistCommand"));
                }
                Option command = null;
                if (a.startsWith("--")) {
                    command = action.findLongNameOption(a.substring(2));
                } else if (a.startsWith("-")) {
                    command = action.findShortNameOption(a.substring(1));
                } else {
                    throw new ConsoleException("'" + a + "' " + Messages.getString("CommandLineParser.Error.NotValidOption") + " '" + action.getCommand() + "'");
                }
                if (command == null) {
                    throw new ConsoleException("'" + a + "' " + Messages.getString("CommandLineParser.Error.NotValidOption") + " '" + action.getCommand() + "'");
                }
                command.setInCommandLine(true);
                if (!command.isNeedsExtra()) continue;
                if (++i >= count) {
                    throw new ConsoleException(Messages.getString("CommandLineParser.Error.MissingExtra") + " '" + a + "'");
                }
                if (!command.checkExtraArg(args[i])) {
                    throw new ConsoleException("'" + args[i] + "' " + Messages.getString("CommandLineParser.Error.NotValidExtra") + " '" + a + "'");
                }
                command.setCurrentValue(args[i]);
            }
            if (action == null) {
                if (this.isHelpState()) {
                    this.printHelpAndExit(null, null);
                } else {
                    this.printHelpAndExit(null, Messages.getString("CommandLineParser.Error.MissingCommand"));
                }
            } else {
                String missing;
                if (this.isHelpState()) {
                    this.printHelpAndExit(action, null);
                }
                if ((missing = action.checkMandatory()) != null) {
                    throw new ConsoleException(String.format(Messages.getString("CommandLineParser.Error.MissingMandatory"), missing, action.getCommand()));
                }
                this.mAction = action;
            }
        }
        catch (ConsoleException e) {
            this.printErrorAndExit(e.getMessage());
        }
    }

    private void checkGlobalOption(String value) throws ConsoleException {
        Option c = null;
        c = value.startsWith("--") ? CommandList.getGlobalCommand().findLongNameOption(value.substring(2)) : CommandList.getGlobalCommand().findShortNameOption(value.substring(1));
        if (c == null) {
            throw new ConsoleException("'" + value + "' " + Messages.getString("CommandLineParser.Error.NotExistGOpiton"));
        }
        if (this.isHelpState() || this.isVerboseState()) {
            throw new ConsoleException(Messages.getString("CommandLineParser.Error.CheckGOption"));
        }
        c.setInCommandLine(true);
        switch (c.getShortName().charAt(0)) {
            case 'h': {
                this.isHelp = true;
                break;
            }
            case 'v': {
                this.isVerbose = true;
                EMLogger.getInstance().setConsoleLogger();
                break;
            }
            case 'V': {
                String version = About.getInstance().getVersion();
                version = version + " (" + About.getInstance().getPackageVersion() + ")";
                this.printAndExit(version);
                break;
            }
        }
    }

    private boolean isHelpState() {
        return this.isHelp;
    }

    private boolean isVerboseState() {
        return this.isVerbose;
    }

    public Command getAction() {
        return this.mAction;
    }

    public void printAndExit(String message) {
        if (message != null) {
            OutputUtil.print(message);
        }
        System.exit(0);
    }

    public void printErrorAndExit(String message) {
        if (message != null) {
            OutputUtil.printError(message);
        }
        System.exit(message != null ? 2 : 0);
    }

    public void printHelpAndExit(Command command, String message) {
        OutputUtil.printErrorAndHelp(command, message);
        System.exit(message != null ? 2 : 0);
    }
}

