/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.concurrent.overseer;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import org.tizen.emulator.manager.concurrent.overseer.Job;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Version;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.helper.HelperClass;
import org.tizen.emulator.manager.vms.helper.ProcessResult;

public class CheckVT
extends Job {
    private static final String HAX_CHECKER = OSUtil.isWin() ? "check-hax.exe" : "check-hax";
    private static final String WHPX_CHECKER = OSUtil.isWin() ? "check-whpx.exe" : "";
    private static final String ENABLE_WHPX = "-enable-whpx";
    private static final String ENABLE_HAX = "-enable-hax";
    private static final String LATEST_PLATFORM_VERSION = "7.0";
    private static final String ENABLE_KVM = "-enable-kvm";
    private static final String KVM_DEV_NODE = "/dev/kvm";
    private boolean isVTSupported = false;
    private boolean isNonUG = false;

    public static String getVTEnablingCommand(String version) {
        Version currPlatformVersion = Version.createNew(version);
        if (currPlatformVersion.compareTo(LATEST_PLATFORM_VERSION) >= 0) {
            if (OSUtil.isWin()) {
                int checkWHPX = CheckVT.checkWHPX();
                if (checkWHPX == 0 || checkWHPX == 1) {
                    return ENABLE_WHPX;
                }
            } else if (OSUtil.isLinux()) {
                return ENABLE_KVM;
            }
            return ENABLE_HAX;
        }
        if (OSUtil.isWin() || OSUtil.isMac()) {
            return ENABLE_HAX;
        }
        return ENABLE_KVM;
    }

    public static boolean isVTSupported() {
        return CheckVT.getInstance(CheckVT.class).isVTSupported;
    }

    public static boolean isNonUG() {
        return CheckVT.getInstance(CheckVT.class).isNonUG;
    }

    public static int checkWHPX() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(FilePathResources.getEmulatorCheckToolPath() + File.separator + WHPX_CHECKER);
        cmd.add("hyper-v");
        ProcessResult result = HelperClass.runProcess(cmd, new File(FilePathResources.getEmulatorCheckToolPath()));
        return result.getExitValue();
    }

    public static int checkHAX() {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(FilePathResources.getEmulatorCheckToolPath() + File.separator + HAX_CHECKER);
        ProcessResult result = HelperClass.runProcess(cmd, new File(FilePathResources.getEmulatorCheckToolPath()));
        return result.getExitValue();
    }

    @Override
    public void work() {
        if (OSUtil.isWin()) {
            int whpxPresent = CheckVT.checkWHPX();
            switch (whpxPresent) {
                case 0: {
                    this.isVTSupported = true;
                    break;
                }
                case 1: {
                    this.isVTSupported = true;
                    this.isNonUG = false;
                    break;
                }
            }
        }
        if (OSUtil.isWin() || OSUtil.isMac()) {
            int haxPresent = CheckVT.checkHAX();
            switch (haxPresent) {
                case 0: {
                    this.isVTSupported = true;
                    break;
                }
                case 1: {
                    this.isVTSupported = true;
                    this.isNonUG = true;
                    break;
                }
            }
        } else if (OSUtil.isLinux() && new File(KVM_DEV_NODE).canRead()) {
            this.isVTSupported = true;
        }
        EMLogger.getLogger().log(Level.INFO, "Support HW virtualization: " + Boolean.toString(this.isVTSupported));
        EMLogger.getLogger().log(Level.INFO, "non-UG: " + Boolean.toString(this.isNonUG));
    }
}

