/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.network;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.network.WindowsBridge;
import org.tizen.emulator.manager.network.WindowsTap;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.helper.HelperClass;
import org.tizen.emulator.manager.vms.helper.ProcessResult;

public class NetworkUtil {
    public static String BRIDGE_NAME = "bridge1";
    static String BRIDGE_OPTION = "--bridge";
    private static String SHELL_PATH = "/bin/sh";
    private static File TMP_SCRIPT_FILE = null;
    private static final String IPV4_REGEX = "(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))";
    private static Pattern IPV4_PATTERN = Pattern.compile("(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))");

    private static String getBridgeNameByTapNameForLinux(String device) throws VMWorkerException {
        String result = null;
        if (OSUtil.isLinux()) {
            List<String> cmd = Arrays.asList("brctl", "show");
            ProcessResult res = HelperClass.runProcess(cmd);
            if (!res.isSuccess()) {
                throw new VMWorkerException(res.getResultMessage());
            }
            String parsedBridge = null;
            String parsedDevice = null;
            for (String line : res.getStdOutMsg()) {
                String[] arr = line.split("\\s+");
                if (arr.length == 4) {
                    parsedBridge = arr[0].trim();
                    parsedDevice = arr[3].trim();
                } else {
                    if (arr.length != 2 || !arr[0].isEmpty()) continue;
                    parsedDevice = arr[1].trim();
                }
                if (!device.equals(parsedDevice)) continue;
                result = parsedBridge;
            }
        }
        return result;
    }

    private static List<String> getHostDefaultGatewayForLinux(String ifName) throws VMWorkerException {
        ArrayList<String> result = new ArrayList<String>();
        if (OSUtil.isLinux()) {
            List<String> cmd = Arrays.asList("ip", "route");
            ProcessResult res = HelperClass.runProcess(cmd);
            if (res.isSuccess()) {
                for (String str : res.getStdOutMsg()) {
                    String[] arr = str.split("\\s+");
                    if (ifName == null) {
                        if (arr.length < 3 || !arr[0].equals("default")) continue;
                        result.add(arr[2]);
                        continue;
                    }
                    if (arr.length < 5 || !arr[0].equals("default") || !arr[4].equals(ifName)) continue;
                    result.add(arr[2]);
                }
            } else {
                throw new VMWorkerException(res.getResultMessage());
            }
        }
        return result;
    }

    @Deprecated
    public static List<String> getBridgeListForLinux() throws VMWorkerException {
        ArrayList<String> result = new ArrayList<String>();
        if (OSUtil.isLinux()) {
            List<String> cmd = Arrays.asList("brctl", "show");
            ProcessResult res = HelperClass.runProcess(cmd);
            if (res.isSuccess()) {
                for (String str : res.getStdOutMsg()) {
                    String[] arr = str.split("\\s+");
                    if (arr.length > 4 || arr[0].isEmpty()) continue;
                    result.add(arr[0]);
                }
            } else {
                throw new VMWorkerException(res.getResultMessage());
            }
        }
        return result;
    }

    public static ArrayList<String> getTapList() {
        ArrayList<String> list = new ArrayList();
        if (OSUtil.isLinux()) {
            for (String tap : NetworkUtil.getTapListForLinux()) {
                try {
                    if (NetworkUtil.getBridgeNameByTapNameForLinux(tap) == null) continue;
                    list.add(tap);
                }
                catch (VMWorkerException e) {
                    EMLogger.getLogger().warning(e.getMessage());
                }
            }
        } else if (OSUtil.isWin()) {
            list = WindowsTap.getTapListForWin2();
        } else if (OSUtil.isMac()) {
            list = NetworkUtil.getTapListForMac();
        }
        Collections.sort(list);
        return list;
    }

    private static ArrayList<String> getTapListForMac() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("auto");
        return result;
    }

    private static List<String> getTapListForLinux() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> cmd = Arrays.asList("ip", "tuntap");
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            EMLogger.getLogger().warning("Get tap list fail. Command returns fail:cmd : " + cmd.toString() + ", return : " + res.getExitValue());
        } else {
            for (String line : res.getStdOutMsg()) {
                String[] arr = line.split(":");
                if (arr.length <= 0) continue;
                result.add(arr[0].trim());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ArrayList<String> getTapIdList() {
        ArrayList<String> tapIdList = new ArrayList<String>();
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\Control\\Class\\{4D36E972-E325-11CE-BFC1-08002BE10318}";
        String value1 = "ComponentId";
        String value2 = "NetCfgInstanceId";
        WinReg.HKEYByReference regKey = null;
        try {
            String[] subKeys;
            regKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097);
            for (String subKey : subKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)regKey.getValue())) {
                try {
                    String compId = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey), (String)value1);
                    String tapId = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey), (String)value2);
                    if (compId == null || tapId == null || !compId.toLowerCase().startsWith("tap")) continue;
                    EMLogger.getLogger().info("tapId added: " + tapId);
                    tapIdList.add(tapId);
                }
                catch (Win32Exception e) {
                    EMLogger.getLogger().info(e.getMessage());
                }
            }
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().info(e.getMessage());
        }
        finally {
            if (regKey != null) {
                Advapi32Util.registryCloseKey((WinReg.HKEY)regKey.getValue());
            }
        }
        return tapIdList;
    }

    public static boolean isTapInBridge(String tapName) throws VMWorkerException {
        boolean result = false;
        if (OSUtil.isWin()) {
            return WindowsTap.isTapBound(tapName);
        }
        if (OSUtil.isLinux() && NetworkUtil.getBridgeNameByTapNameForLinux(tapName) != null) {
            result = true;
        }
        return result;
    }

    static String[] registryGetStringArray(WinReg.HKEY hKey, String value) {
        return NetworkUtil.registryGetStringArray(hKey, null, value);
    }

    static String[] registryGetStringArray(WinReg.HKEY hKey, String path, String value) {
        TreeMap values = null;
        values = path == null ? Advapi32Util.registryGetValues((WinReg.HKEY)hKey) : Advapi32Util.registryGetValues((WinReg.HKEY)hKey, (String)path);
        String[] resultArr = null;
        for (Map.Entry entry : values.entrySet()) {
            Object v;
            String val = (String)entry.getKey();
            if (!val.equals(value) || !((v = entry.getValue()) instanceof String[])) continue;
            resultArr = (String[])v;
            break;
        }
        EMLogger.getLogger().fine("Data in Registry " + path + ", " + value);
        if (resultArr == null) {
            return new String[0];
        }
        for (Iterator iterator : resultArr) {
            EMLogger.getLogger().fine((String)((Object)iterator));
        }
        return resultArr;
    }

    public static ArrayList<String> getHostEthernetList() {
        ArrayList<String> ifList = new ArrayList<String>();
        List<String> cmd = Arrays.asList(FilePathResources.getToolEmulatorBinPath() + File.separator + "devcon.exe", "find", "=net", "@pci*");
        ProcessResult res = HelperClass.runProcess(cmd);
        boolean isCommandSuccess = false;
        if (res.isSuccess()) {
            for (String str : res.getStdOutMsg()) {
                if (!str.contains(": ")) continue;
                isCommandSuccess = true;
                String pciNet = str.split(": ")[1].trim();
                EMLogger.getLogger().info("PCI network interface: " + pciNet);
                ifList.add(pciNet);
            }
        } else if (!res.isSuccess() || !isCommandSuccess) {
            EMLogger.getLogger().warning(res.getResultMessage());
        }
        return ifList;
    }

    public static boolean isBridgeGuideNecessaryForMac() {
        String macVersion = System.getProperty("os.version");
        EMLogger.getLogger().info("Host MacOSX version: " + macVersion);
        String[] currentMacOSVersion = macVersion.split("\\.");
        int[] compareTo = new int[]{10, 9};
        for (int i = 0; i < Math.max(currentMacOSVersion.length, compareTo.length); ++i) {
            int version1 = 0;
            int version2 = 0;
            if (currentMacOSVersion.length > i) {
                version1 = Integer.parseInt(currentMacOSVersion[i]);
            }
            if (compareTo.length > i) {
                version2 = compareTo[i];
            }
            if (version1 == version2) continue;
            return version1 - version2 >= 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTapTempFile(String content) {
        BufferedWriter writer = null;
        File file = null;
        try {
            file = File.createTempFile("tap", ".sh");
            file.deleteOnExit();
            writer = new BufferedWriter(new FileWriter(file));
            writer.append(content);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            EMLogger.printStackTrace(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    EMLogger.printStackTrace(e);
                }
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getNetmaskFromTap(String tapName) throws NumberFormatException, VMWorkerException {
        String netMask = "";
        if (OSUtil.isLinux()) {
            InterfaceAddress addr = NetworkUtil.getInterfaceIpInfo(tapName);
            if (addr == null) return netMask;
            return NetworkUtil.getNetMask(addr.getNetworkPrefixLength());
        }
        if (OSUtil.isWin() && NetworkUtil.isTapInBridge(tapName)) {
            String[] data;
            WinReg.HKEY key = WindowsBridge.getTcpipKey();
            if (key != null) {
                try {
                    data = NetworkUtil.registryGetStringArray(key, "SubnetMask");
                    if (data.length > 0) {
                        netMask = data[0];
                    }
                }
                catch (Win32Exception e) {
                    EMLogger.getLogger().warning(e.getMessage());
                }
                finally {
                    Advapi32Util.registryCloseKey((WinReg.HKEY)key);
                }
            }
            if (!netMask.isEmpty()) return netMask;
            key = NetworkUtil.getInterfaceTcpipKey(WindowsBridge.getClassId());
            if (key == null) return netMask;
            try {
                data = NetworkUtil.registryGetStringArray(key, "SubnetMask");
                if (data.length <= 0) return netMask;
                netMask = data[0];
                return netMask;
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning(e.getMessage());
                return netMask;
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)key);
            }
        }
        if (!OSUtil.isMac()) return netMask;
        String bridgeName = NetworkUtil.getBridgeNameForMac();
        if (bridgeName.isEmpty()) {
            return "";
        }
        List<String> cmd = Arrays.asList(SHELL_PATH, "-c", "ifconfig " + bridgeName + " | grep \"inet \" | awk '{print $4}'");
        ProcessResult res = HelperClass.runProcess(cmd);
        boolean isCommandSuccess = false;
        if (res.isSuccess()) {
            long ipAddress;
            for (String str : res.getStdOutMsg()) {
                isCommandSuccess = true;
                ipAddress = Long.parseLong(str.substring(2), 16);
                netMask = NetworkUtil.longToIpAddress(ipAddress);
                EMLogger.getLogger().info("netmask en0: " + netMask);
            }
            if (netMask.length() == 0) {
                isCommandSuccess = false;
                cmd = Arrays.asList(SHELL_PATH, "-c", "ifconfig bridge1 | grep \"inet \" | awk '{print $4}'");
                res = HelperClass.runProcess(cmd);
                if (res.isSuccess()) {
                    for (String str : res.getStdOutMsg()) {
                        isCommandSuccess = true;
                        ipAddress = Long.parseLong(str.substring(2), 16);
                        netMask = NetworkUtil.longToIpAddress(ipAddress);
                        EMLogger.getLogger().info("netmask bridge1: " + netMask);
                    }
                }
            }
        }
        if (res.isSuccess()) {
            if (isCommandSuccess) return netMask;
        }
        EMLogger.getLogger().warning(res.getResultMessage());
        return netMask;
    }

    private static String longToIpAddress(long ip) {
        StringBuilder sb = new StringBuilder(15);
        for (int i = 0; i < 4; ++i) {
            sb.insert(0, Long.toString(ip & 0xFFL));
            if (i < 3) {
                sb.insert(0, '.');
            }
            ip >>= 8;
        }
        return sb.toString();
    }

    static WinReg.HKEY getInterfaceTcpipKey(String ifId) {
        if (ifId == null) {
            return null;
        }
        WinReg.HKEY resultKey = null;
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\services\\Tcpip\\Parameters\\Interfaces\\" + ifId;
        try {
            resultKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097).getValue();
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        return resultKey;
    }

    public static String getGatewayFromTap(String tapName) throws VMWorkerException {
        String gateway = "";
        if (OSUtil.isLinux()) {
            try {
                List<String> gwList = NetworkUtil.getHostDefaultGatewayForLinux(tapName);
                if (gwList.size() == 1) {
                    gateway = gwList.get(0);
                }
            }
            catch (VMWorkerException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
        } else {
            if (OSUtil.isWin() && NetworkUtil.isTapInBridge(tapName)) {
                return WindowsTap.getHostDefaultGateway();
            }
            if (OSUtil.isMac()) {
                String bridgeName = NetworkUtil.getBridgeNameForMac();
                if (bridgeName.isEmpty()) {
                    return "";
                }
                List<String> cmd = Arrays.asList(SHELL_PATH, "-c", "netstat -rn | grep " + bridgeName + " | grep ^default | awk '{print $2}'");
                ProcessResult res = HelperClass.runProcess(cmd);
                boolean isCommandSuccess = false;
                if (res.isSuccess()) {
                    for (String str : res.getStdOutMsg()) {
                        isCommandSuccess = true;
                        gateway = str.trim();
                        EMLogger.getLogger().info("gateway: " + gateway);
                    }
                } else if (!res.isSuccess() || !isCommandSuccess) {
                    EMLogger.getLogger().warning(res.getResultMessage());
                }
            }
        }
        return gateway;
    }

    public static String getBridgeNameForMac() {
        if (TMP_SCRIPT_FILE == null || !TMP_SCRIPT_FILE.exists()) {
            String newLine = StringResources.NEW_LINE;
            String command = "#!/bin/sh" + newLine + "IF=\"\"" + newLine + "for x in `ifconfig | grep ^[a-zA-Z] | awk -F: '{print $1}'`;" + newLine + "do" + newLine + "   IF=`ifconfig $x | grep \"member: en0\"`" + newLine + "   if [ \"x$IF\" != \"x\" ]; then" + newLine + "      UP=`ifconfig $x | grep UP`" + newLine + "      if [ \"x$UP\" != \"x\" ]; then" + newLine + "         echo $x" + newLine + "      fi" + newLine + "   fi" + newLine + "done";
            TMP_SCRIPT_FILE = NetworkUtil.createTapTempFile(command);
        }
        if (TMP_SCRIPT_FILE == null || !TMP_SCRIPT_FILE.exists()) {
            return "";
        }
        List<String> cmd = Arrays.asList(SHELL_PATH, TMP_SCRIPT_FILE.getAbsolutePath());
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            EMLogger.getLogger().info("Get bridge name fail : " + res.getResultMessage());
            return "";
        }
        List<String> result = res.getStdOutMsg();
        if (result.size() < 1) {
            EMLogger.getLogger().info("No bridge name available..");
            return "";
        }
        return result.get(0);
    }

    public static String getDnsFromTap(String tapName) throws VMWorkerException {
        String dns = "";
        if (OSUtil.isLinux()) {
            dns = NetworkUtil.getDnsForLinux(tapName);
        } else if (OSUtil.isWin() && NetworkUtil.isTapInBridge(tapName)) {
            dns = WindowsTap.getDns(tapName);
        } else if (OSUtil.isMac()) {
            dns = NetworkUtil.getDnsForMac(tapName);
        }
        return dns;
    }

    private static String getDnsForMac(String tapName) {
        String dnsServer = "";
        List<String> cmd = Arrays.asList(SHELL_PATH, "-c", "/usr/sbin/scutil --dns | grep nameserver\\[[0]*\\] | awk '{print $3}' | head -n 1");
        ProcessResult res = HelperClass.runProcess(cmd);
        boolean isCommandSuccess = false;
        if (res.isSuccess()) {
            for (String str : res.getStdOutMsg()) {
                isCommandSuccess = true;
                dnsServer = str.trim();
                EMLogger.getLogger().info("dns server: " + dnsServer);
            }
        } else if (!res.isSuccess() || !isCommandSuccess) {
            EMLogger.getLogger().warning(res.getResultMessage());
        }
        return dnsServer;
    }

    private static String getDnsForLinux(String tapName) {
        String brName = null;
        try {
            brName = NetworkUtil.getBridgeNameByTapNameForLinux(tapName);
        }
        catch (VMWorkerException e) {
            EMLogger.getLogger().warning("Get dns failed. " + e.getMessage());
            return "";
        }
        List<String> cmd = null;
        cmd = brName == null ? Arrays.asList("nm-tool") : Arrays.asList("nm-tool", brName);
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            EMLogger.getLogger().warning("Get dns failed. " + res.getResultMessage());
            return "";
        }
        for (String line : res.getStdOutMsg()) {
            String[] arr = line.split("\\s+");
            if (arr.length < 3 || !arr[1].trim().startsWith("DNS")) continue;
            return arr[2].trim();
        }
        return "";
    }

    public static InterfaceAddress getInterfaceIpInfo(String ifName) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface current = interfaces.nextElement();
                    if (!current.getName().equals(ifName)) continue;
                    for (InterfaceAddress addr : current.getInterfaceAddresses()) {
                        if (!(addr.getAddress() instanceof Inet4Address)) continue;
                        return addr;
                    }
                }
            }
        }
        catch (SocketException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        return null;
    }

    public static String getNetMask(int maskLength) {
        StringBuilder netMaskAddr = new StringBuilder();
        int val = maskLength / 8;
        int mod = maskLength % 8;
        int count = 0;
        for (int i = 0; i < val; ++i) {
            if (i > 0) {
                netMaskAddr.append(".");
            }
            netMaskAddr.append("255");
            ++count;
        }
        if (mod != 0) {
            int modMask = 0;
            for (int i = 7; i > 7 - mod; --i) {
                modMask = (int)((double)modMask + Math.pow(2.0, i));
            }
            netMaskAddr.append(".").append(String.valueOf(modMask));
            ++count;
        }
        while (count < 4) {
            netMaskAddr.append(".0");
            ++count;
        }
        return netMaskAddr.toString();
    }

    public static String checkIPString(boolean widgetEnable, String ip, String title) {
        String errMsg = "";
        if (widgetEnable) {
            if (ip == null || ip.isEmpty()) {
                errMsg = title + " cannot be empty!";
            } else {
                boolean isMatch = IPV4_PATTERN.matcher(ip).matches();
                if (!isMatch) {
                    errMsg = title + " is invalid!";
                }
            }
        }
        return errMsg;
    }

    public static boolean checkIP(String ip) {
        return IPV4_PATTERN.matcher(ip).matches();
    }

    public static boolean isTapExist(String tapName) {
        for (String str : NetworkUtil.getTapList()) {
            if (!str.equals(tapName)) continue;
            return true;
        }
        return false;
    }

    public static String getBridgeIpAddress(String tapName) throws VMWorkerException {
        String ipAddr = null;
        if (OSUtil.isLinux()) {
            InterfaceAddress ifAddr = NetworkUtil.getInterfaceIpInfo(tapName);
            if (ifAddr != null) {
                EMLogger.getLogger().info("get " + tapName + "'s IP");
                ipAddr = ifAddr.getAddress().getHostAddress();
            } else {
                EMLogger.getLogger().info("get bridge's IP");
                InterfaceAddress ifAddrBridge = NetworkUtil.getInterfaceIpInfo(BRIDGE_NAME);
                if (ifAddrBridge != null) {
                    ipAddr = ifAddrBridge.getAddress().getHostAddress();
                }
            }
        } else {
            if (OSUtil.isWin() && NetworkUtil.isTapInBridge(tapName)) {
                return WindowsBridge.getIpAddress();
            }
            if (OSUtil.isMac()) {
                String bridgeName = NetworkUtil.getBridgeNameForMac();
                if (bridgeName.isEmpty()) {
                    return "";
                }
                List<String> cmd = Arrays.asList(SHELL_PATH, "-c", "ifconfig " + bridgeName + " | grep \"inet \" | awk '{print $2}'");
                ProcessResult res = HelperClass.runProcess(cmd);
                boolean isCommandSuccess = false;
                if (res.isSuccess()) {
                    for (String str : res.getStdOutMsg()) {
                        isCommandSuccess = true;
                        ipAddr = str.trim();
                        EMLogger.getLogger().info("host IP en0: " + ipAddr);
                    }
                    if (ipAddr == null) {
                        isCommandSuccess = false;
                        cmd = Arrays.asList(SHELL_PATH, "-c", "ifconfig bridge1 | grep \"inet \" | awk '{print $2}'");
                        res = HelperClass.runProcess(cmd);
                        if (res.isSuccess()) {
                            for (String str : res.getStdOutMsg()) {
                                isCommandSuccess = true;
                                ipAddr = str.trim();
                                EMLogger.getLogger().info("host IP bridge1: " + ipAddr);
                            }
                        }
                    }
                }
                if (!res.isSuccess() || !isCommandSuccess) {
                    EMLogger.getLogger().warning(res.getResultMessage());
                }
            }
        }
        if (ipAddr == null) {
            return "";
        }
        return ipAddr;
    }

    public static boolean isValidTap(String tapName) throws VMWorkerException {
        if (NetworkUtil.getGatewayFromTap(tapName).isEmpty()) {
            return false;
        }
        if (NetworkUtil.getNetmaskFromTap(tapName).isEmpty()) {
            return false;
        }
        return NetworkUtil.getBridgeIpAddress(tapName) != null;
    }

    public static String getAvailableTapName() {
        List<String> list = null;
        if (OSUtil.isLinux()) {
            list = NetworkUtil.getTapListForLinux();
        } else if (OSUtil.isWin()) {
            list = WindowsTap.getTapListForWin2();
        }
        String newName = "";
        if (list != null) {
            int i = 1;
            while (true) {
                newName = "tap" + String.valueOf(i);
                boolean nameIsSame = false;
                for (String tap : list) {
                    if (!newName.equals(tap)) continue;
                    nameIsSame = true;
                    break;
                }
                if (!nameIsSame) break;
                ++i;
            }
        }
        return newName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassIDFromPnpInstanceID(String CompatibleID) {
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\Control\\Network\\{4D36E972-E325-11CE-BFC1-08002BE10318}";
        String key = "Connection";
        String value = "PnpInstanceID";
        WinReg.HKEYByReference regKey = null;
        try {
            String[] subKeys;
            regKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097);
            for (String subKey : subKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)regKey.getValue())) {
                String[] subKeys2;
                for (String subKey2 : subKeys2 = Advapi32Util.registryGetKeys((WinReg.HKEY)root, (String)(topKey + "\\" + subKey))) {
                    String pnpInstanceID;
                    if (!subKey2.equals(key) || !Advapi32Util.registryValueExists((WinReg.HKEY)root, (String)(topKey + "\\" + subKey + "\\" + key), (String)value) || !(pnpInstanceID = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey + "\\" + key), (String)value)).equals(CompatibleID)) continue;
                    String string = subKey;
                    return string;
                }
            }
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().info(e.getMessage());
        }
        finally {
            if (regKey != null) {
                Advapi32Util.registryCloseKey((WinReg.HKEY)regKey.getValue());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPnpInstanceIDFromName(String name) {
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\Control\\Network\\{4D36E972-E325-11CE-BFC1-08002BE10318}";
        String key = "Connection";
        String value = "Name";
        String pnpInstanceID = "PnpInstanceID";
        WinReg.HKEYByReference regKey = null;
        try {
            String[] subKeys;
            regKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097);
            for (String subKey : subKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)regKey.getValue())) {
                String[] subKeys2;
                for (String subKey2 : subKeys2 = Advapi32Util.registryGetKeys((WinReg.HKEY)root, (String)(topKey + "\\" + subKey))) {
                    String tapName;
                    if (!subKey2.equals(key) || !(tapName = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey + "\\" + key), (String)value)).equals(name)) continue;
                    String string = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey + "\\" + key), (String)pnpInstanceID);
                    return string;
                }
            }
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().info(e.getMessage());
        }
        finally {
            if (regKey != null) {
                Advapi32Util.registryCloseKey((WinReg.HKEY)regKey.getValue());
            }
        }
        return null;
    }

    public static List<String> getEthernetListForLinux() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> cmd = Arrays.asList(SHELL_PATH, "-c", "/bin/ls /sys/class/net | /bin/grep eth");
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            EMLogger.getLogger().warning("Get tap list fail. Command returns fail:cmd : " + cmd.toString() + ", return : " + res.getExitValue());
            return null;
        }
        for (String line : res.getStdOutMsg()) {
            result.add(line.trim());
        }
        return result;
    }

    public static ArrayList<String> getEthernetListForMac() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("en0");
        return result;
    }
}

