/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.item;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.image.Image;
import org.tizen.emulator.manager.platform.DummyPlatform;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.StandardPlatform;
import org.tizen.emulator.manager.ui.controller.create.DeviceTemplateViewHelper;
import org.tizen.emulator.manager.ui.item.CommonViewItemFactoryV2;
import org.tizen.emulator.manager.ui.item.CommonViewItemFactoryV3;
import org.tizen.emulator.manager.ui.item.ViewItemFactory;
import org.tizen.emulator.manager.ui.resources.ImageKind;
import org.tizen.emulator.manager.ui.resources.Images;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.template.Template;
import org.tizen.emulator.manager.ui.template.TemplateLoader;
import org.tizen.emulator.manager.ui.template.item.Group;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;

public class PlatformDisplayData {
    private String type;
    private int priority;
    private ImageKind icon;
    private ImageKind selectedIcon;
    private ImageKind overIcon;
    private ImageKind tooltipIcon;
    private Template propertyUI;
    private Template deviceTemplateUI;
    private ViewItemFactory factory = null;
    private List<ViewItemController> detailItems;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Image getIcon() {
        return Images.get(this.icon);
    }

    void setIcon(ImageKind icon) {
        this.icon = icon;
    }

    public Image getTooltipIcon() {
        if (this.tooltipIcon == null) {
            return null;
        }
        return Images.get(this.tooltipIcon);
    }

    void setTooltipIcon(ImageKind tooltipIcon) {
        this.tooltipIcon = tooltipIcon;
    }

    public Image getSelectedIcon() {
        return Images.get(this.selectedIcon);
    }

    public void setSelectedIcon(ImageKind selectedIcon) {
        this.selectedIcon = selectedIcon;
    }

    public Image getOverIcon() {
        return Images.get(this.overIcon);
    }

    public void setOverIcon(ImageKind overIcon) {
        this.overIcon = overIcon;
    }

    public static PlatformDisplayData getData(Platform platform) {
        if (platform == null) {
            return null;
        }
        if (platform.getData() == null) {
            PlatformDisplayData.setPlatformData(platform);
        }
        return (PlatformDisplayData)platform.getData();
    }

    public static void setPlatformData(Platform platform) {
        PlatformDisplayData data = new PlatformDisplayData();
        if (platform instanceof DummyPlatform) {
            data.setType(((DummyPlatform)platform).getType());
        } else if (platform instanceof StandardPlatform) {
            data.setType("standard");
            data.setPriority(platform.getProfile().getPriority());
        } else {
            data.setType("custom");
            data.setPriority(platform.getProfile().getPriority() + 1);
        }
        String name = platform.getProfile().getName();
        if (name.equals("tizen")) {
            if (data.getType().equals("custom")) {
                data.setIcon(ImageKind.ICON_TYPE_TIZEN_HEADED_CUSTOM);
                data.setSelectedIcon(ImageKind.ICON_TYPE_TIZEN_HEADED_CUSTOM_SEL);
                data.setOverIcon(ImageKind.ICON_TYPE_TIZEN_HEADED_CUSTOM_OVER);
            } else {
                data.setIcon(ImageKind.ICON_TYPE_TIZEN_HEADED);
                data.setSelectedIcon(ImageKind.ICON_TYPE_TIZEN_HEADED_SEL);
                data.setOverIcon(ImageKind.ICON_TYPE_TIZEN_HEADED_OVER);
            }
            data.setTooltipIcon(ImageKind.ICON_TOOLTIP_TIZEN_HEADED);
        } else if (name.equals("tizen")) {
            if (data.getType().equals("custom")) {
                data.setIcon(ImageKind.ICON_TYPE_MOBILE_CUSTOM);
                data.setSelectedIcon(ImageKind.ICON_TYPE_MOBILE_CUSTOM_SEL);
                data.setOverIcon(ImageKind.ICON_TYPE_MOBILE_CUSTOM_OVER);
            } else {
                data.setIcon(ImageKind.ICON_TYPE_MOBILE);
                data.setSelectedIcon(ImageKind.ICON_TYPE_MOBILE_SEL);
                data.setOverIcon(ImageKind.ICON_TYPE_MOBILE_OVER);
            }
            data.setTooltipIcon(ImageKind.ICON_TOOLTIP_MOBILE);
        } else if (name.equals("wearable")) {
            if (data.getType().equals("custom")) {
                data.setIcon(ImageKind.ICON_TYPE_WEARABLE_CUSTOM);
                data.setSelectedIcon(ImageKind.ICON_TYPE_WEARABLE_CUSTOM_SEL);
                data.setOverIcon(ImageKind.ICON_TYPE_WEARABLE_CUSTOM_OVER);
            } else {
                data.setIcon(ImageKind.ICON_TYPE_WEARABLE);
                data.setSelectedIcon(ImageKind.ICON_TYPE_WEARABLE_SEL);
                data.setOverIcon(ImageKind.ICON_TYPE_WEARABLE_OVER);
            }
            if (platform.getImageSkinShape().equals((Object)SKIN_SHAPE.CIRCLE)) {
                data.setTooltipIcon(ImageKind.ICON_TOOLTIP_WEARABLE_CIRCLE);
            } else {
                data.setTooltipIcon(ImageKind.ICON_TOOLTIP_WEARABLE_SQUARE);
            }
        } else if (name.equals("tv")) {
            if (data.getType().equals("custom")) {
                data.setIcon(ImageKind.ICON_TYPE_TV_CUSTOM);
                data.setSelectedIcon(ImageKind.ICON_TYPE_TV_CUSTOM_SEL);
                data.setOverIcon(ImageKind.ICON_TYPE_TV_CUSTOM_OVER);
            } else {
                data.setIcon(ImageKind.ICON_TYPE_TV);
                data.setSelectedIcon(ImageKind.ICON_TYPE_TV_SEL);
                data.setOverIcon(ImageKind.ICON_TYPE_TV_OVER);
            }
            data.setTooltipIcon(ImageKind.ICON_TOOLTIP_TV);
        } else {
            if (data.getType().equals("custom")) {
                data.setIcon(ImageKind.ICON_TYPE_TIZEN_HEADED_CUSTOM);
                data.setSelectedIcon(ImageKind.ICON_TYPE_TIZEN_HEADED_CUSTOM_SEL);
                data.setOverIcon(ImageKind.ICON_TYPE_TIZEN_HEADED_CUSTOM_OVER);
            } else {
                data.setIcon(ImageKind.ICON_TYPE_TIZEN_HEADED);
                data.setSelectedIcon(ImageKind.ICON_TYPE_TIZEN_HEADED_SEL);
                data.setOverIcon(ImageKind.ICON_TYPE_TIZEN_HEADED_OVER);
            }
            data.setTooltipIcon(ImageKind.ICON_TOOLTIP_TIZEN_HEADED);
        }
        data.loadUITemplate(platform);
        platform.setData(data);
    }

    private void loadUITemplate(Platform platform) {
        this.propertyUI = TemplateLoader.loadTemplate(platform);
        this.deviceTemplateUI = DeviceTemplateViewHelper.getPlatformDeviceTemplateUI(platform.getPlatformPath());
        if (this.deviceTemplateUI == null) {
            this.mergeExtendsItemsInto(DeviceTemplateViewHelper.getProfileDeviceTemplateUI(platform.getProfile().getName()), this.propertyUI);
        } else {
            this.mergeExtendsItemsInto(this.deviceTemplateUI, this.propertyUI);
        }
        if (platform.getPlugin() != null) {
            this.factory = (ViewItemFactory)platform.getPlugin().newInstance("Item-Factory");
        }
    }

    private void mergeExtendsItemsInto(Template deviceTemplateUI, Template propertyUI) {
        if (deviceTemplateUI == null || propertyUI == null) {
            return;
        }
        Group extendsGroup = deviceTemplateUI.findGroup("extends");
        Item propertyDeviceItem = propertyUI.findItem("default", "device");
        if (extendsGroup == null || propertyDeviceItem == null) {
            return;
        }
        for (Item item : extendsGroup.getItems()) {
            boolean itemAlreadyExist = false;
            for (Item subItem : propertyDeviceItem.getSubItems()) {
                if (!item.getName().equals(subItem.getName())) continue;
                itemAlreadyExist = true;
                break;
            }
            if (itemAlreadyExist) continue;
            propertyDeviceItem.addSubItem(item);
        }
    }

    public ViewItemFactory getViewItemFactory() {
        if (this.propertyUI == null) {
            return null;
        }
        if (this.factory != null) {
            return this.factory;
        }
        this.factory = this.propertyUI.getTemplateVersion().equals("3.0") ? new CommonViewItemFactoryV3() : (this.propertyUI.getTemplateVersion().equals("2.0") ? new CommonViewItemFactoryV2() : new CommonViewItemFactoryV2());
        return this.factory;
    }

    public Template getPropertyUI() {
        return this.propertyUI;
    }

    public Template getDeviceTemplateUI() {
        return this.deviceTemplateUI;
    }

    public List<ViewItemController> getDetailItems() {
        if (this.detailItems == null) {
            this.detailItems = new ArrayList<ViewItemController>();
            ViewItemFactory factory = this.getViewItemFactory();
            if (factory != null) {
                factory.setMode(MODE.DETAIL);
                for (Item item : factory.getTabList(this.propertyUI)) {
                    this.detailItems.addAll(factory.getViewItemList(item));
                }
            }
        }
        return this.detailItems;
    }
}

