/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import java.util.List;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.platform.SkinList;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.DisplayLabelViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.type.RESOLUTION;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;
import org.tizen.emulator.manager.vms.type.SKIN_TYPE;

public class DisplayViewController
extends ViewItemController {
    private final EventHandler<ItemEvent> handler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            if (event.oldValue.equals(event.newValue)) {
                return;
            }
            DeviceTemplate template = null;
            if (event.data instanceof DeviceTemplate) {
                template = (DeviceTemplate)event.data;
            }
            if (template != null) {
                DeviceTemplateValue value = template.getValue();
                DisplayViewController.this.re = value.getResolution();
                DisplayViewController.this.size = value.getDisplaySize();
                DisplayViewController.this.skin = value.getSkin();
                DisplayViewController.this.resetViewItem();
            }
            DisplayViewController.this.onChangedValue(null);
        }
    };
    private final EventHandler<ItemEvent> templateSkinChangeHandler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            DisplayViewController.this.skin = (Skin)event.data;
            DisplayViewController.this.resetSkinCombo();
            DisplayViewController.this.onChangedValue(null);
        }
    };
    private DisplayLabelViewItem viewItem;
    private RESOLUTION re;
    private double size;
    private Skin skin;
    private SKIN_SHAPE imageSkinShape;
    private List<Skin> skinList;

    public DisplayViewController(Item item) {
        super(item);
        ViewItemController.addChangeEventHandler("deviceTemplate", this.handler);
        ViewItemController.addChangeEventHandler("skin", this.templateSkinChangeHandler);
    }

    @Override
    public void dispose() {
        ViewItemController.removeChangeEventHandler("deviceTemplate", this.handler);
        ViewItemController.removeChangeEventHandler("skin", this.templateSkinChangeHandler);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new DisplayLabelViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.viewItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.viewItem = item instanceof DisplayLabelViewItem ? (DisplayLabelViewItem)item : new DisplayLabelViewItem();
        this.viewItem.setTitle("Display");
        this.viewItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                DisplayViewController.this.skin = (Skin)DisplayViewController.this.viewItem.getSelectedData();
                DisplayViewController.this.checkValid();
                DisplayViewController.this.onChangedValue(event);
            }
        });
    }

    @Override
    protected void onChangedValue(Event event) {
        ItemEvent iEvent = new ItemEvent(this.getName(), this);
        iEvent.oldValue = "";
        iEvent.newValue = "";
        ViewItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        DeviceTemplate template;
        Object obj = value.getObjectValue("resolution");
        if (obj instanceof RESOLUTION) {
            this.re = (RESOLUTION)obj;
        }
        if ((obj = value.getDoubleValue("size")) != null) {
            this.size = (Double)obj;
        }
        if ((obj = value.getObjectValue("SkinList")) instanceof List) {
            this.skinList = (List)obj;
        }
        if ((obj = value.getObjectValue("skinShape")) instanceof SKIN_SHAPE) {
            this.imageSkinShape = (SKIN_SHAPE)((Object)obj);
        }
        if ((template = (DeviceTemplate)value.getObjectValue("deviceTemplate")) != null) {
            DeviceTemplateValue templateValue = template.getValue();
            this.skin = templateValue.getSkin();
        }
        if (this.mode == MODE.MODIFY) {
            this.skin = (Skin)value.getObjectValue("skin");
        }
        this.resetViewItem();
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setObjectValue("resolution", this.re);
        value.setDoubleValue("size", this.size);
        value.setObjectValue("skin", this.skin);
        if (this.skin != null) {
            value.setStringValue("skin", this.skin.getPath());
        }
    }

    @Override
    public void checkValid() {
        if (this.skin == null) {
            if (this.mode == MODE.CREATE) {
                this.viewItem.setSkinState(STATE.WARNING, "There is no available skin for your emulator.\nEmulator will be failed to launch.\nChoose another template or specify skin directory for template.");
            } else {
                this.viewItem.setSkinState(STATE.WARNING, "Selected skin is not available.\nChoose another skin.");
            }
        } else {
            boolean isSkinMatched = false;
            for (Skin s : SkinList.findSkinList(this.re, this.skinList)) {
                if (!this.skin.equals(s)) continue;
                isSkinMatched = true;
            }
            if (!isSkinMatched) {
                boolean isResolutionMatched;
                boolean bl = isResolutionMatched = this.skin.getType() == SKIN_TYPE.GENERAL ? true : this.skin.getResolution().equals(this.re);
                if (isResolutionMatched && this.skin.getSkinShapeList().hasShape(this.imageSkinShape)) {
                    isSkinMatched = true;
                }
            }
            if (isSkinMatched) {
                this.viewItem.setSkinState(STATE.OK, "");
            } else {
                this.viewItem.setSkinState(STATE.WARNING, "This skin is not perfectly matched for your emulator.\nThis emulator may be displayed with different resolution or skin shape.");
            }
        }
    }

    private void resetViewItem() {
        this.viewItem.setResolution(this.re.toString());
        this.viewItem.setDisplaySize(this.size);
        this.resetSkinCombo();
        this.checkValid();
    }

    private void resetSkinCombo() {
        this.viewItem.clear();
        if (this.skinList == null) {
            this.viewItem.setEnable(false);
            this.viewItem.setSkinState(STATE.ERROR, "");
            return;
        }
        if (this.skin != null) {
            this.viewItem.addItem(this.skin.getName(), this.skin);
        }
        for (Skin s : SkinList.findSkinList(this.re, this.skinList)) {
            if (this.skin != null && this.skin.equals(s)) continue;
            this.viewItem.addItem(s.getName(), s);
        }
        if (this.viewItem.size() == 0) {
            for (Skin s : this.skinList) {
                this.viewItem.addItem(s.getName(), s);
            }
        }
        if (this.viewItem.size() > 0) {
            this.viewItem.selectItem(0);
            if (this.skin == null) {
                this.skin = (Skin)this.viewItem.getSelectedData();
            }
        }
    }
}

