/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.ComboViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.ui.template.item.Option;

public class ComboViewController
extends ViewItemController {
    protected ComboViewItem comboView;

    public ComboViewController(Item item) {
        super(item);
    }

    public ComboViewController(Item item, ViewItemController parent) {
        super(item, parent);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new ComboViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.comboView;
    }

    @Override
    public void setViewItem(ViewItem vItem) {
        this.comboView = vItem instanceof ComboViewItem ? (ComboViewItem)vItem : new ComboViewItem();
        this.comboView.setTitle(this.getTitle());
        Option list = this.findOption("list");
        if (list != null) {
            String[] items;
            String option = list.getValue();
            for (String i : items = option.split(",")) {
                i = i.trim();
                this.comboView.addItem(i);
            }
        }
        this.comboView.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                ComboViewController.this.onChangedValue(event);
            }
        });
    }

    @Override
    protected void onChangedValue(Event event) {
        ItemEvent iEvent = new ItemEvent(this.getName(), this);
        iEvent.oldValue = "";
        iEvent.newValue = this.comboView.getSelectedItem();
        ViewItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String text = "";
        if (this.getLabelName() != null || this.parent != null) {
            String parentName = this.parent != null ? this.parent.getName() : this.getLabelName();
            text = value.getSubItemStringValue(parentName, this.getName());
            if (text == null || text.isEmpty()) {
                text = value.getStringValue(this.getName());
            }
        } else {
            text = value.getStringValue(this.getName());
        }
        boolean result = false;
        if (text != null) {
            result = this.comboView.selectItem(text);
        }
        if (!result && this.item.getDefaultValue() != null && !this.item.getDefaultValue().isEmpty()) {
            result = this.comboView.selectItem(this.item.getDefaultValue());
        }
        if (!result) {
            result = this.comboView.selectItem(0);
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        if (this.getLabelName() != null || this.parent != null) {
            String parentName = this.parent != null ? this.parent.getName() : this.getLabelName();
            value.setSubItemStringValue(parentName, this.getName(), this.comboView.getSelectedItem());
        } else {
            value.setStringValue(this.getName(), this.comboView.getSelectedItem());
        }
    }

    @Override
    public void checkValid() {
    }
}

