/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.dialog.network;

import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.tizen.emulator.manager.network.NetworkUtil;
import org.tizen.emulator.manager.ui.dialog.CustomDialog;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.item.TextViewItem;

public class InputHostIPDialog {
    private static Double WIDTH = 200.0;
    private static Double ITEM_HEIGHT = 28.0;
    private static Double TITLE_WIDTH = 80.0;
    private CustomDialog<String> dialog;
    private VBox box;
    private TextViewItem textIP;
    private Button okButton;

    public InputHostIPDialog() {
        this.makeContent();
    }

    private void makeContent() {
        this.box = new VBox();
        this.textIP = new TextViewItem();
        this.textIP.setPrefWidth(WIDTH);
        this.textIP.setPrefHeight(ITEM_HEIGHT);
        this.textIP.setTitleMinWidth(TITLE_WIDTH);
        this.textIP.setMatchStr("[0-9.]");
        this.textIP.setTitle("Address");
        this.box.getChildren().add((Object)this.textIP.getContent());
        VBox.setMargin((Node)this.textIP.getContent(), (Insets)new Insets(5.0, 10.0, 5.0, 10.0));
        this.textIP.addEventHandler(EventType.Modify, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                InputHostIPDialog.this.setState(event.text);
            }
        });
    }

    public String getHostIP() {
        this.dialog = new CustomDialog();
        this.dialog.setTitle("Insert the host IP address");
        this.dialog.getDialogPane().setContent((Node)this.box);
        this.dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
        this.dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, String>(){

            public String call(ButtonType param) {
                if (param == ButtonType.CANCEL) {
                    return null;
                }
                if (InputHostIPDialog.this.textIP.getText().isEmpty()) {
                    return null;
                }
                return InputHostIPDialog.this.textIP.getText();
            }
        });
        this.okButton = (Button)this.dialog.getDialogPane().lookupButton(ButtonType.OK);
        this.okButton.setDisable(true);
        this.textIP.setText("");
        this.setState("");
        Optional optType = this.dialog.showAndWait();
        if (optType.isPresent()) {
            return (String)optType.get();
        }
        return null;
    }

    private void setState(String text) {
        if (text.isEmpty()) {
            this.textIP.setState(STATE.ESSENTIAL, "");
            this.okButton.setDisable(true);
            return;
        }
        String msg = NetworkUtil.checkIPString(true, text, "Host ip");
        if (!msg.isEmpty()) {
            this.textIP.setState(STATE.ERROR, msg);
            this.okButton.setDisable(true);
        } else {
            this.textIP.setState(STATE.OK, msg);
            this.okButton.setDisable(false);
        }
    }
}

