/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.tizen.emulator.manager.ui.Main;
import org.tizen.emulator.manager.ui.control.StepLabel;
import org.tizen.emulator.manager.ui.control.StepLabelBar;
import org.tizen.emulator.manager.ui.controller.ButtonBarController;
import org.tizen.emulator.manager.ui.controller.ButtonCreateEvent;
import org.tizen.emulator.manager.ui.controller.create.DeviceTemplateListPage;
import org.tizen.emulator.manager.ui.controller.create.PlatformListPage;
import org.tizen.emulator.manager.ui.controller.create.VMDialogData;
import org.tizen.emulator.manager.ui.controller.create.VMDialogPage;
import org.tizen.emulator.manager.ui.item.PlatformDisplayData;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.TabViewer;
import org.tizen.emulator.manager.vms.VMPropertyValue;

public class CreateDialog {
    public static final int MIN_WIDTH = 500;
    public static final int MIN_HEIGHT = 450;
    public static final int WIDTH = 654;
    public static final int HEIGHT = 600;
    public static final int BUTTON_BOX_HEIGHT = 60;
    public static final int BUTTON_WIDTH = 86;
    public static final int BUTTON_HEIGHT = 24;
    final Stage stage;
    BorderPane root;
    VBox top;
    StepLabelBar stepBar;
    Label discriptionLabel;
    StackPane stackPane;
    private final List<VMDialogPage> childPageList = new ArrayList<VMDialogPage>();
    private VMDialogPage currentChildPage;
    VMDialogData vmCreateData = new VMDialogData();
    ButtonBarController buttons;
    boolean isCancelClicked = true;
    SimpleBooleanProperty nextOrFinishButtonInvalidProperty = new SimpleBooleanProperty();

    public CreateDialog() {
        this.root = new BorderPane();
        this.root.setPrefSize(654.0, 600.0);
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        double screenHeight = primaryScreenBounds.getHeight();
        if (screenHeight < 600.0) {
            this.root.setPrefHeight(screenHeight - 50.0);
        }
        this.top = new VBox();
        this.stepBar = new StepLabelBar();
        this.discriptionLabel = new Label();
        this.discriptionLabel.setPrefHeight(40.0);
        this.top.getChildren().add((Object)this.stepBar.getNode());
        this.top.getChildren().add((Object)this.discriptionLabel);
        VBox.setMargin((Node)this.discriptionLabel, (Insets)new Insets(0.0, 0.0, 0.0, 25.0));
        this.top.setStyle("-fx-background-color:#ffffff");
        this.root.setTop((Node)this.top);
        this.stackPane = new StackPane();
        this.root.setCenter((Node)this.stackPane);
        this.addChildPage(new PlatformListPage());
        this.addChildPage(new DeviceTemplateListPage());
        TabViewer propertyView = new TabViewer();
        this.addChildPage(propertyView);
        this.stage = new Stage();
        Scene scene = new Scene((Parent)this.root);
        this.stage.setTitle("Emulator Configuration");
        this.stage.setScene(scene);
        this.stage.initModality(Modality.APPLICATION_MODAL);
        this.setOwner();
        this.stage.setMinWidth(500.0);
        this.stage.setMinHeight(450.0);
        this.vmCreateData.createPropertyViewProvider(this.stage, this.root);
        this.vmCreateData.setMode(MODE.CREATE);
        this.buttons = new ButtonBarController(86, 24);
        this.root.setBottom((Node)this.buttons.makeButtonBox(60));
        this.makeButtons();
        this.vmCreateData.setButtons(this.buttons);
        scene.getStylesheets().addAll(Main.getBaseCssUrl());
        this.root.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                switch (keyCode) {
                    case ENTER: {
                        CreateDialog.this.buttons.selectDefaultButton();
                        event.consume();
                        break;
                    }
                    case ESCAPE: {
                        CreateDialog.this.buttons.selectCancelButton();
                        event.consume();
                        break;
                    }
                }
            }
        });
    }

    private void setOwner() {
        Window owner = Main.getMainWindow();
        if (owner instanceof Stage) {
            Stage newStage = (Stage)owner;
            Bindings.bindContent((List)this.stage.getIcons(), (ObservableList)newStage.getIcons());
        }
        this.stage.initOwner(owner);
    }

    private void addChildPage(VMDialogPage child) {
        this.childPageList.add(child);
        int index = this.stepBar.addStep();
        this.stepBar.setText(index, child.getTitle());
    }

    private void makeButtons() {
        this.buttons.setOnButtonCreate(new EventHandler<ButtonCreateEvent>(){

            public void handle(final ButtonCreateEvent buttonCreateEvent) {
                buttonCreateEvent.getButton().setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent arg0) {
                        ButtonType type = buttonCreateEvent.getType();
                        if (type == ButtonType.FINISH) {
                            CreateDialog.this.isCancelClicked = false;
                            CreateDialog.this.stage.close();
                        } else if (type == ButtonType.CANCEL) {
                            CreateDialog.this.isCancelClicked = true;
                            CreateDialog.this.stage.close();
                        } else if (type == ButtonType.PREVIOUS) {
                            CreateDialog.this.previousClicked();
                        } else if (type == ButtonType.NEXT) {
                            CreateDialog.this.nextClicked();
                        }
                    }
                });
            }
        });
        this.buttons.addButton(ButtonType.CANCEL);
        this.buttons.addButton(ButtonType.PREVIOUS);
        this.buttons.addButton(ButtonType.NEXT);
        this.nextOrFinishButtonInvalidProperty.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean isInvalid) {
                Button button = CreateDialog.this.buttons.getButton(ButtonType.NEXT);
                if (button != null) {
                    button.setDisable(isInvalid.booleanValue());
                    if (!isInvalid.booleanValue()) {
                        button.setDefaultButton(true);
                    }
                }
                if ((button = CreateDialog.this.buttons.getButton(ButtonType.FINISH)) != null) {
                    button.setDisable(isInvalid.booleanValue());
                    if (!isInvalid.booleanValue()) {
                        button.setDefaultButton(true);
                    }
                }
            }
        });
        this.nextOrFinishButtonInvalidProperty.set(false);
    }

    public VMPropertyValue open() {
        this.changeChildAndButtons(this.childPageList.get(0));
        this.stepBar.setButtonState(0, StepLabel.STATE.SELECT);
        this.root.layout();
        double dialogWidth = this.root.getPrefWidth();
        double dialogHeight = this.root.getPrefHeight();
        Window parent = Main.getMainWindow();
        this.stage.setX(parent.getX() + parent.getWidth() / 2.0 - dialogWidth / 2.0);
        this.stage.setY(parent.getY() + parent.getHeight() / 2.0 - dialogHeight / 2.0);
        this.stage.showAndWait();
        if (this.isCancelClicked) {
            return null;
        }
        for (VMDialogPage page : this.childPageList) {
            page.setData(this.vmCreateData);
        }
        return this.vmCreateData.getVmValue();
    }

    public AnchorPane showPropertyAnchorPane(int width) {
        assert (this.root.getRight() == null);
        this.root.setMaxWidth(this.root.getWidth());
        AnchorPane pane = new AnchorPane();
        pane.setPrefWidth((double)width);
        this.stage.setWidth(this.stage.getWidth() + (double)width);
        this.stage.setMinWidth(this.stage.getMinWidth() + (double)width);
        this.root.setRight((Node)pane);
        this.root.setMaxWidth(-1.0);
        return pane;
    }

    public void hidePropertyAnchorPane() {
        assert (this.root.getRight() != null);
        double rightWidth = this.root.getRight() == null ? 0.0 : this.root.getRight().getBoundsInLocal().getWidth();
        this.stage.setWidth(this.stage.getWidth() - rightWidth);
        this.stage.setMinWidth(this.stage.getMinWidth() - rightWidth);
        this.root.setRight(null);
    }

    private void previousClicked() {
        VMDialogPage newPage = null;
        for (int i = 0; i < this.childPageList.size(); ++i) {
            VMDialogPage childPage = this.childPageList.get(i);
            if (this.currentChildPage != childPage || i <= 0) continue;
            newPage = this.childPageList.get(i - 1);
            this.stepBar.setButtonState(i, StepLabel.STATE.NORMAL);
            this.stepBar.setButtonState(i - 1, StepLabel.STATE.SELECT);
            break;
        }
        if (newPage != null) {
            this.changeChildAndButtons(newPage);
        }
    }

    private void nextClicked() {
        VMDialogPage newPage = null;
        if (this.currentChildPage != null && !this.currentChildPage.onPageHide(this.vmCreateData)) {
            return;
        }
        for (int i = 0; i < this.childPageList.size(); ++i) {
            VMDialogPage childPage = this.childPageList.get(i);
            if (this.currentChildPage != childPage || this.childPageList.size() <= i + 1) continue;
            newPage = this.childPageList.get(i + 1);
            this.stepBar.setButtonState(i, StepLabel.STATE.COMPLETE);
            this.stepBar.setButtonState(i + 1, StepLabel.STATE.SELECT);
            break;
        }
        if (newPage != null) {
            this.changeChildAndButtons(newPage);
        }
    }

    private void changeChildAndButtons(VMDialogPage newPage) {
        assert (newPage.getNode() != null);
        if (newPage == this.childPageList.get(this.childPageList.size() - 1)) {
            this.buttons.removeButton(ButtonType.NEXT);
            this.buttons.addButton(ButtonType.FINISH);
        } else {
            if (this.buttons.getButton(ButtonType.NEXT) == null) {
                this.buttons.addButton(ButtonType.NEXT);
            }
            this.buttons.removeButton(ButtonType.FINISH);
        }
        if (this.currentChildPage != null) {
            this.currentChildPage.setData(this.vmCreateData);
            this.stackPane.getChildren().remove((Object)this.currentChildPage.getNode());
        }
        if (newPage == this.childPageList.get(0)) {
            this.buttons.getButton(ButtonType.PREVIOUS).setDisable(true);
            this.discriptionLabel.setGraphic(null);
        } else {
            this.buttons.getButton(ButtonType.PREVIOUS).setDisable(false);
            if (this.vmCreateData.getPlatform() != null) {
                PlatformDisplayData platformDisplayData = PlatformDisplayData.getData(this.vmCreateData.getPlatform());
            }
        }
        this.discriptionLabel.setText(newPage.getDescription());
        newPage.onPageShow(this.vmCreateData, this.nextOrFinishButtonInvalidProperty);
        this.stackPane.getChildren().add((Object)newPage.getNode());
        this.currentChildPage = newPage;
        this.stage.requestFocus();
    }
}

