/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.TextViewController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.exception.EmptyStringException;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.helper.HelperClass;

public class VMNameViewController
extends TextViewController {
    public VMNameViewController(Item item) {
        super(item);
    }

    @Override
    public void setViewItem(ViewItem item) {
        super.setViewItem(item);
        this.textView.setMaxLen(30);
        this.textView.setMatchStr("[A-Za-z0-9-_]");
    }

    @Override
    protected void onChangedValue(Event event) {
        this.checkValid();
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        if (this.getMode() == MODE.CREATE) {
            String text = HelperClass.getDefaultVMName((VMPropertyValue)value.getData());
            this.textView.setText(text);
        } else {
            String text = value.getStringValue(this.getName());
            this.textView.setText(text);
            this.textView.setEnable(false);
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setStringValue(this.getName(), this.textView.getText());
    }

    @Override
    public void checkValid() {
        if (this.mode == MODE.MODIFY) {
            return;
        }
        String newName = this.textView.getText();
        String message = "";
        STATE newState = STATE.OK;
        try {
            HelperClass.checkVMName(newName);
        }
        catch (VMWorkerException e) {
            message = e.getMessage();
            newState = STATE.ERROR;
        }
        catch (EmptyStringException e) {
            message = e.getMessage();
            newState = STATE.ESSENTIAL;
        }
        this.setItemState(newState, message);
    }
}

