/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.vms.monitor.FileWatcher;

class WatchServiceFileWatcher
extends FileWatcher {
    final WatchService watcher = FileSystems.getDefault().newWatchService();
    final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();

    WatchServiceFileWatcher() throws IOException {
    }

    private void watchDirectories() throws InterruptedException {
        WatchKey key = this.watcher.take();
        Path dir = this.keys.get(key);
        if (dir == null) {
            return;
        }
        for (WatchEvent<?> event : key.pollEvents()) {
            Path path = dir.resolve((Path)event.context());
            if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.directoryCreated(path);
                    continue;
                }
                this.fileCreated(path);
                continue;
            }
            if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.directoryModified(path);
                    continue;
                }
                this.fileModified(path);
                continue;
            }
            if (event.kind() != StandardWatchEventKinds.ENTRY_DELETE) continue;
            if (this.subdirs.contains(path)) {
                this.directoryDeleted(path);
                continue;
            }
            this.fileDeleted(path);
        }
        if (!key.reset()) {
            this.keys.remove(key);
        }
    }

    @Override
    protected void registerWatchRoot(Path path) throws IOException {
        this.registerDirectoryInternal(path);
    }

    @Override
    protected void registerDirectoryInternal(Path path) throws IOException {
        WatchKey key = path.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keys.put(key, path);
    }

    @Override
    protected void monitoring() throws InterruptedException {
        while (true) {
            try {
                while (true) {
                    this.watchDirectories();
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                EMLogger.printStackTrace(e);
                continue;
            }
            break;
        }
    }
}

