/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.dialog.network;

import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.VBox;
import javafx.stage.StageStyle;
import org.tizen.emulator.manager.concurrent.SimpleExecutor;
import org.tizen.emulator.manager.concurrent.TaskCompletionListener;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.network.NetworkUtil;
import org.tizen.emulator.manager.network.WindowsBridge;
import org.tizen.emulator.manager.network.WindowsTap;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.dialog.CustomDialog;
import org.tizen.emulator.manager.ui.dialog.MessageBox;
import org.tizen.emulator.manager.ui.dialog.network.TapGuideDialogForWin;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;

public class TapCreateWorkerDialog {
    private String tapName;
    private String ifName;
    private CustomDialog<ButtonType> stateDialog;
    private VBox box = null;
    private Label state;
    private ProgressBar progress;
    private Button okButton;
    private String titleStyle = "-fx-background-color: #EEEEEE;-fx-border-color: #AAAAAA; -fx-border-width: 0 0 1 0;-fx-padding: 10;";
    private TaskCompletionListener<String> completionListener = new TaskCompletionListener<String>(){

        @Override
        public void completed(final String result) {
            TapCreateWorkerDialog.this.setText("Complete to create new tap device");
            TapCreateWorkerDialog.this.okButton.setDisable(false);
            TapCreateWorkerDialog.this.progress.setVisible(false);
            if (!result.isEmpty()) {
                EMLogger.getLogger().info("Success to create new tap device: " + TapCreateWorkerDialog.this.tapName);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TapCreateWorkerDialog.this.state.setText(Messages.getString("TapUtil.CreatedTapDevice.0") + result);
                    }
                });
                if (OSUtil.isWin8AndAbove()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ButtonType re = MessageBox.confirm(Messages.getString("TapUtil.CreatedTapDevice.0") + result + StringResources.NEW_LINE + Messages.getString("TapUtil.CreatedTapDevice.1"));
                            if (re == ButtonType.OK) {
                                TapGuideDialogForWin.open();
                            }
                        }
                    });
                }
            }
        }
    };

    public TapCreateWorkerDialog(String tapName, String ifName) {
        this.tapName = tapName;
        this.ifName = ifName;
    }

    public void prepare() {
        this.stateDialog = new CustomDialog();
        this.stateDialog.initStyle(StageStyle.UNDECORATED);
        this.stateDialog.setTitle("Emulator Manager");
        this.stateDialog.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
        if (this.box == null) {
            this.makeContent();
        }
        this.stateDialog.getDialogPane().setContent((Node)this.box);
        this.okButton = (Button)this.stateDialog.getDialogPane().lookupButton(ButtonType.OK);
        this.okButton.setDisable(true);
    }

    private void makeContent() {
        this.box = new VBox();
        Label title = new Label();
        title.setText("Create new tap device ... ");
        title.setStyle(this.titleStyle);
        title.setMaxWidth(Double.MAX_VALUE);
        title.setMinHeight(40.0);
        this.state = new Label();
        this.state.setText("Start");
        this.state.setMaxWidth(Double.MAX_VALUE);
        this.state.wrapTextProperty().set(true);
        this.state.setMinSize(200.0, 80.0);
        this.progress = new ProgressBar();
        this.progress.setProgress(-1.0);
        this.progress.setMaxWidth(Double.MAX_VALUE);
        this.box.getChildren().add((Object)title);
        this.box.getChildren().add((Object)this.state);
        this.box.getChildren().add((Object)this.progress);
        this.box.setAlignment(Pos.CENTER_LEFT);
        VBox.setMargin((Node)this.state, (Insets)new Insets(5.0, 10.0, 5.0, 10.0));
        VBox.setMargin((Node)this.progress, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
    }

    public boolean create() {
        if (this.stateDialog == null || this.box == null) {
            this.prepare();
        }
        SimpleExecutor.asynExecute(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String result = "";
                try {
                    result = TapCreateWorkerDialog.this.work();
                }
                catch (VMWorkerException e) {
                    EMLogger.getLogger().warning("Failed to create tap device.");
                    EMLogger.getLogger().warning(e.getMessage());
                    final String msg = e.getMessage();
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TapCreateWorkerDialog.this.okButton.setDisable(false);
                            TapCreateWorkerDialog.this.progress.setVisible(false);
                            TapCreateWorkerDialog.this.setText(Messages.getString("TapUtil.FailedCreateTapDevice.0") + StringResources.NEW_LINE + msg);
                            TapCreateWorkerDialog.this.tapName = "";
                        }
                    });
                }
                return result;
            }
        }, this.completionListener);
        this.stateDialog.showAndWait();
        return !this.tapName.isEmpty();
    }

    public String work() throws VMWorkerException {
        String compatibleID = null;
        if (!OSUtil.isWin8AndAbove()) {
            compatibleID = WindowsBridge.getCompatibleID(this.ifName);
            if (compatibleID == null) {
                throw new VMWorkerException("");
            }
            WindowsBridge.checkEthernet(this.ifName, compatibleID);
            if (!WindowsBridge.isExist()) {
                this.setText("Network Bridge does not exist. Create one...");
                WindowsBridge.create();
            }
        }
        this.setText("Create tap device: " + this.tapName);
        WindowsTap.createNewTap(this.tapName);
        if (!OSUtil.isWin8AndAbove()) {
            WindowsBridge.backupEthernetTCPIP(NetworkUtil.getClassIDFromPnpInstanceID(compatibleID));
            this.setText("Bind the tap device to the Network Bridge...");
            WindowsBridge.bindTap(this.tapName);
            this.setText("Set TCP/IP for Network Bridge." + StringResources.NEW_LINE + "It will take minutes...");
            WindowsBridge.setTcpip(NetworkUtil.getClassIDFromPnpInstanceID(WindowsBridge.getCompatibleID(this.ifName)));
            this.setText("Bind Ethernet device to the Network Bridge...");
            WindowsBridge.bindEthernet(this.ifName, compatibleID);
        }
        this.setText("Check tap device...");
        if (!NetworkUtil.isTapExist(this.tapName)) {
            throw new VMWorkerException("Tap is not exist : " + this.tapName);
        }
        return this.tapName;
    }

    public void setText(final String text) {
        EMLogger.getLogger().info(text);
        if (this.state != null) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TapCreateWorkerDialog.this.state.setText(text);
                }
            });
        }
    }
}

