/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.io.IOException;
import org.tizen.emulator.manager.EmulatorManager;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.VMKeeper;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.monitor.MonitoringThread;
import org.tizen.emulator.manager.vms.monitor.RunningMonitor;
import org.tizen.emulator.manager.vms.monitor.VMRunningChecker;

public class LockFileMonitor
extends RunningMonitor {
    private final VMKeeper keeper;

    LockFileMonitor() {
        String monitorName = OSUtil.isWin() ? "WindowsLockMonitor" : "PosixLockMonitor";
        this.keeper = EmulatorManager.getVMKeeper();
        VMKeeper.addListChangeListener(this);
        MonitoringThread.newMonitoringThread(new monitoringLock(), monitorName).start();
    }

    private void updateState(VMProperty property, boolean isRunningDetected) {
        super.updateState(property, isRunningDetected, RunningMonitor.MonitoringType.LOCK_FILE);
    }

    private synchronized void examineLock(VMProperty property) throws IOException {
        boolean isRunning = VMRunningChecker.isRunning(property);
        this.updateState(property, isRunning);
    }

    @Override
    public synchronized void elementAdded(VMProperty property) {
        this.initPropertyState(property);
        try {
            this.examineLock(property);
        }
        catch (IOException e) {
            e.printStackTrace();
            EMLogger.printStackTrace(e);
        }
    }

    @Override
    public synchronized void elementRemoved(VMProperty property) {
    }

    @Override
    public void elementModified(VMProperty object) {
    }

    private final class monitoringLock
    implements Runnable {
        private monitoringLock() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        for (VMProperty property : LockFileMonitor.this.keeper.getProperties()) {
                            LockFileMonitor.this.examineLock(property);
                        }
                        Thread.sleep(500L);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    e.printStackTrace();
                    EMLogger.printStackTrace(e);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    EMLogger.printStackTrace(e);
                    continue;
                }
                break;
            }
        }
    }
}

