/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.ui.controller.ButtonBarController;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.vms.VMPropertyValue;

public class VMDialogData {
    private MODE mode;
    private Platform platform;
    private DeviceTemplate deviceTemplate;
    private VMPropertyValue vmValue;
    private ButtonBarController buttons;
    private PropertyViewProvider propertyViewProvider;

    public ButtonBarController getButtons() {
        return this.buttons;
    }

    public void setButtons(ButtonBarController buttons) {
        this.buttons = buttons;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public DeviceTemplate getDeviceTemplate() {
        return this.deviceTemplate;
    }

    public void setDeviceTemplate(DeviceTemplate deviceTemplate) {
        this.deviceTemplate = deviceTemplate;
    }

    public VMPropertyValue getVmValue() {
        return this.vmValue;
    }

    public void setVmValue(VMPropertyValue vmValue) {
        this.vmValue = vmValue;
    }

    public void createPropertyViewProvider(Stage stage, BorderPane rootPane) {
        this.propertyViewProvider = new PropertyViewProvider(stage, rootPane);
    }

    public PropertyViewProvider getPropertyViewProvider() {
        return this.propertyViewProvider;
    }

    public MODE getMode() {
        return this.mode;
    }

    public void setMode(MODE mode) {
        this.mode = mode;
    }

    static class PropertyViewProvider {
        private final Stage stage;
        private final BorderPane rootPane;
        private final SimpleBooleanProperty shownProperty = new SimpleBooleanProperty();

        public PropertyViewProvider(Stage stage, BorderPane rootPane) {
            this.stage = stage;
            this.rootPane = rootPane;
        }

        public AnchorPane addPropertyPane(int width) {
            this.shownProperty.set(true);
            assert (this.rootPane.getRight() == null);
            if (this.rootPane.getRight() != null) {
                return null;
            }
            AnchorPane pane = new AnchorPane();
            pane.setPrefWidth((double)width);
            this.stage.setWidth(this.stage.getWidth() + (double)width);
            this.rootPane.setRight((Node)pane);
            this.stage.setMinWidth(this.stage.getMinWidth() + (double)width);
            return pane;
        }

        public void removePropertyPane() {
            this.shownProperty.set(false);
            assert (this.rootPane.getRight() != null);
            if (this.rootPane.getRight() == null) {
                return;
            }
            double rightWidth = this.rootPane.getRight().getBoundsInLocal().getWidth();
            this.stage.setWidth(this.stage.getWidth() - rightWidth);
            this.rootPane.setRight(null);
            this.stage.setMinWidth(this.stage.getMinWidth() - rightWidth);
        }

        public SimpleBooleanProperty getShownProperty() {
            return this.shownProperty;
        }
    }
}

