/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.concurrent;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.tizen.emulator.manager.concurrent.ExecutorServiceDelegate;
import org.tizen.emulator.manager.concurrent.NoExceptionCallable;
import org.tizen.emulator.manager.concurrent.TaskCompletionListener;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;

public class SimpleExecutor
extends ExecutorServiceDelegate {
    static final SimpleExecutor instance = new SimpleExecutor();
    final Path lockPath = Paths.get(FilePathResources.getTizenSDKDataVmsPath() + File.separator + ".em-" + System.getProperty("user.name") + ".serialize.lock", new String[0]);
    FileChannel fc;
    FileLock lock;
    int lockCount = 0;

    private SimpleExecutor() {
    }

    private void getLock() {
        ++this.lockCount;
        if (this.lock != null && this.lock.isValid()) {
            return;
        }
        try {
            this.fc = FileChannel.open(this.lockPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            this.lock = this.fc.lock();
        }
        catch (IOException e) {
            e.printStackTrace();
            EMLogger.printStackTrace(e);
        }
    }

    private void releaseLock() {
        --this.lockCount;
        if (this.lockCount > 0) {
            return;
        }
        assert (this.lock != null);
        try {
            if (this.lock.isValid()) {
                this.lock.release();
                this.lock = null;
            }
            if (this.fc != null) {
                this.fc.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            EMLogger.printStackTrace(e);
        }
    }

    public static <T> T execute(Callable<T> task) throws Exception {
        return instance.executeInternal(task);
    }

    public static <T> T execute(NoExceptionCallable<T> task) {
        return instance.executeInternal(task);
    }

    public static <T> Future<T> asynExecute(Callable<T> task) {
        return instance.asyncExecuteInternal(task);
    }

    public static <T> Future<T> asynExecute(final Callable<T> task, final TaskCompletionListener<T> listener) {
        Callable wrappedTask = new Callable<T>(){

            @Override
            public T call() throws Exception {
                Object result = null;
                try {
                    result = task.call();
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    listener.completed(result);
                }
                return result;
            }
        };
        return instance.asyncExecuteInternal(wrappedTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T lockedExecute(Callable<T> task) throws Exception {
        T result;
        SimpleExecutor simpleExecutor = instance;
        synchronized (simpleExecutor) {
            instance.getLock();
            try {
                result = instance.executeInternal(task);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                instance.releaseLock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T lockedExecute(NoExceptionCallable<T> task) {
        T result;
        SimpleExecutor simpleExecutor = instance;
        synchronized (simpleExecutor) {
            instance.getLock();
            try {
                result = instance.executeInternal(task);
            }
            finally {
                instance.releaseLock();
            }
        }
        return result;
    }

    public static <T> Future<T> asyncLockedExecute(Callable<T> task) {
        return SimpleExecutor.asyncLockedExecute(task, null);
    }

    public static <T> Future<T> asyncLockedExecute(final Callable<T> task, final TaskCompletionListener<T> listener) {
        Callable wrappedTask = new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                Object result = null;
                SimpleExecutor simpleExecutor = instance;
                synchronized (simpleExecutor) {
                    instance.getLock();
                    try {
                        result = task.call();
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    finally {
                        instance.releaseLock();
                        if (listener != null) {
                            listener.completed(result);
                        }
                    }
                }
                return result;
            }
        };
        return instance.asyncExecuteInternal(wrappedTask);
    }
}

