/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.option.IOption;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;
import org.tizen.emulator.manager.vms.option.QemuOptions;

public class LaunchConfig {
    List<String> skinOptions = new ArrayList<String>();
    QemuOptions qemuOptions = new QemuOptions();
    List<String> kernelOptions = new ArrayList<String>();
    Map<String, String> variables = new HashMap<String, String>();
    Map<String, String> varComment = new HashMap<String, String>();
    public static String DEFAULT_VALUE = "[[VARIABLES]]";
    public static String SKIN_OPTIONS = "[[SKIN_OPTIONS]]";
    public static String QEMU_OPTIONS = "[[QEMU_OPTIONS]]";

    public boolean existVariable(OPTION_KEY key) {
        return this.existVariable(key.toString());
    }

    public boolean existVariable(String key) {
        return this.variables.containsKey(key);
    }

    public void removeVariable(OPTION_KEY key) {
        this.removeVariable(key.toString());
    }

    public void removeVariable(String key) {
        if (this.variables.containsKey(key)) {
            this.variables.remove(key);
        }
    }

    public void addVariable(String key, String value) {
        if (!this.variables.containsKey(key)) {
            this.variables.put(key, value);
        }
    }

    public void addVariableWithSpace(String key, String value) {
        this.addVariable(key, "\"" + value + "\"");
    }

    public void addVariable(String key, String value, String comment) {
        if (comment != null && !comment.isEmpty()) {
            this.varComment.put(key, comment);
        }
        this.addVariable(key, value);
    }

    public void addVariable(OPTION_KEY key, String value) {
        this.addVariable(key.toString(), value);
    }

    public void addVariableWithSpace(OPTION_KEY key, String value) {
        this.addVariable(key.toString(), "\"" + value + "\"");
    }

    public void addVariable(OPTION_KEY key, String value, String comment) {
        this.addVariable(key.toString(), value, comment);
    }

    public void addQemuOption(String option) {
        this.qemuOptions.add(option);
    }

    public void addQemuOption(String name, String value) {
        this.qemuOptions.add(name, value);
    }

    public void addQemuOption(String name, String value, String options) {
        this.qemuOptions.add(name, value, options);
    }

    public void appendQemuOptions(String name, String value, String options) {
        this.qemuOptions.add(name, value, options, true);
    }

    public void addSkinOption(String key, String value) {
        this.skinOptions.add(key + "=" + value);
    }

    public void addKernelOption(String key, String value) {
        this.kernelOptions.add(key + "=" + value);
    }

    public void addKernelOption(String key, String value, OPTION_KEY variable) {
        this.addVariable(variable, value);
        this.addKernelOption(key, Option.varForm(variable));
    }

    public void addKernelOption(String option) {
        this.kernelOptions.add(option);
    }

    public static void createLaunchConfig(VMProperty property) throws VMWorkerException {
        List<IOption> optList = property.getPropertyValue().getOptionList();
        if (optList == null) {
            throw new VMWorkerException("Failed to get option list.");
        }
        LaunchConfig config = new LaunchConfig();
        for (IOption option : optList) {
            option.getLaunchArgument(config, property);
        }
        String configFilename = LaunchConfig.getLaunchConfigPath(property.getPropertyValue().vmName);
        config.writeFile(new File(configFilename));
    }

    public static String getLaunchConfigPath(String vmName) {
        String configDirectoryName = FilePathResources.getTizenSDKDataVmsPath() + File.separator + vmName;
        return configDirectoryName + File.separator + "vm_launch.conf";
    }

    private void writeFile(File file) throws VMWorkerException {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            bw.write("# Character encoding : " + System.getProperty("file.encoding"));
            bw.newLine();
            bw.newLine();
            bw.write(DEFAULT_VALUE);
            bw.newLine();
            String comment = null;
            String var = null;
            for (OPTION_KEY key : OPTION_KEY.values()) {
                comment = this.varComment.get(key.toString());
                if (comment != null) {
                    bw.write(comment);
                    bw.newLine();
                }
                if ((var = this.variables.get(key.toString())) == null) continue;
                bw.write(key.toString() + "=" + var);
                bw.newLine();
                this.variables.remove(key.toString());
            }
            for (String key : this.variables.keySet()) {
                comment = this.varComment.get(key);
                if (comment != null) {
                    bw.write(comment);
                    bw.newLine();
                }
                if ((var = this.variables.get(key)) == null) continue;
                bw.write(key.toString() + "=" + var);
                bw.newLine();
            }
            StringBuilder kernelOption = new StringBuilder("");
            for (String str : this.kernelOptions) {
                if (str.isEmpty()) continue;
                kernelOption.append(str).append(" ");
            }
            bw.write(OPTION_KEY.VAR_APPEND.toString() + "=\"" + kernelOption.toString().trim() + "\"");
            bw.newLine();
            if (this.skinOptions.size() > 0) {
                bw.newLine();
                bw.write(SKIN_OPTIONS);
                bw.newLine();
                for (String str : this.skinOptions) {
                    bw.write(str);
                    bw.newLine();
                }
            }
            bw.newLine();
            bw.write(QEMU_OPTIONS);
            bw.newLine();
            for (String str : this.qemuOptions.getContents()) {
                bw.write(str);
                bw.newLine();
            }
            bw.flush();
        }
        catch (IOException e) {
            EMLogger.getLogger().warning("Failed to create launch conf file." + e.getMessage());
            throw new VMWorkerException("Failed to create launch config file");
        }
    }

    public static List<String> readLaunchConfig(String vmName) {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(new File(LaunchConfig.getLaunchConfigPath(vmName))));){
            String readStr;
            while ((readStr = br.readLine()) != null) {
                list.add(readStr);
            }
        }
        catch (FileNotFoundException e) {
            EMLogger.getLogger().warning("Failed to read launch config file. " + e.getMessage());
        }
        catch (IOException e) {
            EMLogger.getLogger().warning("Failed to read launch config file. " + e.getMessage());
        }
        return list;
    }

    public static void loadTemplate(File file) {
        EMLogger.getLogger().info("called loadTemplate of LaunchConfig");
    }
}

