/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.ui.devicetemplate.controller.DisplaySizeViewController;
import org.tizen.emulator.manager.ui.devicetemplate.controller.ResolutionViewController;
import org.tizen.emulator.manager.ui.devicetemplate.controller.SkinShapeViewController;
import org.tizen.emulator.manager.ui.devicetemplate.controller.SkinViewController;
import org.tizen.emulator.manager.ui.devicetemplate.controller.TemplateCheckBoxController;
import org.tizen.emulator.manager.ui.devicetemplate.controller.TemplateNameViewController;
import org.tizen.emulator.manager.ui.tabview.controller.CheckLabelViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ComboViewController;
import org.tizen.emulator.manager.ui.tabview.controller.DeviceCheckBoxController;
import org.tizen.emulator.manager.ui.tabview.controller.DeviceComboViewController;
import org.tizen.emulator.manager.ui.tabview.controller.DeviceFileViewController;
import org.tizen.emulator.manager.ui.tabview.controller.DeviceTextViewController;
import org.tizen.emulator.manager.ui.tabview.controller.DeviceToggleButtonController;
import org.tizen.emulator.manager.ui.tabview.controller.FileViewController;
import org.tizen.emulator.manager.ui.tabview.controller.HiddenViewController;
import org.tizen.emulator.manager.ui.tabview.controller.LabelViewController;
import org.tizen.emulator.manager.ui.tabview.controller.TextViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ToggleButtonController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.template.Template;
import org.tizen.emulator.manager.ui.template.TemplateLoader;
import org.tizen.emulator.manager.ui.template.item.Group;
import org.tizen.emulator.manager.ui.template.item.Item;

public class DeviceTemplateViewHelper {
    private static final String DEVICE_TEMPLATE_UI_FILE = "device-template-ui.xml";
    private static final String DIALOG_XML_FILE_PREFIX = "devicetemplate-dialog-";
    public static final String DIALOG_XML_FILE_TIZEN = "devicetemplate-dialog-tizen.xml";
    public static final String DIALOG_XML_FILE_MOBILE = "devicetemplate-dialog-mobile.xml";
    public static final String DIALOG_XML_FILE_WEABLE = "devicetemplate-dialog-wearable.xml";
    public static final String DIALOG_XML_FILE_TV = "devicetemplate-dialog-tv.xml";
    public static final String DIALOG_XML_FILE_TIZEN_ROBOT_HEADED = "devicetemplate-dialog-tizen-robot-headed.xml";
    public static final String DIALOG_XML_FILE_TIZEN_ROBOT_HEADLESS = "devicetemplate-dialog-tizen-robot-headless.xml";
    private static final HashMap<String, Template> commonDeviceTemplateUI = new HashMap();

    public static List<Item> getDeviceTemplateItemList(Template template) {
        ArrayList<Item> items = new ArrayList<Item>();
        if (template == null) {
            return items;
        }
        List<Group> groupList = template.getGroups();
        for (Group group : groupList) {
            items.addAll(group.getItems());
        }
        return items;
    }

    private static String getProfileTemplatePath(String profile) {
        File commonDir = new File(FilePathResources.getPlatformCommonPath());
        if (commonDir.exists()) {
            return FilePathResources.getPlatformCommonPath() + File.separator + profile + FilePathResources.getPlatformDeviceTemplateUISuffix() + File.separator + DeviceTemplateViewHelper.getTemplateFileName(profile);
        }
        return FilePathResources.getToolEmulatorDataPath() + File.separator + DeviceTemplateViewHelper.getTemplateFileName(profile);
    }

    public static Template getPlatformDeviceTemplateUI(String platformPath) {
        return TemplateLoader.loadTemplate(new File(platformPath + File.separator + FilePathResources.getPlatformDeviceTemplateUISuffix() + File.separator + DEVICE_TEMPLATE_UI_FILE));
    }

    public static Template getProfileDeviceTemplateUI(String profile) {
        String path = DeviceTemplateViewHelper.getProfileTemplatePath(profile);
        Template template = commonDeviceTemplateUI.get(path);
        if (template == null) {
            template = TemplateLoader.loadTemplate(new File(DeviceTemplateViewHelper.getProfileTemplatePath(profile)));
            commonDeviceTemplateUI.put(path, template);
        }
        return template;
    }

    private static String getTemplateFileName(String profile) {
        String fileName = "";
        fileName = profile.equals("tizen") ? fileName + DIALOG_XML_FILE_TIZEN : (profile.equals("tv") ? fileName + DIALOG_XML_FILE_TV : (profile.equals("wearable") ? fileName + DIALOG_XML_FILE_WEABLE : (profile.equals("tizen-robot-headed") ? fileName + DIALOG_XML_FILE_TIZEN_ROBOT_HEADED : (profile.equals("tizen-robot-headless") ? fileName + DIALOG_XML_FILE_TIZEN_ROBOT_HEADLESS : fileName + DIALOG_XML_FILE_MOBILE))));
        return fileName;
    }

    public static List<ViewItemController> getViewItemList(List<Item> list) {
        ArrayList<ViewItemController> itemList = new ArrayList<ViewItemController>();
        for (Item item : list) {
            ViewItemController itemController = DeviceTemplateViewHelper.findViewItem(item, null);
            if (itemController == null) continue;
            if (!item.getSubItems().isEmpty()) {
                DeviceTemplateViewHelper.setSubViewItemList(itemController, item.getSubItems());
            }
            itemController.makeViewItem();
            itemList.add(itemController);
        }
        return itemList;
    }

    private static ViewItemController findViewItem(Item item, ViewItemController parent) {
        ViewItemController viewItem = null;
        String name = item.getName();
        String type = item.getType();
        if (item.isExperimental() || !item.isSupportOS()) {
            return viewItem;
        }
        if (name.equals("name")) {
            viewItem = new TemplateNameViewController(item);
        } else if (name.equals("resolution")) {
            viewItem = new ResolutionViewController(item);
        } else if (name.equals("size")) {
            viewItem = new DisplaySizeViewController(item);
        } else if (name.equals("skin")) {
            viewItem = new SkinViewController(item);
        } else if (name.equals("skinShape")) {
            viewItem = new SkinShapeViewController(item);
        } else if (name.equals("sensor")) {
            viewItem = new CheckLabelViewController(item);
        } else if (name.equals("connectivity")) {
            viewItem = new CheckLabelViewController(item);
        } else if (name.equals("camera")) {
            viewItem = new CheckLabelViewController(item);
        } else if (type.equals("combo")) {
            viewItem = new ComboViewController(item, parent);
        } else if (type.equals("textInput") || type.equals("text")) {
            viewItem = new TextViewController(item, parent);
        } else if (type.equals("toggle")) {
            viewItem = new ToggleButtonController(item, parent);
        } else if (type.equals("label")) {
            viewItem = new LabelViewController(item, parent);
        } else if (type.equals("checkLabel")) {
            viewItem = new CheckLabelViewController(item);
        } else if (type.equals("checkbox")) {
            viewItem = new TemplateCheckBoxController(item, parent);
        } else if (type.equals("file")) {
            viewItem = new FileViewController(item, parent);
        } else if (type.equals("hidden")) {
            viewItem = new HiddenViewController(item);
        } else if (type.equals("device-combo")) {
            viewItem = new DeviceComboViewController(item, parent);
        } else if (type.equals("device-textInput")) {
            viewItem = new DeviceTextViewController(item, parent);
        } else if (type.equals("device-toggle")) {
            viewItem = new DeviceToggleButtonController(item, parent);
        } else if (type.equals("device-checkbox")) {
            viewItem = new DeviceCheckBoxController(item, parent);
        } else if (type.equals("device-file")) {
            viewItem = new DeviceFileViewController(item, parent);
        }
        return viewItem;
    }

    public static void setSubViewItemList(ViewItemController parent, List<Item> list) {
        for (Item i : list) {
            ViewItemController item = DeviceTemplateViewHelper.findViewItem(i, parent);
            if (item == null) continue;
            item.makeViewItem();
            parent.addSubViewItem(item);
        }
    }
}

