/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.option.IOption;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;

public abstract class Option
implements IOption {
    protected static final String DISPLAY = "-display";
    private static Map<Class<? extends IOption>, IOption> instanceMap = new HashMap<Class<? extends IOption>, IOption>();

    public static <T> IOption getInstance(Class<? extends IOption> type) {
        IOption opt = instanceMap.get(type);
        if (opt == null) {
            try {
                opt = type.newInstance();
                instanceMap.put(type, opt);
            }
            catch (InstantiationException e) {
                EMLogger.getLogger().log(Level.SEVERE, e.getMessage());
            }
            catch (IllegalAccessException e) {
                EMLogger.getLogger().log(Level.SEVERE, e.getMessage());
            }
        }
        return opt;
    }

    public static String varForm(OPTION_KEY key) {
        return "${" + key.toString() + "}";
    }

    public static String varForm(String var) {
        return "${" + var + "}";
    }

    public static boolean checkOnOff(String value) {
        if (value.toLowerCase().equals("on")) {
            return true;
        }
        if (value.toLowerCase().equals("off")) {
            return false;
        }
        return value.isEmpty();
    }

    public boolean checkOn(String value) {
        return value.toLowerCase().equals("on");
    }

    public boolean checkOnOrEmpty(String value) {
        return Option.checkOnOff(value);
    }

    @Override
    public void checkArgument(VMProperty property) throws VMLauncherException {
    }

    public static boolean isGreaterThanOrEqualTo(String ver1, String ver2) {
        String[] versionComponents1 = ver1.split("\\.");
        String[] versionComponents2 = ver2.split("\\.");
        int length = Math.max(versionComponents1.length, versionComponents2.length);
        for (int i = 0; i < length; ++i) {
            int component2;
            int component1 = i < versionComponents1.length ? Integer.parseInt(versionComponents1[i]) : 0;
            int n = component2 = i < versionComponents2.length ? Integer.parseInt(versionComponents2[i]) : 0;
            if (component1 == component2) continue;
            return component1 > component2;
        }
        return true;
    }

    public static boolean isLesserThan(String ver1, String ver2) {
        String[] versionComponents1 = ver1.split("\\.");
        String[] versionComponents2 = ver2.split("\\.");
        int length = Math.max(versionComponents1.length, versionComponents2.length);
        for (int i = 0; i < length; ++i) {
            int component2;
            int component1 = i < versionComponents1.length ? Integer.parseInt(versionComponents1[i]) : 0;
            int n = component2 = i < versionComponents2.length ? Integer.parseInt(versionComponents2[i]) : 0;
            if (component1 == component2) continue;
            return component1 < component2;
        }
        return false;
    }

    public static boolean isEqual(String ver1, String ver2) {
        return ver1.equals(ver2);
    }
}

