/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.processor.ConsoleProcessor;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.resources.StringResources;
import org.tizen.emulator.manager.resources.FilePathResources;

class CreateBaseImage
extends Command {
    public CreateBaseImage() {
        this.commandString = "create-image";
        this.shortDescription = Messages.getString("Export.ShortDescription");
        this.description = Messages.getString("Export.Description");
        this.usage = Messages.getString("Export.Usage.1") + StringResources.NEW_LINE + Messages.getString("Export.Usage.2") + StringResources.NEW_LINE + Messages.getString("Export.Usage.3") + StringResources.NEW_LINE + Messages.getString("Export.Usage.4");
        Option name = new Option("n", "name", StringResources.DESC_EXPORT_NAME, "", true, true, "NAME");
        name.setShortUsage("-n <VM name>");
        this.optionList.add(name);
        this.optionList.add(new Option("d", "directory", StringResources.DESC_EXPORT_PATH, FilePathResources.getTizenSDKDataEmulatorPath(), false, true, "DIRECTORY"));
        this.optionList.add(new Option("c", "compress", StringResources.DESC_EXPORT_COMPRESS, "", false, false));
    }

    @Override
    public boolean process() {
        String name = null;
        String path = null;
        boolean useCompress = false;
        block5: for (Option c : this.optionList) {
            if (c.isInCommandLine()) {
                switch (c.getShortName().charAt(0)) {
                    case 'n': {
                        name = c.getCurrentValue();
                        continue block5;
                    }
                    case 'd': {
                        path = c.getCurrentValue();
                        continue block5;
                    }
                    case 'c': {
                        useCompress = true;
                        continue block5;
                    }
                }
                continue;
            }
            if (!c.getShortName().equals("d")) continue;
            path = c.getDefaultValue();
        }
        ConsoleProcessor processor = new ConsoleProcessor();
        return processor.createBaseIamge(name, path, useCompress);
    }
}

