/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import org.tizen.emulator.manager.EmulatorManager;
import org.tizen.emulator.manager.EmulatorManagerMode;
import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.CommandLineParser;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.SettingInfoFile;
import org.tizen.emulator.manager.vms.DisposableVMKeeper;

public class Main {
    private static CommandLineParser processor = null;

    private static void startConsoleProcessor() throws JAXBException {
        EmulatorManager.initialize(new DisposableVMKeeper());
        Command action = processor.getAction();
        if (!action.process()) {
            Main.exitEmulatorManager(2);
        } else {
            Main.exitEmulatorManager(0);
        }
    }

    private static void initializeLogger() {
        File logFile = new File(FilePathResources.getEmulatorManagerCLILogPath());
        EMLogger.makeBackupLog(Paths.get(logFile.getAbsolutePath(), new String[0]));
        EMLogger.getInstance().initialize();
        EMLogger.getInstance().setFileLogger(logFile);
        if (EmulatorManagerMode.isDebugMode()) {
            EMLogger.getInstance().setLevel(Level.ALL);
        } else {
            EMLogger.getInstance().setLevel(Level.INFO);
        }
        EMLogger.getLogger().info("Start Emulator Manager CLI!!");
    }

    public static void main(String[] args) {
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(new EMShutdownHook()));
            try {
                FilePathResources.initialize();
            }
            catch (IOException | IllegalStateException e1) {
                e1.printStackTrace();
            }
            Main.initializeLogger();
            processor = new CommandLineParser();
            processor.parseArgs(args);
            if (!SettingInfoFile.setMACaddr()) {
                Main.exitEmulatorManager(1);
            }
            Main.startConsoleProcessor();
        }
        catch (Throwable e) {
            e.printStackTrace();
            EMLogger.getLogger().warning("Throw exception: " + e.getMessage());
            EMLogger.printStackTrace(e);
            Main.exitEmulatorManager(1);
        }
    }

    static void exitEmulatorManager(int returnValue) {
        System.exit(returnValue);
    }

    private static class EMShutdownHook
    implements Runnable {
        private EMShutdownHook() {
        }

        @Override
        public void run() {
            EMLogger.getLogger().info("EMShutdownHook called");
        }
    }
}

