/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import java.util.ArrayList;
import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.resources.StringResources;
import org.tizen.emulator.manager.console.util.RemoteManagerCLI;

class RemoteListVM
extends Command {
    public RemoteListVM() {
        this.commandString = "remote-list-vm";
        this.description = Messages.getString("ActionList.RemoteListVM.0");
        this.usage = Messages.getString("ActionList.RemoteListVM.1");
        this.optionList.add(new Option("d", "detail", StringResources.DESC_LIST_VM_DETAIL, "", false, false));
        this.optionList.add(new Option("c", "count", StringResources.DESC_LIST_VM_COUNT, "", false, false));
        this.optionList.add(new Option("u", "user-account", StringResources.DESC_USER_ACCOUNT, "", true, true));
        this.optionList.add(new Option("e", "ip", StringResources.DESC_IP, "", true, true));
        this.optionList.add(new Option("l", "sdk-path-num", StringResources.DESC_SDK_PATH_NUM, "", false, true));
    }

    @Override
    public boolean process() {
        RemoteManagerCLI remoteManager = new RemoteManagerCLI();
        ArrayList<String> cmd = new ArrayList<String>();
        remoteManager.storeRemoteInfo(this.optionList);
        remoteManager.sshCmd(cmd);
        cmd.add("list-vm");
        for (Option c : this.optionList) {
            switch (c.getShortName().charAt(0)) {
                case 'd': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-d");
                    break;
                }
                case 'c': {
                    if (c.getCurrentValue().equals("")) break;
                    cmd.add("-c");
                    break;
                }
            }
        }
        return remoteManager.runRemoteCmd(cmd);
    }
}

