/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.vms.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.PopupControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.ui.control.ButtonToggleEvent;
import org.tizen.emulator.manager.ui.control.TizenCheckBox;
import org.tizen.emulator.manager.ui.controller.vms.filter.FilterListCell;

public class FilterPopup
extends PopupControl {
    private final SimpleObjectProperty<Button> saveButton;
    private final SimpleObjectProperty<Button> cancelButton;
    private static final String TOGGLE_ALL = "All Selection";
    private final TizenCheckBox toggleAllChbx = new TizenCheckBox("All Selection");
    private final ObservableList<TizenCheckBox> enumCombos;
    private static int BUTTON_HEIGHT = 30;
    private static int BUTTON_WIDTH = 72;
    private static int ROW_HEIGHT = 26;
    private static int ROW_MARGIN_HEIGHT = 3;
    private static int POPUP_WIDTH = 145;
    private final GridPane gridPane;
    private static boolean needCheckAll = true;

    public List<String> getFilterList() {
        ArrayList<String> filters = new ArrayList<String>();
        for (TizenCheckBox box : this.enumCombos) {
            if (!box.isSelected() || box.getText().equals(TOGGLE_ALL)) continue;
            filters.add(box.getText());
        }
        return filters;
    }

    public FilterPopup() {
        this.setHideOnEscape(true);
        this.setAutoHide(true);
        EventHandler<KeyEvent> cancelEvent = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ESCAPE) {
                    FilterPopup.this.hide();
                }
            }
        };
        Button sButton = new Button("OK");
        this.saveButton = new SimpleObjectProperty((Object)sButton);
        sButton.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)cancelEvent);
        sButton.setDefaultButton(true);
        sButton.setPrefSize((double)BUTTON_WIDTH, (double)BUTTON_HEIGHT);
        Button cButton = new Button("Cancel");
        this.cancelButton = new SimpleObjectProperty((Object)cButton);
        cButton.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)cancelEvent);
        cButton.setCancelButton(true);
        cButton.setPrefSize((double)BUTTON_WIDTH, (double)BUTTON_HEIGHT);
        cButton.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FilterPopup.this.hide();
            }
        });
        this.enumCombos = FXCollections.observableArrayList();
        this.gridPane = new GridPane();
        this.gridPane.getStyleClass().add((Object)"filter-popup");
        this.getScene().setRoot((Parent)this.gridPane);
        this.gridPane.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/view/filterPopup.css").toExternalForm());
    }

    public void setSaveEvent(EventHandler<ActionEvent> event) {
        ((Button)this.saveButton.get()).setOnAction(event);
    }

    public void createMenuItem(Map<String, Boolean> values) {
        this.enumCombos.clear();
        if (values != null) {
            this.toggleAllChbx.setPrefHeight(ROW_HEIGHT);
            this.toggleAllChbx.setSelected(false);
            this.toggleAllChbx.setOnSelected(new EventHandler<ButtonToggleEvent>(){

                public void handle(ButtonToggleEvent arg0) {
                    if (!needCheckAll) {
                        needCheckAll = true;
                        return;
                    }
                    FilterPopup.this.toggleAll(FilterPopup.this.toggleAllChbx.isSelected());
                }
            });
            this.showToggleAll(true);
            final SimpleIntegerProperty itemsChecked = new SimpleIntegerProperty();
            itemsChecked.addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    int itemsSel = newValue.intValue();
                    if (itemsSel == 0) {
                        FilterPopup.this.toggleAllChbx.setSelected(false);
                    } else if (itemsSel == FilterPopup.this.enumCombos.size() - 1) {
                        FilterPopup.this.toggleAllChbx.setSelected(true);
                    } else if (FilterPopup.this.toggleAllChbx.isSelected()) {
                        needCheckAll = false;
                        FilterPopup.this.toggleAllChbx.setSelected(false);
                    }
                }
            });
            for (String filterItem : values.keySet()) {
                final TizenCheckBox cb = new TizenCheckBox(filterItem);
                cb.setPrefHeight(ROW_HEIGHT);
                this.enumCombos.add((Object)cb);
                cb.setOnSelected(new EventHandler<ButtonToggleEvent>(){

                    public void handle(ButtonToggleEvent arg0) {
                        int currVal = itemsChecked.getValue();
                        itemsChecked.set(cb.isSelected() ? currVal + 1 : currVal - 1);
                    }
                });
            }
            for (TizenCheckBox cb : this.enumCombos) {
                for (String filterItem : values.keySet()) {
                    if (!cb.getText().equals(filterItem)) continue;
                    cb.setSelected(values.get(filterItem));
                }
            }
        }
        this.createView();
    }

    private void createView() {
        this.gridPane.getChildren().clear();
        final ListView list = new ListView(this.enumCombos);
        list.setCellFactory(FilterListCell.extractor());
        list.setEditable(false);
        list.setMaxHeight(215.0);
        list.setMaxWidth(400.0);
        list.setPrefWidth((double)POPUP_WIDTH);
        list.setPrefHeight((double)((ROW_HEIGHT + ROW_MARGIN_HEIGHT * 2) * Math.max(this.enumCombos.size(), 2)));
        list.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ESCAPE) {
                    list.getScene().getWindow().hide();
                }
            }
        });
        this.gridPane.add((Node)list, 0, 0);
        HBox buttons = new HBox();
        buttons.getStyleClass().add((Object)"h-box");
        buttons.setPrefWidth(-1.0);
        buttons.setPrefHeight(-1.0);
        buttons.setSpacing(1.0);
        buttons.setPadding(new Insets(0.0));
        if (OSUtil.isWin()) {
            buttons.getChildren().addAll((Object[])new Node[]{(Node)this.saveButton.get(), (Node)this.cancelButton.get()});
        } else {
            buttons.getChildren().addAll((Object[])new Node[]{(Node)this.cancelButton.get(), (Node)this.saveButton.get()});
        }
        this.gridPane.add((Node)buttons, 0, 1);
    }

    public void toggleAll(boolean selected) {
        for (int i = 0; i < this.enumCombos.size(); ++i) {
            TizenCheckBox ecb = (TizenCheckBox)this.enumCombos.get(i);
            ecb.setSelected(selected);
        }
    }

    public void showToggleAll(boolean showToggle) {
        if (showToggle) {
            if (this.enumCombos.isEmpty() || this.enumCombos.get(0) != this.toggleAllChbx) {
                this.enumCombos.add(0, (Object)this.toggleAllChbx);
            }
        } else if (!this.enumCombos.isEmpty() && this.enumCombos.get(0) == this.toggleAllChbx) {
            this.enumCombos.remove(0);
        }
    }
}

