/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.item;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventDispatcher;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.item.BaseViewItem;

public abstract class ViewItem {
    protected BaseViewItem baseView = null;
    protected Node modifyItem;
    protected Label label;
    protected boolean isLabeling = false;
    private ObjectProperty<EventDispatcher<Integer, Event>> eventDispatcher;

    public ViewItem() {
        this.baseView = new BaseViewItem();
    }

    public ViewItem(BaseViewItem baseView) {
        this.baseView = baseView;
    }

    public Pane getContent() {
        if (this.baseView != null) {
            return this.baseView.getBasePane();
        }
        return null;
    }

    public abstract String toString();

    public void setAsLabel(String text) {
        if (this.label == null) {
            this.label = new Label();
        }
        this.isLabeling = true;
        this.label.setText(text);
        this.label.setMaxWidth(Double.MAX_VALUE);
        if (this.modifyItem == null) {
            this.modifyItem = this.baseView.getViewItem();
        }
        this.baseView.setViewItem((Node)this.label);
    }

    public void setAsModifyItem() {
        if (this.modifyItem != null) {
            this.isLabeling = false;
            this.baseView.setViewItem(this.modifyItem);
        }
    }

    public void setTooltip(String msg) {
        if (this.baseView == null || this.baseView.getViewItem() == null) {
            return;
        }
        Node object = this.baseView.getViewItem();
        if (object instanceof Control) {
            Control con = (Control)object;
            con.setTooltip(new Tooltip(msg));
        }
    }

    public void setTitle(String title) {
        if (this.baseView != null) {
            this.baseView.setTitle(title);
        }
    }

    public void setState(STATE state, String msg) {
        if (this.baseView != null) {
            this.baseView.setState(state);
            this.baseView.setStateToolTip(msg);
        }
    }

    public void removeStateLabel() {
        if (this.baseView == null) {
            return;
        }
        this.baseView.removeStateLabel();
    }

    public void setTitleMinWidth(Double value) {
        this.baseView.setTitleMinWidth(value);
        this.baseView.updateLayout();
    }

    public void setPrefWidth(Double value) {
        this.baseView.setPrefWidth(value);
    }

    public void setPrefHeight(Double value) {
        this.baseView.setPrefHeight(value);
    }

    public void setVisible(boolean isVisible) {
        if (this.baseView != null) {
            this.baseView.getBasePane().setVisible(isVisible);
        }
    }

    public boolean isVisible() {
        if (this.baseView != null) {
            this.baseView.getBasePane().isVisible();
        }
        return false;
    }

    public void setEnable(boolean isEnable) {
        if (this.baseView != null) {
            if (this.baseView.getViewItem() != null) {
                this.baseView.getViewItem().setDisable(!isEnable);
            } else if (this.baseView.getContent() != null) {
                this.baseView.getContent().setDisable(!isEnable);
            }
        }
    }

    public boolean isEnabled() {
        if (this.baseView != null) {
            if (this.baseView.getViewItem() != null) {
                return !this.baseView.getViewItem().disabledProperty().get();
            }
            if (this.baseView.getContent() != null) {
                return !this.baseView.getContent().disabledProperty().get();
            }
            return false;
        }
        return false;
    }

    protected void sendEvent(Event event) {
        this.getDispatcher().sendEvent(event.type, event);
    }

    public void addEventHandler(int type, EventHandler<Event> eventHandler) {
        this.getDispatcher().addEventHandler(type, eventHandler);
    }

    public void removeEventHandler(int type, EventHandler<Event> eventHandler) {
        this.getDispatcher().removeEventHandler(type, eventHandler);
    }

    private EventDispatcher<Integer, Event> getDispatcher() {
        if (this.eventDispatcher == null) {
            EventDispatcher dispatcher = new EventDispatcher();
            this.eventDispatcher = new SimpleObjectProperty((Object)this, "eventDispatcher", dispatcher);
        }
        return (EventDispatcher)this.eventDispatcher.get();
    }
}

