/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.tool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;

public class SettingInfoFile {
    private static Properties prop = null;
    private static String macAddr = "";
    private static String[] enumIfnames = new String[]{"eth0", "eth1"};
    private static String FILE_SAVE_FAIL = "Failed to save property file";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createPropertyFile(String path) {
        File f = new File(path);
        try {
            f.createNewFile();
        }
        catch (IOException e2) {
            prop = null;
            return;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(f);
        }
        catch (IOException e2) {
            prop = null;
            return;
        }
        BufferedWriter out = null;
        out = new BufferedWriter(writer);
        try {
            try {
                out.write("MAC_ADDRESS=" + StringResources.NEW_LINE);
            }
            catch (IOException e1) {
                prop = null;
                return;
            }
            finally {
                out.close();
            }
        }
        catch (IOException e) {
            prop = null;
            return;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            prop = null;
            return;
        }
        try {
            prop.load(inputStream);
        }
        catch (IOException e) {
            prop = null;
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            EMLogger.log(e.getMessage());
        }
    }

    public static String getMACaddr() {
        return macAddr;
    }

    private static NetworkInterface checkNIname() throws SocketException {
        NetworkInterface ni = null;
        for (String ifname : enumIfnames) {
            ni = NetworkInterface.getByName(ifname);
            if (ni == null) continue;
            return ni;
        }
        return ni;
    }

    private static void getMACaddrFromLinuxHost() throws SocketException {
        NetworkInterface ni = SettingInfoFile.checkNIname();
        if (ni == null) {
            Enumeration<NetworkInterface> enumNi = NetworkInterface.getNetworkInterfaces();
            if (enumNi != null) {
                while (enumNi.hasMoreElements()) {
                    ni = enumNi.nextElement();
                    if (ni.isLoopback() || ni.isVirtual()) continue;
                    SettingInfoFile.getHardwareAddressFromNI(ni);
                    break;
                }
            }
        } else {
            SettingInfoFile.getHardwareAddressFromNI(ni);
        }
    }

    private static void getMACaddrFromWindowsHost() throws UnknownHostException, SocketException {
        InetAddress addr = InetAddress.getLocalHost();
        if (addr == null) {
            return;
        }
        NetworkInterface ni = NetworkInterface.getByInetAddress(addr);
        if (ni != null) {
            SettingInfoFile.getHardwareAddressFromNI(ni);
        }
    }

    private static void getMACaddrFromMacHost() throws SocketException {
    }

    private static void getHardwareAddressFromNI(NetworkInterface ni) throws SocketException {
        byte[] mac = ni.getHardwareAddress();
        if (mac != null) {
            for (int i = 0; i < mac.length; ++i) {
                macAddr = macAddr + String.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : "");
            }
        }
        EMLogger.log(String.format("Network name = %s, MAC = %s", ni.getDisplayName(), macAddr));
    }

    private static String getMACaddrFromHost() {
        try {
            if (OSUtil.isLinux()) {
                SettingInfoFile.getMACaddrFromLinuxHost();
            } else if (OSUtil.isWin()) {
                SettingInfoFile.getMACaddrFromWindowsHost();
            } else if (OSUtil.isMac()) {
                SettingInfoFile.getMACaddrFromMacHost();
            }
        }
        catch (SocketException e) {
            EMLogger.log(String.format("Failed to get MAC address of host: %s", e.getMessage()));
        }
        catch (UnknownHostException e) {
            EMLogger.log(String.format("Failed to get MAC address of host: %s", e.getMessage()));
        }
        return macAddr;
    }

    public static boolean setMACaddr() {
        String infoFilePath = null;
        infoFilePath = FilePathResources.getTizenSDKDataVmsPath() + File.separator + ".tizen-em-info";
        if (prop == null) {
            prop = new Properties();
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(infoFilePath);
        }
        catch (FileNotFoundException e2) {
            EMLogger.log(e2.getMessage());
            SettingInfoFile.createPropertyFile(infoFilePath);
        }
        if (inputStream != null) {
            try {
                if (prop != null) {
                    prop.load(inputStream);
                }
            }
            catch (IOException e) {
                prop = null;
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                EMLogger.log(e.getMessage());
            }
        }
        if (prop != null) {
            FileOutputStream outputStream;
            macAddr = prop.getProperty("MAC_ADDRESS");
            if (macAddr == null) {
                macAddr = "";
                macAddr = SettingInfoFile.getMACaddrFromHost();
                if (macAddr != null) {
                    prop.setProperty("MAC_ADDRESS", macAddr);
                    outputStream = null;
                    try {
                        outputStream = new FileOutputStream(infoFilePath);
                    }
                    catch (FileNotFoundException e1) {
                        EMLogger.log(FILE_SAVE_FAIL + ": " + e1.getMessage());
                    }
                    if (outputStream != null) {
                        try {
                            prop.store(outputStream, null);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            EMLogger.log(e.getMessage());
                        }
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            EMLogger.log(e.getMessage());
                        }
                    }
                }
            } else if (macAddr.isEmpty()) {
                macAddr = SettingInfoFile.getMACaddrFromHost();
                if (macAddr != null) {
                    prop.setProperty("MAC_ADDRESS", macAddr);
                    outputStream = null;
                    try {
                        outputStream = new FileOutputStream(infoFilePath);
                    }
                    catch (FileNotFoundException e1) {
                        EMLogger.log(FILE_SAVE_FAIL + ": " + e1.getMessage());
                    }
                    if (outputStream != null) {
                        try {
                            prop.store(outputStream, null);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            EMLogger.log(e.getMessage());
                        }
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            EMLogger.log(e.getMessage());
                        }
                    }
                }
            } else {
                EMLogger.log(String.format("Use original MAC = %s", macAddr));
            }
        } else {
            return false;
        }
        return true;
    }

    public static void setLastTapIndex(int index) {
        SettingInfoFile.setProperty("LAST_TAB_INDEX", String.valueOf(index));
    }

    public static int getLastTapIndex() {
        int index = 0;
        String value = SettingInfoFile.getProperty("LAST_TAB_INDEX");
        try {
            index = Integer.parseInt(value);
        }
        catch (Exception e) {
            EMLogger.log("Failed to read last-tab-index from property file. " + e.getMessage());
            index = 0;
        }
        return index;
    }

    public static boolean setProperty(String name, String value) {
        String infoFilePath = null;
        infoFilePath = FilePathResources.getTizenSDKDataVmsPath() + File.separator + ".tizen-em-info";
        if (prop == null) {
            prop = new Properties();
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(infoFilePath);
        }
        catch (FileNotFoundException e2) {
            EMLogger.log(e2.getMessage());
            SettingInfoFile.createPropertyFile(infoFilePath);
        }
        if (inputStream != null) {
            try {
                if (prop != null) {
                    prop.load(inputStream);
                }
            }
            catch (IOException e) {
                prop = null;
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                EMLogger.log(e.getMessage());
            }
        }
        if (prop != null) {
            prop.setProperty(name, value);
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(infoFilePath);
            }
            catch (FileNotFoundException e1) {
                EMLogger.log(FILE_SAVE_FAIL + ": " + e1.getMessage());
            }
            if (outputStream != null) {
                try {
                    prop.store(outputStream, null);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    EMLogger.log(e.getMessage());
                }
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    EMLogger.log(e.getMessage());
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public static String getProperty(String name) {
        String infoFilePath = null;
        infoFilePath = FilePathResources.getTizenSDKDataVmsPath() + File.separator + ".tizen-em-info";
        if (prop == null) {
            prop = new Properties();
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(infoFilePath);
        }
        catch (FileNotFoundException e2) {
            EMLogger.log(e2.getMessage());
            SettingInfoFile.createPropertyFile(infoFilePath);
        }
        if (inputStream != null) {
            try {
                if (prop != null) {
                    prop.load(inputStream);
                }
            }
            catch (IOException e) {
                prop = null;
            }
            try {
                inputStream.close();
            }
            catch (IOException e) {
                EMLogger.log(e.getMessage());
            }
        }
        String value = null;
        if (prop != null) {
            value = prop.getProperty(name);
        }
        return value;
    }
}

