/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.devicetemplate.item;

import javafx.beans.value.ChangeListener;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import org.tizen.emulator.manager.ui.tabview.item.ComboViewItem;
import org.tizen.emulator.manager.vms.type.RESOLUTION;

public class ResolutionViewItem
extends ComboViewItem {
    TextField widthTextField;
    TextField heightTextField;
    static final int INPUT_WIDTH = 76;
    static final int INPUT_HEIGHT = 24;
    private static final String matchStr = "[ 0-9 ]";
    private static final int maxLen = 5;

    public ResolutionViewItem() {
        GridPane pane = (GridPane)this.getContent();
        pane.setVgap(10.0);
        HBox box = new HBox();
        box.setAlignment(Pos.CENTER_LEFT);
        pane.add((Node)box, 1, 1);
        this.widthTextField = new TextField(){

            public void replaceText(int start, int end, String inputText) {
                if (ResolutionViewItem.this.validate(inputText, this.getText())) {
                    super.replaceText(start, end, inputText);
                }
            }

            public void replaceSelection(String inputText) {
                if (ResolutionViewItem.this.validate(inputText, this.getText())) {
                    super.replaceSelection(inputText);
                }
            }
        };
        this.heightTextField = new TextField(){

            public void replaceText(int start, int end, String inputText) {
                if (ResolutionViewItem.this.validate(inputText, this.getText())) {
                    super.replaceText(start, end, inputText);
                }
            }

            public void replaceSelection(String inputText) {
                if (ResolutionViewItem.this.validate(inputText, this.getText())) {
                    super.replaceSelection(inputText);
                }
            }
        };
        this.widthTextField.setPrefSize(76.0, 24.0);
        this.heightTextField.setPrefSize(76.0, 24.0);
        Label xLabel = new Label("X");
        box.setSpacing(7.0);
        box.getChildren().addAll((Object[])new Node[]{this.widthTextField, xLabel, this.heightTextField});
        this.setPrefHeight(-1.0);
    }

    public void setResolution(RESOLUTION res) {
        this.widthTextField.setText(String.valueOf(res.getWidth()));
        this.heightTextField.setText(String.valueOf(res.getHeight()));
    }

    public void setOnWidthChanged(ChangeListener<String> listener) {
        this.widthTextField.textProperty().addListener(listener);
    }

    public void setOnHeightChanged(ChangeListener<String> listener) {
        this.heightTextField.textProperty().addListener(listener);
    }

    public void setWidth(String width) {
        this.widthTextField.setText(width);
    }

    public void setHeight(String height) {
        this.heightTextField.setText(height);
    }

    public String getWidth() {
        return this.widthTextField.getText();
    }

    public String getHeight() {
        return this.heightTextField.getText();
    }

    private boolean validate(String inputText, String text) {
        if (inputText.isEmpty()) {
            return true;
        }
        if (!inputText.matches(matchStr)) {
            return false;
        }
        return text.length() < 5;
    }
}

