/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventDispatcher;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.ui.template.item.Option;

public abstract class ViewItemController {
    protected Item item;
    protected MODE mode = MODE.CREATE;
    private STATE state = STATE.OK;
    private String labelName;
    protected ViewItemController parent;
    protected List<ViewItemController> subViewItem;
    private static EventDispatcher<String, ItemEvent> eventDispatcher = new EventDispatcher();
    private static EventDispatcher<String, ItemEvent> stateEventDispatcher = new EventDispatcher();

    public ViewItemController(Item item) {
        this(item, null);
    }

    public ViewItemController(Item item, ViewItemController parent) {
        this.item = item;
        this.parent = parent;
    }

    public abstract void makeViewItem();

    public abstract ViewItem getViewItem();

    public abstract void setViewItem(ViewItem var1);

    public abstract void setIntializeValue(PropertyValue var1);

    public abstract void setPropertyValue(PropertyValue var1);

    public abstract void checkValid();

    protected void onChangedValue(Event event) {
    }

    public void dispose() {
    }

    public void setMode(MODE mode) {
        this.mode = mode;
        if (this.subViewItem != null) {
            for (ViewItemController item : this.subViewItem) {
                item.setMode(mode);
            }
        }
    }

    public MODE getMode() {
        return this.mode;
    }

    protected void setState(STATE newState) {
        ItemEvent e = new ItemEvent(this.item.getName());
        e.oldState = this.state;
        e.newState = newState;
        this.state = newState;
        ViewItemController.sendStateChangeEvent(e);
    }

    public void setItemState(STATE newState, String message) {
        if (newState != STATE.OK) {
            this.getViewItem().setState(newState, message);
        } else if (this.state != STATE.OK) {
            this.getViewItem().setState(newState, "");
        }
        if (newState != this.state) {
            this.setState(newState);
        }
    }

    public STATE getState() {
        return this.state;
    }

    public String getName() {
        return this.item.getName();
    }

    public String getTitle() {
        return this.item.getTitle();
    }

    public String getType() {
        return this.item.getType();
    }

    protected Option findOption(String name) {
        for (Option o : this.item.getOptions()) {
            if (!o.getName().equals(name)) continue;
            return o;
        }
        return null;
    }

    public void addSubViewItem(ViewItemController item) {
        if (this.subViewItem == null) {
            this.subViewItem = new ArrayList<ViewItemController>();
        }
        this.subViewItem.add(item);
    }

    public void addSubViewItem(List<ViewItemController> items) {
        if (this.subViewItem == null) {
            this.subViewItem = new ArrayList<ViewItemController>();
        }
        this.subViewItem.addAll(items);
    }

    public ViewItemController getParent() {
        return this.parent;
    }

    public void setParent(ViewItemController parent) {
        this.parent = parent;
    }

    public void addModifiedListener(EventHandler<ItemEvent> eventHandler) {
        ViewItemController.addChangeEventHandler(this.getName(), eventHandler);
    }

    public static void sendChangeEvent(ItemEvent event) {
        eventDispatcher.sendEvent(event.name, event);
    }

    public static void addChangeEventHandler(String item, EventHandler<ItemEvent> eventHandler) {
        eventDispatcher.addEventHandler(item, eventHandler);
    }

    public static void removeChangeEventHandler(String item, EventHandler<ItemEvent> eventHandler) {
        eventDispatcher.removeEventHandler(item, eventHandler);
    }

    public static void sendStateChangeEvent(ItemEvent event) {
        stateEventDispatcher.sendEvent(event.name, event);
    }

    public static void addStateChangeEventHandler(String item, EventHandler<ItemEvent> eventHandler) {
        stateEventDispatcher.addEventHandler(item, eventHandler);
    }

    public static void removeStateChangeEventHandler(String item, EventHandler<ItemEvent> eventHandler) {
        stateEventDispatcher.removeEventHandler(item, eventHandler);
    }

    public static void removeAllStateChangeEventHandler() {
        stateEventDispatcher.clear();
    }

    public static void removeAllHandlers() {
        stateEventDispatcher.clear();
        eventDispatcher.clear();
    }

    public String getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }
}

