/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.tool;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.helper.HelperClass;
import org.tizen.emulator.manager.vms.helper.ProcessOutputReader;
import org.tizen.emulator.manager.vms.helper.ProcessResult;

@Deprecated
public class TapUtil {
    public static String BRIDGE_NAME = "bridge1";
    static String BRIDGE_OPTION = "--bridge";
    static String NETSH = "netsh.exe";
    private static int isDhcp = 0;
    private static String IF_OPER_STATUS_UP = "1";
    private static File TMP_SCRIPT_FILE = null;
    private static final String IPV4_REGEX = "(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))";
    private static Pattern IPV4_PATTERN = Pattern.compile("(([0-1]?[0-9]{1,2}\\.)|(2[0-4][0-9]\\.)|(25[0-5]\\.)){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))");

    public static String getCheckNetPath() {
        String checkNet = OSUtil.isWin() ? "check-net.exe" : "check-net";
        return FilePathResources.getEmulatorCheckToolPath() + File.separator + checkNet;
    }

    public static String getDevconPath() {
        return FilePathResources.getToolEmulatorBinPath() + File.separator + "devcon.exe";
    }

    public static String getBridgeFromDevice(String device) throws VMWorkerException {
        String result = null;
        if (OSUtil.isLinux()) {
            List<String> cmd = Arrays.asList("brctl", "show");
            ProcessResult res = HelperClass.runProcess(cmd);
            if (!res.isSuccess()) {
                throw new VMWorkerException(res.getResultMessage());
            }
            String parsedBridge = null;
            String parsedDevice = null;
            for (String line : res.getStdOutMsg()) {
                String[] arr = line.split("\\s+");
                if (arr.length == 4) {
                    parsedBridge = arr[0].trim();
                    parsedDevice = arr[3].trim();
                } else {
                    if (arr.length != 2 || !arr[0].isEmpty()) continue;
                    parsedDevice = arr[1].trim();
                }
                if (!device.equals(parsedDevice)) continue;
                result = parsedBridge;
            }
        }
        return result;
    }

    public static List<String> getDefaultGateway(String ifName) throws VMWorkerException {
        ArrayList<String> result = new ArrayList<String>();
        if (OSUtil.isLinux()) {
            List<String> cmd = Arrays.asList("ip", "route");
            ProcessResult res = HelperClass.runProcess(cmd);
            if (res.isSuccess()) {
                for (String str : res.getStdOutMsg()) {
                    String[] arr = str.split("\\s+");
                    if (ifName == null) {
                        if (arr.length < 3 || !arr[0].equals("default")) continue;
                        result.add(arr[2]);
                        continue;
                    }
                    if (arr.length < 5 || !arr[0].equals("default") || !arr[4].equals(ifName)) continue;
                    result.add(arr[2]);
                }
            } else {
                throw new VMWorkerException(res.getResultMessage());
            }
        }
        return result;
    }

    public static List<String> getBridgeList() throws VMWorkerException {
        ArrayList<String> result = new ArrayList<String>();
        if (OSUtil.isLinux()) {
            List<String> cmd = Arrays.asList("brctl", "show");
            ProcessResult res = HelperClass.runProcess(cmd);
            if (res.isSuccess()) {
                for (String str : res.getStdOutMsg()) {
                    String[] arr = str.split("\\s+");
                    if (arr.length > 4 || arr[0].isEmpty()) continue;
                    result.add(arr[0]);
                }
            } else {
                throw new VMWorkerException(res.getResultMessage());
            }
        }
        return result;
    }

    public static ArrayList<String> getTapList() {
        ArrayList<String> list = new ArrayList();
        if (OSUtil.isLinux()) {
            for (String tap : TapUtil.getTapListForLinux()) {
                try {
                    if (TapUtil.getBridgeFromDevice(tap) == null) continue;
                    list.add(tap);
                }
                catch (VMWorkerException e) {
                    EMLogger.getLogger().warning(e.getMessage());
                }
            }
        } else if (OSUtil.isWin()) {
            list = TapUtil.getTapListForWin2();
        } else if (OSUtil.isMac()) {
            list = TapUtil.getTapListForMac();
        }
        Collections.sort(list);
        return list;
    }

    private static ArrayList<String> getTapListForMac() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("auto");
        return result;
    }

    private static List<String> getTapListForLinux() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> cmd = Arrays.asList("ip", "tuntap");
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            EMLogger.getLogger().warning("Get tap list fail. Command returns fail:cmd : " + cmd.toString() + ", return : " + res.getExitValue());
        } else {
            for (String line : res.getStdOutMsg()) {
                String[] arr = line.split(":");
                if (arr.length <= 0) continue;
                result.add(arr[0].trim());
            }
        }
        return result;
    }

    @Deprecated
    private static List<String> getTapListForWin() {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList cmd = new ArrayList();
        ProcessBuilder pb = new ProcessBuilder("openvpn", "--show-adapters");
        int exitValue = 0;
        try {
            Process process = pb.start();
            List<String> stdOut = ProcessOutputReader.readStdOut(process, ((Object)cmd).toString());
            exitValue = process.waitFor();
            if (exitValue != 0) {
                EMLogger.getLogger().warning("Get tap list fail. Command returns fail:cmd : " + ((Object)cmd).toString() + ", return : " + exitValue);
            } else {
                for (String line : stdOut) {
                    String[] arr;
                    if (!line.contains("'") || (arr = line.split("'")).length < 2) continue;
                    result.add(arr[1].trim());
                }
            }
        }
        catch (IOException e) {
            EMLogger.getLogger().warning("Get tap list fail. " + e.getMessage());
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            EMLogger.getLogger().warning("Get tap list fail. " + e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getTapListForWin2() {
        ArrayList<String> tapNameList = new ArrayList<String>();
        ArrayList<String> tapIdList = TapUtil.getTapIdList();
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\Control\\Network\\{4D36E972-E325-11CE-BFC1-08002BE10318}";
        String key = "Connection";
        String value = "Name";
        WinReg.HKEYByReference regKey = null;
        try {
            String[] subKeys;
            regKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097);
            for (String subKey : subKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)regKey.getValue())) {
                for (String tapId : tapIdList) {
                    String[] subKeys2;
                    if (!subKey.equals(tapId)) continue;
                    for (String subKey2 : subKeys2 = Advapi32Util.registryGetKeys((WinReg.HKEY)root, (String)(topKey + "\\" + subKey))) {
                        String tapName;
                        if (!subKey2.equals(key) || (tapName = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey + "\\" + key), (String)value)) == null) continue;
                        EMLogger.getLogger().info("tapname added: " + tapName);
                        tapNameList.add(tapName);
                    }
                }
            }
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().info(e.getMessage());
        }
        finally {
            if (regKey != null) {
                Advapi32Util.registryCloseKey((WinReg.HKEY)regKey.getValue());
            }
        }
        return tapNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getTapIdList() {
        ArrayList<String> tapIdList = new ArrayList<String>();
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\Control\\Class\\{4D36E972-E325-11CE-BFC1-08002BE10318}";
        String value1 = "ComponentId";
        String value2 = "NetCfgInstanceId";
        WinReg.HKEYByReference regKey = null;
        try {
            String[] subKeys;
            regKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097);
            for (String subKey : subKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)regKey.getValue())) {
                try {
                    String compId = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey), (String)value1);
                    String tapId = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey), (String)value2);
                    if (compId == null || tapId == null || !compId.toLowerCase().startsWith("tap")) continue;
                    EMLogger.getLogger().info("tapId added: " + tapId);
                    tapIdList.add(tapId);
                }
                catch (Win32Exception e) {
                    EMLogger.getLogger().info(e.getMessage());
                }
            }
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().info(e.getMessage());
        }
        finally {
            if (regKey != null) {
                Advapi32Util.registryCloseKey((WinReg.HKEY)regKey.getValue());
            }
        }
        return tapIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTapInBridge(String tapName) throws VMWorkerException {
        boolean result = false;
        if (OSUtil.isWin()) {
            String foundTapId = null;
            ArrayList<String> tapIdList = TapUtil.getTapIdList();
            WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
            String topKey = "SYSTEM\\CurrentControlSet\\Control\\Network\\{4D36E972-E325-11CE-BFC1-08002BE10318}";
            String key = "Connection";
            String value = "Name";
            WinReg.HKEYByReference regKey = null;
            try {
                String[] valueArr;
                String[] subKeys;
                regKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097);
                for (String subKey : subKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)regKey.getValue())) {
                    for (String tapId : tapIdList) {
                        String[] subKeys2;
                        if (!subKey.equals(tapId)) continue;
                        for (String subKey2 : subKeys2 = Advapi32Util.registryGetKeys((WinReg.HKEY)root, (String)(topKey + "\\" + subKey))) {
                            String name;
                            if (!subKey2.equals(key) || (name = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey + "\\" + key), (String)value)) == null || !name.equals(tapName)) continue;
                            foundTapId = tapId;
                        }
                    }
                }
                EMLogger.getLogger().warning("found tapid: " + foundTapId);
                topKey = OSUtil.isWin8AndAbove() ? "SYSTEM\\CurrentControlSet\\services\\NdisImPlatform\\Linkage" : "SYSTEM\\CurrentControlSet\\services\\Bridge\\Linkage";
                value = "Route";
                for (String str : valueArr = TapUtil.registryGetStringArray(root, topKey, value)) {
                    if (!str.replace("\"", "").equals(foundTapId)) continue;
                    result = true;
                }
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning("Failed to check if tap exists in bridge or not" + e.getMessage());
            }
            finally {
                if (regKey != null) {
                    Advapi32Util.registryCloseKey((WinReg.HKEY)regKey.getValue());
                }
            }
        } else if (OSUtil.isLinux() && TapUtil.getBridgeFromDevice(tapName) != null) {
            result = true;
        }
        return result;
    }

    private static String[] registryGetStringArray(WinReg.HKEY hKey, String value) {
        return TapUtil.registryGetStringArray(hKey, null, value);
    }

    private static String[] registryGetStringArray(WinReg.HKEY hKey, String path, String value) {
        TreeMap values = null;
        values = path == null ? Advapi32Util.registryGetValues((WinReg.HKEY)hKey) : Advapi32Util.registryGetValues((WinReg.HKEY)hKey, (String)path);
        String[] resultArr = null;
        for (Map.Entry entry : values.entrySet()) {
            Object v;
            String val = (String)entry.getKey();
            if (!val.equals(value) || !((v = entry.getValue()) instanceof String[])) continue;
            resultArr = (String[])v;
            break;
        }
        EMLogger.getLogger().fine("Data in Registry " + path + ", " + value);
        if (resultArr == null) {
            return new String[0];
        }
        for (Iterator iterator : resultArr) {
            EMLogger.getLogger().fine((String)((Object)iterator));
        }
        return resultArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getNetmaskFromTap(String tapName) throws NumberFormatException, VMWorkerException {
        String netMask = "";
        if (OSUtil.isLinux()) {
            InterfaceAddress addr = TapUtil.getInterfaceIpInfo(tapName);
            if (addr == null) return netMask;
            return TapUtil.getNetMask(addr.getNetworkPrefixLength());
        }
        if (OSUtil.isWin() && TapUtil.isTapInBridge(tapName)) {
            String[] data;
            WinReg.HKEY key = TapUtil.getBridgeTcpipKey();
            if (key != null) {
                try {
                    data = TapUtil.registryGetStringArray(key, "SubnetMask");
                    if (data.length > 0) {
                        netMask = data[0];
                    }
                }
                catch (Win32Exception e) {
                    EMLogger.getLogger().warning(e.getMessage());
                }
                finally {
                    Advapi32Util.registryCloseKey((WinReg.HKEY)key);
                }
            }
            if (!netMask.isEmpty()) return netMask;
            key = TapUtil.getInterfaceTcpipKey(TapUtil.getBridgeId());
            if (key == null) return netMask;
            try {
                data = TapUtil.registryGetStringArray(key, "SubnetMask");
                if (data.length <= 0) return netMask;
                netMask = data[0];
                return netMask;
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning(e.getMessage());
                return netMask;
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)key);
            }
        }
        if (!OSUtil.isMac()) return netMask;
        String bridgeName = TapUtil.getBridgeNameForMac();
        if (bridgeName.isEmpty()) {
            return "";
        }
        List<String> cmd = Arrays.asList("/bin/sh", "-c", "ifconfig " + bridgeName + " | grep \"inet \" | awk '{print $4}'");
        ProcessResult res = HelperClass.runProcess(cmd);
        boolean isCommandSuccess = false;
        if (res.isSuccess()) {
            long ipAddress;
            for (String str : res.getStdOutMsg()) {
                isCommandSuccess = true;
                ipAddress = Long.parseLong(str.substring(2), 16);
                netMask = TapUtil.longToIpAddress(ipAddress);
                EMLogger.getLogger().info("netmask en0: " + netMask);
            }
            if (netMask.length() == 0) {
                isCommandSuccess = false;
                cmd = Arrays.asList("/bin/sh", "-c", "ifconfig bridge1 | grep \"inet \" | awk '{print $4}'");
                res = HelperClass.runProcess(cmd);
                if (res.isSuccess()) {
                    for (String str : res.getStdOutMsg()) {
                        isCommandSuccess = true;
                        ipAddress = Long.parseLong(str.substring(2), 16);
                        netMask = TapUtil.longToIpAddress(ipAddress);
                        EMLogger.getLogger().info("netmask bridge1: " + netMask);
                    }
                }
            }
        }
        if (res.isSuccess()) {
            if (isCommandSuccess) return netMask;
        }
        EMLogger.getLogger().warning(res.getResultMessage());
        return netMask;
    }

    private static String longToIpAddress(long ip) {
        StringBuilder sb = new StringBuilder(15);
        for (int i = 0; i < 4; ++i) {
            sb.insert(0, Long.toString(ip & 0xFFL));
            if (i < 3) {
                sb.insert(0, '.');
            }
            ip >>= 8;
        }
        return sb.toString();
    }

    private static WinReg.HKEY getBridgeTcpipKey() {
        WinReg.HKEY resultKey = null;
        String bridgeId = TapUtil.getBridgeId();
        if (bridgeId == null) {
            EMLogger.getLogger().warning("value is null");
            return resultKey;
        }
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\services\\Tcpip\\Parameters\\Interfaces";
        resultKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)(topKey + "\\" + bridgeId), (int)131097).getValue();
        return resultKey;
    }

    private static WinReg.HKEY getInterfaceTcpipKey(String ifId) {
        if (ifId == null) {
            return null;
        }
        WinReg.HKEY resultKey = null;
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\services\\Tcpip\\Parameters\\Interfaces\\" + ifId;
        try {
            resultKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097).getValue();
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        return resultKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setbridgeTcpipForWin(String interfaceClassID) throws VMWorkerException {
        WinReg.HKEY interfaceKey = TapUtil.getInterfaceTcpipKey(interfaceClassID);
        EMLogger.getLogger().info("set bridge's IP");
        EMLogger.getLogger().info("interfaceID: " + interfaceClassID);
        EMLogger.getLogger().info("bridgeID: " + TapUtil.getBridgeId());
        String interfaceName = TapUtil.getBridgeNameFromClassID(interfaceClassID);
        String dns = null;
        String ip = null;
        String gateway = null;
        String netmask = null;
        if (interfaceKey != null) {
            try {
                ProcessResult res;
                List<String> cmd;
                isDhcp = Advapi32Util.registryGetIntValue((WinReg.HKEY)interfaceKey, (String)"EnableDHCP");
                EMLogger.getLogger().info("DHCP: " + isDhcp);
                if (isDhcp == 0) {
                    String[] ips = TapUtil.registryGetStringArray(interfaceKey, "IPAddress");
                    if (ips.length > 0) {
                        ip = ips[0];
                    }
                    EMLogger.getLogger().info("ip: " + ip);
                    String[] gateways = TapUtil.registryGetStringArray(interfaceKey, "DefaultGateway");
                    if (gateways.length > 0) {
                        gateway = gateways[0];
                    }
                    EMLogger.getLogger().info("gateway: " + gateway);
                    String[] netmasks = TapUtil.registryGetStringArray(interfaceKey, "SubnetMask");
                    if (netmasks.length > 0) {
                        netmask = netmasks[0];
                    }
                    EMLogger.getLogger().info("netmask: " + netmask);
                } else if (isDhcp == 1) {
                    String dhcpIp = null;
                    String dhcpGateway = null;
                    String dhcpNetmask = null;
                    dhcpIp = Advapi32Util.registryGetStringValue((WinReg.HKEY)interfaceKey, (String)"DhcpIPAddress");
                    EMLogger.getLogger().info("DHCP ip: " + dhcpIp);
                    String[] gateways = TapUtil.registryGetStringArray(interfaceKey, "DhcpDefaultGateway");
                    if (gateways.length > 0) {
                        dhcpGateway = gateways[0];
                    }
                    EMLogger.getLogger().info("DHCP gateway: " + dhcpGateway);
                    dhcpNetmask = Advapi32Util.registryGetStringValue((WinReg.HKEY)interfaceKey, (String)"DhcpSubnetMask");
                    EMLogger.getLogger().info("DHCP netmask: " + dhcpNetmask);
                    if (!(dhcpIp == null || dhcpIp.isEmpty() || dhcpNetmask == null || dhcpNetmask.isEmpty() || dhcpGateway == null || dhcpGateway.isEmpty())) {
                        EMLogger.getLogger().info("disable using DHCP");
                        cmd = Arrays.asList(NETSH, "-c", "int", "ipv4", "set", "address", "\"name=" + interfaceName + "\"", "source=static", "address=" + dhcpIp, "mask=" + dhcpNetmask, "gateway=" + dhcpGateway, "gwmetric=0");
                        res = HelperClass.runProcess(cmd);
                        if (!res.isSuccess()) {
                            EMLogger.getLogger().warning("Failed to configure TCP/IP: " + res.getResultMessage());
                        }
                        EMLogger.getLogger().info("delete DHCP ip address");
                        cmd = Arrays.asList(NETSH, "interface", "ipv4", "delete", "address", interfaceName, "addr=" + dhcpIp, "gateway=all");
                        res = HelperClass.runProcess(cmd);
                        if (!res.isSuccess()) {
                            EMLogger.getLogger().warning(res.getResultMessage());
                        }
                    }
                }
                String val = Advapi32Util.registryGetStringValue((WinReg.HKEY)interfaceKey, (String)"NameServer");
                String[] arr = val.split(",");
                if (arr.length > 0) {
                    dns = arr[0];
                }
                EMLogger.getLogger().info("NameServer: " + dns);
                String bridgeName = TapUtil.getBridgeNameFromClassID(TapUtil.getBridgeId());
                EMLogger.getLogger().info("Bridge Name: " + bridgeName);
                if (isDhcp == 0) {
                    if (ip != null && !ip.isEmpty()) {
                        interfaceName = TapUtil.getBridgeNameFromClassID(interfaceClassID);
                        EMLogger.getLogger().info("delete ip address");
                        cmd = Arrays.asList(NETSH, "interface", "ipv4", "delete", "address", interfaceName, "addr=" + ip, "gateway=all");
                        res = HelperClass.runProcess(cmd);
                        if (!res.isSuccess()) {
                            EMLogger.getLogger().warning(res.getResultMessage());
                        }
                        EMLogger.getLogger().info("set ip to bridge network");
                        if (!(netmask == null || netmask.isEmpty() || gateway == null || gateway.isEmpty() || (res = HelperClass.runProcess(cmd = Arrays.asList(NETSH, "-c", "int", "ipv4", "set", "address", "\"name=" + bridgeName + "\"", "source=static", "address=" + ip, "mask=" + netmask, "gateway=" + gateway, "gwmetric=0"))).isSuccess())) {
                            EMLogger.getLogger().warning("Failed to configure TCP/IP: " + res.getResultMessage());
                        }
                    }
                } else if (isDhcp == 1) {
                    cmd = Arrays.asList(NETSH, "-c", "int", "ipv4", "set", "address", "\"name=" + bridgeName + "\"", "dhcp");
                    res = HelperClass.runProcess(cmd);
                    if (!res.isSuccess()) {
                        EMLogger.getLogger().warning("Failed to enable DHCP: " + res.getResultMessage());
                    }
                } else {
                    EMLogger.getLogger().warning("isDhcp is wrong value: " + isDhcp);
                }
                if (dns == null || dns.isEmpty() || (res = HelperClass.runProcess(cmd = Arrays.asList(NETSH, "interface", "ipv4", "set", "dnsservers", "\"name=" + bridgeName + "\"", "static", dns, "primary"))).isSuccess()) return;
                EMLogger.getLogger().warning("Failed to set DNS server: " + res.getResultMessage());
                return;
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning(e.getMessage());
                return;
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)interfaceKey);
            }
        } else {
            EMLogger.getLogger().warning("interface key is null");
        }
    }

    private static String getBridgeId() {
        String bridgeId = null;
        if (OSUtil.isWin()) {
            List<String> cmd = Arrays.asList(TapUtil.getCheckNetPath(), BRIDGE_OPTION);
            ProcessResult res = HelperClass.runProcess(cmd);
            boolean isCommandSuccess = false;
            if (res.isSuccess()) {
                for (String str : res.getStdOutMsg()) {
                    if (!str.startsWith("ClassID:")) continue;
                    String[] arr = str.split(": ");
                    bridgeId = arr[arr.length - 1];
                    break;
                }
            } else if (!res.isSuccess() || !isCommandSuccess) {
                EMLogger.getLogger().warning(res.getResultMessage());
            }
        } else {
            EMLogger.getLogger().warning("OS is not Windows!");
        }
        EMLogger.getLogger().info("bridgeId: " + bridgeId);
        return bridgeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getGatewayFromTap(String tapName) throws VMWorkerException {
        String gateway = "";
        if (OSUtil.isLinux()) {
            try {
                List<String> gwList = TapUtil.getDefaultGateway(tapName);
                if (gwList.size() != 1) return gateway;
                return gwList.get(0);
            }
            catch (VMWorkerException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
            return gateway;
        }
        if (OSUtil.isWin() && TapUtil.isTapInBridge(tapName)) {
            String[] data;
            WinReg.HKEY key = TapUtil.getBridgeTcpipKey();
            if (key != null) {
                try {
                    data = TapUtil.registryGetStringArray(key, "DefaultGateway");
                    if (data.length > 0) {
                        gateway = data[0];
                    }
                }
                catch (Win32Exception e) {
                    EMLogger.getLogger().warning(e.getMessage());
                }
                finally {
                    Advapi32Util.registryCloseKey((WinReg.HKEY)key);
                }
            }
            if (!gateway.isEmpty()) return gateway;
            key = TapUtil.getInterfaceTcpipKey(TapUtil.getBridgeId());
            if (key == null) return gateway;
            try {
                data = TapUtil.registryGetStringArray(key, "DefaultGateway");
                if (data.length <= 0) return gateway;
                gateway = data[0];
                return gateway;
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning(e.getMessage());
                return gateway;
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)key);
            }
        }
        if (!OSUtil.isMac()) return gateway;
        String bridgeName = TapUtil.getBridgeNameForMac();
        if (bridgeName.isEmpty()) {
            return "";
        }
        List<String> cmd = Arrays.asList("/bin/sh", "-c", "netstat -rn | grep " + bridgeName + " | grep ^default | awk '{print $2}'");
        ProcessResult res = HelperClass.runProcess(cmd);
        boolean isCommandSuccess = false;
        if (res.isSuccess()) {
            Iterator<String> iterator = res.getStdOutMsg().iterator();
            while (iterator.hasNext()) {
                String str = iterator.next();
                isCommandSuccess = true;
                gateway = str.trim();
                EMLogger.getLogger().info("gateway: " + gateway);
            }
            return gateway;
        }
        if (res.isSuccess()) {
            if (isCommandSuccess) return gateway;
        }
        EMLogger.getLogger().warning(res.getResultMessage());
        return gateway;
    }

    public static String getBridgeNameForMac() {
        if (TMP_SCRIPT_FILE == null || !TMP_SCRIPT_FILE.exists()) {
            String newLine = StringResources.NEW_LINE;
            String command = "#!/bin/sh" + newLine + "IF=\"\"" + newLine + "for x in `ifconfig | grep ^[a-zA-Z] | awk -F: '{print $1}'`;" + newLine + "do" + newLine + "   IF=`ifconfig $x | grep \"member: en0\"`" + newLine + "   if [ \"x$IF\" != \"x\" ]; then" + newLine + "      UP=`ifconfig $x | grep UP`" + newLine + "      if [ \"x$UP\" != \"x\" ]; then" + newLine + "         echo $x" + newLine + "      fi" + newLine + "   fi" + newLine + "done";
            TMP_SCRIPT_FILE = TapUtil.createTmpFileWithContent(command);
        }
        if (TMP_SCRIPT_FILE == null || !TMP_SCRIPT_FILE.exists()) {
            return "";
        }
        List<String> cmd = Arrays.asList("/bin/sh", TMP_SCRIPT_FILE.getAbsolutePath());
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            EMLogger.getLogger().info("Get bridge name fail : " + res.getResultMessage());
            return "";
        }
        List<String> result = res.getStdOutMsg();
        if (result.size() < 1) {
            EMLogger.getLogger().info("No bridge name available..");
            return "";
        }
        return result.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTmpFileWithContent(String content) {
        BufferedWriter writer = null;
        File file = null;
        try {
            file = File.createTempFile("tap", ".sh");
            file.deleteOnExit();
            writer = new BufferedWriter(new FileWriter(file));
            writer.append(content);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    public static String getDnsFromTap(String tapName) throws VMWorkerException {
        String dns = "";
        if (OSUtil.isLinux()) {
            dns = TapUtil.getDnsForLinux(tapName);
        } else if (OSUtil.isWin() && TapUtil.isTapInBridge(tapName)) {
            dns = TapUtil.getDnsForWin(tapName);
        } else if (OSUtil.isMac()) {
            dns = TapUtil.getDnsForMac(tapName);
        }
        return dns;
    }

    private static String getDnsForMac(String tapName) {
        String dnsServer = "";
        List<String> cmd = Arrays.asList("/bin/sh", "-c", "/usr/sbin/scutil --dns | grep nameserver\\[[0]*\\] | awk '{print $3}' | head -n 1");
        ProcessResult res = HelperClass.runProcess(cmd);
        boolean isCommandSuccess = false;
        if (res.isSuccess()) {
            for (String str : res.getStdOutMsg()) {
                isCommandSuccess = true;
                dnsServer = str.trim();
                EMLogger.getLogger().info("dns server: " + dnsServer);
            }
        } else if (!res.isSuccess() || !isCommandSuccess) {
            EMLogger.getLogger().warning(res.getResultMessage());
        }
        return dnsServer;
    }

    private static String getDnsForLinux(String tapName) {
        String brName = null;
        try {
            brName = TapUtil.getBridgeFromDevice(tapName);
        }
        catch (VMWorkerException e) {
            EMLogger.getLogger().warning("Get dns failed. " + e.getMessage());
            return "";
        }
        List<String> cmd = null;
        cmd = brName == null ? Arrays.asList("nm-tool") : Arrays.asList("nm-tool", brName);
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            EMLogger.getLogger().warning("Get dns failed. " + res.getResultMessage());
            return "";
        }
        for (String line : res.getStdOutMsg()) {
            String[] arr = line.split("\\s+");
            if (arr.length < 3 || !arr[1].trim().startsWith("DNS")) continue;
            return arr[2].trim();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDnsForWin(String tapName) {
        String dns = "";
        WinReg.HKEY key = TapUtil.getInterfaceTcpipKey(TapUtil.getBridgeId());
        if (key != null) {
            try {
                String val = Advapi32Util.registryGetStringValue((WinReg.HKEY)key, (String)"NameServer");
                String[] arr = val.split(",");
                if (arr.length > 0) {
                    dns = arr[0];
                }
            }
            catch (Win32Exception e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
            finally {
                Advapi32Util.registryCloseKey((WinReg.HKEY)key);
            }
        }
        return dns;
    }

    public static InterfaceAddress getInterfaceIpInfo(String ifName) {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (interfaces != null) {
                while (interfaces.hasMoreElements()) {
                    NetworkInterface current = interfaces.nextElement();
                    if (!current.getName().equals(ifName)) continue;
                    for (InterfaceAddress addr : current.getInterfaceAddresses()) {
                        if (!(addr.getAddress() instanceof Inet4Address)) continue;
                        return addr;
                    }
                }
            }
        }
        catch (SocketException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        return null;
    }

    public static String getNetMask(int maskLength) {
        StringBuilder netMaskAddr = new StringBuilder();
        int val = maskLength / 8;
        int mod = maskLength % 8;
        int count = 0;
        for (int i = 0; i < val; ++i) {
            if (i > 0) {
                netMaskAddr.append(".");
            }
            netMaskAddr.append("255");
            ++count;
        }
        if (mod != 0) {
            int modMask = 0;
            for (int i = 7; i > 7 - mod; --i) {
                modMask = (int)((double)modMask + Math.pow(2.0, i));
            }
            netMaskAddr.append(".").append(String.valueOf(modMask));
            ++count;
        }
        while (count < 4) {
            netMaskAddr.append(".0");
            ++count;
        }
        return netMaskAddr.toString();
    }

    public static String checkIPString(boolean widgetEnable, String ip, String title) {
        String errMsg = "";
        if (widgetEnable) {
            if (ip == null || ip.isEmpty()) {
                errMsg = title + " cannot be empty!";
            } else {
                boolean isMatch = IPV4_PATTERN.matcher(ip).matches();
                if (!isMatch) {
                    errMsg = title + " is invalid!";
                }
            }
        }
        return errMsg;
    }

    public static boolean checkIP(String ip) {
        return IPV4_PATTERN.matcher(ip).matches();
    }

    public static boolean nameNotExist(String tapName) {
        boolean isNotExist = true;
        List<String> tapList = null;
        if (OSUtil.isWin()) {
            tapList = TapUtil.getTapListForWin2();
        } else if (OSUtil.isLinux()) {
            tapList = TapUtil.getTapListForLinux();
        }
        if (tapList != null) {
            for (String str : tapList) {
                if (!str.equals(tapName)) continue;
                isNotExist = false;
                break;
            }
        }
        return isNotExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBridgeIpAddr(String tapName) throws VMWorkerException {
        String ipAddr = null;
        if (OSUtil.isLinux()) {
            InterfaceAddress ifAddr = TapUtil.getInterfaceIpInfo(tapName);
            if (ifAddr != null) {
                EMLogger.getLogger().info("get " + tapName + "'s IP");
                ipAddr = ifAddr.getAddress().getHostAddress();
            } else {
                EMLogger.getLogger().info("get bridge's IP");
                InterfaceAddress ifAddrBridge = TapUtil.getInterfaceIpInfo(BRIDGE_NAME);
                if (ifAddrBridge != null) {
                    ipAddr = ifAddrBridge.getAddress().getHostAddress();
                }
            }
        } else if (OSUtil.isWin() && TapUtil.isTapInBridge(tapName)) {
            WinReg.HKEY key = TapUtil.getInterfaceTcpipKey(TapUtil.getBridgeId());
            if (key != null) {
                try {
                    if (isDhcp == 0) {
                        String[] data = Advapi32Util.registryGetStringArray((WinReg.HKEY)key, (String)"IPAddress");
                        if (data.length > 0) {
                            ipAddr = data[0];
                        }
                    } else if (isDhcp == 1) {
                        ipAddr = Advapi32Util.registryGetStringValue((WinReg.HKEY)key, (String)"DhcpIPAddress");
                    } else {
                        EMLogger.getLogger().warning("isDhcp is wrong value: " + isDhcp);
                    }
                }
                catch (Win32Exception e) {
                    EMLogger.getLogger().warning(e.getMessage());
                }
                finally {
                    Advapi32Util.registryCloseKey((WinReg.HKEY)key);
                }
            }
            if (ipAddr == null) {
                EMLogger.getLogger().warning("Can't find host bridge IP");
                ipAddr = "";
            }
        } else if (OSUtil.isMac()) {
            String bridgeName = TapUtil.getBridgeNameForMac();
            if (bridgeName.isEmpty()) {
                return "";
            }
            List<String> cmd = Arrays.asList("/bin/sh", "-c", "ifconfig " + bridgeName + " | grep \"inet \" | awk '{print $2}'");
            ProcessResult res = HelperClass.runProcess(cmd);
            boolean isCommandSuccess = false;
            if (res.isSuccess()) {
                for (String str : res.getStdOutMsg()) {
                    isCommandSuccess = true;
                    ipAddr = str.trim();
                    EMLogger.getLogger().info("host IP en0: " + ipAddr);
                }
                if (ipAddr == null) {
                    isCommandSuccess = false;
                    cmd = Arrays.asList("/bin/sh", "-c", "ifconfig bridge1 | grep \"inet \" | awk '{print $2}'");
                    res = HelperClass.runProcess(cmd);
                    if (res.isSuccess()) {
                        for (String str : res.getStdOutMsg()) {
                            isCommandSuccess = true;
                            ipAddr = str.trim();
                            EMLogger.getLogger().info("host IP bridge1: " + ipAddr);
                        }
                    }
                }
            }
            if (!res.isSuccess() || !isCommandSuccess) {
                EMLogger.getLogger().warning(res.getResultMessage());
            }
        }
        if (ipAddr == null) {
            return "";
        }
        return ipAddr;
    }

    public static boolean isValidTap(String tapName) throws VMWorkerException {
        if (TapUtil.getGatewayFromTap(tapName).isEmpty()) {
            return false;
        }
        return !TapUtil.getNetmaskFromTap(tapName).isEmpty();
    }

    public static String getAvailableTapName() {
        List<String> list = null;
        if (OSUtil.isLinux()) {
            list = TapUtil.getTapListForLinux();
        } else if (OSUtil.isWin()) {
            list = TapUtil.getTapListForWin2();
        }
        String newName = "";
        if (list != null) {
            int i = 1;
            while (true) {
                newName = "tap" + String.valueOf(i);
                boolean nameIsSame = false;
                for (String tap : list) {
                    if (!newName.equals(tap)) continue;
                    nameIsSame = true;
                    break;
                }
                if (!nameIsSame) break;
                ++i;
            }
        }
        return newName;
    }

    public static boolean isWinBridgeExist() {
        boolean isExist = false;
        List<String> cmd = Arrays.asList(TapUtil.getCheckNetPath(), BRIDGE_OPTION);
        ProcessResult res = HelperClass.runProcess(cmd);
        boolean isCommandSuccess = false;
        if (res.isSuccess()) {
            for (String str : res.getStdOutMsg()) {
                if (!str.startsWith("Adapter Desc:")) continue;
                isExist = true;
                isCommandSuccess = true;
                break;
            }
        } else if (!res.isSuccess() || !isCommandSuccess) {
            EMLogger.getLogger().warning(res.getResultMessage());
        }
        return isExist;
    }

    public static boolean isWinBridgeOperating() throws VMLauncherException {
        boolean isOperating = false;
        String OPERATING_STATUS = "Operating Status:";
        List<String> cmd = Arrays.asList(TapUtil.getCheckNetPath(), BRIDGE_OPTION);
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            throw new VMLauncherException(res.getResultMessage());
        }
        for (String str : res.getStdOutMsg()) {
            if (!str.startsWith(OPERATING_STATUS)) continue;
            String operStatus = str.split(OPERATING_STATUS)[1].trim();
            EMLogger.getLogger().info(OPERATING_STATUS + operStatus);
            if (!operStatus.equals(IF_OPER_STATUS_UP)) break;
            isOperating = true;
            break;
        }
        return isOperating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassIDFromPnpInstanceID(String name) {
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\Control\\Network\\{4D36E972-E325-11CE-BFC1-08002BE10318}";
        String key = "Connection";
        String value = "PnpInstanceID";
        WinReg.HKEYByReference regKey = null;
        try {
            String[] subKeys;
            regKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097);
            for (String subKey : subKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)regKey.getValue())) {
                String[] subKeys2;
                for (String subKey2 : subKeys2 = Advapi32Util.registryGetKeys((WinReg.HKEY)root, (String)(topKey + "\\" + subKey))) {
                    String pnpInstanceID;
                    if (!subKey2.equals(key) || !Advapi32Util.registryValueExists((WinReg.HKEY)root, (String)(topKey + "\\" + subKey + "\\" + key), (String)value) || !(pnpInstanceID = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey + "\\" + key), (String)value)).equals(name)) continue;
                    String string = subKey;
                    return string;
                }
            }
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().info(e.getMessage());
        }
        finally {
            if (regKey != null) {
                Advapi32Util.registryCloseKey((WinReg.HKEY)regKey.getValue());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBridgeNameFromClassID(String classID) {
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\Control\\Network\\{4D36E972-E325-11CE-BFC1-08002BE10318}\\" + classID + "\\Connection";
        String value = "Name";
        WinReg.HKEYByReference regKey = null;
        try {
            regKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097);
            String string = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)topKey, (String)value);
            return string;
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().info(e.getMessage());
        }
        finally {
            if (regKey != null) {
                Advapi32Util.registryCloseKey((WinReg.HKEY)regKey.getValue());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPnpInstanceIDFromName(String name) {
        WinReg.HKEY root = WinReg.HKEY_LOCAL_MACHINE;
        String topKey = "SYSTEM\\CurrentControlSet\\Control\\Network\\{4D36E972-E325-11CE-BFC1-08002BE10318}";
        String key = "Connection";
        String value = "Name";
        String pnpInstanceID = "PnpInstanceID";
        WinReg.HKEYByReference regKey = null;
        try {
            String[] subKeys;
            regKey = Advapi32Util.registryGetKey((WinReg.HKEY)root, (String)topKey, (int)131097);
            for (String subKey : subKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)regKey.getValue())) {
                String[] subKeys2;
                for (String subKey2 : subKeys2 = Advapi32Util.registryGetKeys((WinReg.HKEY)root, (String)(topKey + "\\" + subKey))) {
                    String tapName;
                    if (!subKey2.equals(key) || !(tapName = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey + "\\" + key), (String)value)).equals(name)) continue;
                    String string = Advapi32Util.registryGetStringValue((WinReg.HKEY)root, (String)(topKey + "\\" + subKey + "\\" + key), (String)pnpInstanceID);
                    return string;
                }
            }
        }
        catch (Win32Exception e) {
            EMLogger.getLogger().info(e.getMessage());
        }
        finally {
            if (regKey != null) {
                Advapi32Util.registryCloseKey((WinReg.HKEY)regKey.getValue());
            }
        }
        return null;
    }

    public static List<String> getInterfaceListForLinux() {
        ArrayList<String> result = new ArrayList<String>();
        List<String> cmd = Arrays.asList("/bin/sh", "-c", "/bin/ls /sys/class/net | /bin/grep eth");
        ProcessResult res = HelperClass.runProcess(cmd);
        if (!res.isSuccess()) {
            EMLogger.getLogger().warning("Get tap list fail. Command returns fail:cmd : " + cmd.toString() + ", return : " + res.getExitValue());
            return null;
        }
        for (String line : res.getStdOutMsg()) {
            result.add(line.trim());
        }
        return result;
    }

    public static ArrayList<String> getInterfaceListForMac() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("en0");
        return result;
    }
}

