/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.tool;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tizen.emulator.manager.logging.EMLogger;

class UpdateChecker
implements Runnable {
    UpdateChecker() {
    }

    @Override
    public void run() {
        Class<?> managerClass = null;
        Class<?> componentEnum = null;
        try {
            managerClass = Class.forName("org.tizen.library.sdkmanager.SDKManager");
            componentEnum = Class.forName("org.tizen.library.sdkmanager.SDKManager$RequestComponent");
        }
        catch (ClassNotFoundException e) {
            EMLogger.getLogger().warning("Can not find class: " + e.getMessage());
            EMLogger.getLogger().warning("Can not check update available or not");
            return;
        }
        if (managerClass == null) {
            EMLogger.getLogger().warning("Can not find class 'SDKManager' class");
            EMLogger.getLogger().warning("Can not check update available or not");
            return;
        }
        if (componentEnum == null) {
            EMLogger.getLogger().warning("Can not find class 'RequestComponent' class");
            EMLogger.getLogger().warning("Can not check update available or not");
            return;
        }
        Method isUpdatableMethod = null;
        try {
            isUpdatableMethod = managerClass.getMethod("isUpdatable", componentEnum);
        }
        catch (NoSuchMethodException | SecurityException e) {
            EMLogger.getLogger().warning("Can not get 'isUpdatable' method " + e.getMessage());
        }
        if (isUpdatableMethod != null) {
            Object sdkManager = null;
            Object emulatorComponent = null;
            try {
                sdkManager = managerClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                EMLogger.getLogger().warning(e.getMessage());
                EMLogger.getLogger().info("Fail to create 'SDKManager' instance");
                return;
            }
            EMLogger.getLogger().info("Success to create 'SDKManager' instance");
            try {
                emulatorComponent = Enum.valueOf(componentEnum, "EMULATOR");
            }
            catch (IllegalArgumentException e) {
                EMLogger.getLogger().info("Fail to create 'RequestComponent.EMULATOR' enum");
                return;
            }
            EMLogger.getLogger().info("Success to create 'RequestComponent.EMULATOR' enum");
            try {
                boolean isUpdatable = false;
                isUpdatable = (Boolean)isUpdatableMethod.invoke(sdkManager, emulatorComponent);
                EMLogger.getLogger().info("Check SDK update : " + (isUpdatable ? "update available" : "no update"));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e1) {
                EMLogger.getLogger().warning(e1.getMessage());
                return;
            }
        }
    }
}

