/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.tizen.emulator.manager.Messages;
import org.tizen.emulator.manager.concurrent.overseer.CheckSDCard;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.tool.PortHelper;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.monitor.LaunchingMonitor;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.NetProxyOption;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;

public class VMLauncher {
    public static boolean launch(VMProperty property, boolean wait, String path) throws VMLauncherException {
        return VMLauncher.launch(property, wait, path, null);
    }

    public static boolean launch(VMProperty property, boolean wait, String path, List<String> overridingVars) throws VMLauncherException {
        List<String> cmd;
        Process process;
        VMLauncher.checkPortNumber();
        VMLauncher.checkDiskImage(property);
        VMLauncher.checkSkin(property);
        CheckSDCard.isSDCardChecked();
        String emulatorBinPath = path;
        if (emulatorBinPath == null || emulatorBinPath.isEmpty()) {
            emulatorBinPath = property.getPropertyValue().getPlatform().getEmulatorDirPath() + FilePathResources.getEmulatorBinSuffix();
        }
        if ((process = VMLauncher.launchInternal(property, cmd = VMLauncher.getCommand(property, overridingVars, emulatorBinPath), emulatorBinPath)) == null) {
            return false;
        }
        LaunchingMonitor monitor = new LaunchingMonitor(property, process);
        if (!wait) {
            monitor.asyncExecute();
            return true;
        }
        return monitor.execute();
    }

    private static void checkPortNumber() throws VMLauncherException {
        if (new PortHelper().getPortNo() == -1) {
            String error = Messages.getString("VMLauncher.PortError.0") + StringResources.NEW_LINE + Messages.getString("VMLauncher.PortError.1");
            throw new VMLauncherException(error);
        }
    }

    private static List<String> getCommand(VMProperty property, List<String> overridingVars, String emulatorBinPath) throws VMLauncherException {
        String binaryPath = emulatorBinPath + File.separator + VMLauncher.getBinary();
        String configPath = LaunchConfig.getLaunchConfigPath(property.getPropertyValue().vmName);
        if (!new File(configPath).exists()) {
            try {
                LaunchConfig.createLaunchConfig(property);
            }
            catch (VMWorkerException e) {
                EMLogger.getLogger().warning(e.getMessage());
                throw new VMLauncherException(Messages.getString("VMLauncher.ConfigError.0") + StringResources.NEW_LINE + e.getMessage());
            }
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(binaryPath);
        cmd.add("--conf");
        cmd.add(configPath);
        String hostProxy = "";
        try {
            hostProxy = NetProxyOption.getHostProxyCmd(property);
        }
        catch (VMWorkerException e) {
            EMLogger.printStackTrace(e);
        }
        if (!hostProxy.isEmpty()) {
            cmd.add("--" + OPTION_KEY.VAR_NETWORK_PROXY.toString());
            cmd.add(hostProxy);
        }
        if (overridingVars != null) {
            for (String s : overridingVars) {
                cmd.add(s);
            }
        }
        String commandLineCmd = "\"" + binaryPath + "\" --conf \"" + configPath + "\"" + (hostProxy.isEmpty() ? "" : " --" + OPTION_KEY.VAR_NETWORK_PROXY.toString() + " \"" + hostProxy + "\"");
        System.out.println("Launch command : " + commandLineCmd);
        EMLogger.getLogger().log(Level.INFO, "Starting Emulator Command : ");
        EMLogger.getLogger().log(Level.INFO, commandLineCmd);
        return cmd;
    }

    private static void checkDiskImage(VMProperty property) throws VMLauncherException {
        File child;
        if (property.getPropertyValue().useQCOW2() && !(child = new File(property.getPropertyValue().childImagePath)).exists()) {
            throw new VMLauncherException(Messages.getString("VMLauncher.ImageError.0") + StringResources.NEW_LINE + child.getAbsolutePath(), true);
        }
        for (String imagePath : property.getPropertyValue().getImagePathList()) {
            File base = new File(imagePath);
            if (base.exists()) continue;
            throw new VMLauncherException(Messages.getString("VMLauncher.ImageError.1") + StringResources.NEW_LINE + base.getAbsolutePath(), true);
        }
    }

    private static void checkSkin(VMProperty property) throws VMLauncherException {
        if (property.getPropertyValue().skin == null) {
            throw new VMLauncherException(Messages.getString("VMLauncher.SkinError.0"), true);
        }
    }

    private static String getBinary() {
        if (OSUtil.isWin()) {
            return "emulator.cmd";
        }
        return "emulator.sh";
    }

    private static Process launchInternal(VMProperty property, List<String> cmd, String binPath) throws VMLauncherException {
        String vmName = property.getPropertyValue().vmName;
        ProcessBuilder pb = new ProcessBuilder(cmd);
        EMLogger.getLogger().log(Level.INFO, "Command list for ProcessBuilder");
        EMLogger.getLogger().log(Level.INFO, cmd.toString());
        pb.redirectErrorStream(true);
        pb.redirectOutput(new File(FilePathResources.getEmulatorLogPath(vmName)));
        EMLogger.makeVMBackupLog(vmName);
        pb.directory(new File(binPath));
        Process process = null;
        try {
            process = pb.start();
        }
        catch (IOException e) {
            EMLogger.getLogger().log(Level.WARNING, Messages.getString("VMLauncher.Error.0") + StringResources.NEW_LINE + e.getMessage());
            throw new VMLauncherException(e.getMessage());
        }
        return process;
    }
}

