/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import java.io.File;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;

public class BaseImageOption
extends Option {
    @Override
    public void getLaunchArgument(LaunchConfig config, VMProperty property) {
        if (property.getPropertyValue().getPlatform() != null) {
            config.addVariable(OPTION_KEY.VAR_IMAGE_VER, property.getPropertyValue().getImageBinaryVersion());
        }
        int driveIndex = 0;
        if (property.getPropertyValue().useQCOW2()) {
            config.addVariableWithSpace(OPTION_KEY.VAR_DRIVE, "file=${vms_path}" + File.separator + "${vm_name}" + File.separator + "emulimg-${vm_name}." + BaseImageOption.varForm(OPTION_KEY.VAR_IMAGE_ARCH) + ",if=none,index=" + driveIndex++ + ",cache.no-flush=on");
            config.addQemuOption("-drive", BaseImageOption.varForm(OPTION_KEY.VAR_DRIVE) + ",id=drive");
            config.addQemuOption("-device", "virtio-blk-pci,drive=drive");
        } else {
            for (String rawImagePath : property.getPropertyValue().getImagePathList()) {
                String varDrive = OPTION_KEY.VAR_DRIVE.toString();
                if (driveIndex > 0) {
                    varDrive = varDrive + String.valueOf(driveIndex);
                }
                config.addVariableWithSpace(varDrive, "file=" + rawImagePath + ",if=none,index=" + driveIndex + ",cache.no-flush=on,format=raw");
                config.addQemuOption("-drive", BaseImageOption.varForm(varDrive) + ",id=" + varDrive);
                config.addQemuOption("-device", "virtio-blk-pci,drive=" + varDrive);
                ++driveIndex;
            }
        }
        config.addVariableWithSpace(OPTION_KEY.VAR_SWAP, "file=${vms_path}" + File.separator + "${vm_name}" + File.separator + "swap-${vm_name}.img,if=none,index=" + driveIndex);
        config.addQemuOption("-drive", BaseImageOption.varForm(OPTION_KEY.VAR_SWAP) + ",id=swap");
        config.addQemuOption("-device", "virtio-blk-pci,drive=swap");
    }
}

