@ECHO OFF

set argC=0
for %%x in (%*) do Set /A argC+=1
IF "%argC%" == "0" (
   echo Error: Argument missing. use '-h' for help.
   goto end
)

set sdk_path=%~dp0

setlocal enabledelayedexpansion
IF EXIST !sdk_path! (
	set em_path=!sdk_path!
) ELSE (
	set em_path=.
)

IF %em_path:~-1%==\ SET em_path=%em_path:~0,-1%

setlocal disabledelayedexpansion
set current_path=%CD%\em-cli.jar
set current_path_dir=%CD%

for /F "usebackq tokens=1,2* delims=: " %%V in (`mode con`) do (
    if .%%V==.Columns (
        set COLUMNS=%%W
        goto done
    )
)

:done

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: (W/A) In java 9, JAXB module should be added in run time.
:: But this is a temporary workaround because eventually
:: modules that are not resolved by default such as a JAXB
:: could be removed from the JDK.
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:: Changed JRE options to pick JAXB from jaxb-ri instead of JDK 
IF EXIST "%current_path%" (
	set jre_opt="--module-path="%current_path_dir%"\..\..\..\library\jaxb-ri\ --add-modules=ALL-MODULE-PATH -XX:+IgnoreUnrecognizedVMOptions"
) ELSE (
	set jre_opt="--module-path="%em_path%"\..\..\..\library\jaxb-ri\ --add-modules=ALL-MODULE-PATH -XX:+IgnoreUnrecognizedVMOptions"
)

IF EXIST "%JAVA_HOME%" (
	set javaExec=%JAVA_HOME%\bin\java
) ELSE (
	set javaExec=java
)
 
IF EXIST "%current_path%" (
	"%javaExec%" "%jre_opt%" -jar "%current_path%" %*
) ELSE (
	"%javaExec%" "%jre_opt%" -jar "%em_path%\em-cli.jar" %*
)

:end
