#!/bin/bash -x

TIZEN_KVM_SCRIPT=/etc/init.d/tizen-kvm-multi
if [ -f ${TIZEN_KVM_SCRIPT} ]
then
    echo "tizen-kvm-multi does exist. tizen-kvm does not need to be installed."
    exit 0;
fi

TIZEN_SDK_INSTALL_PATH=`echo ${INSTALLED_PATH}`
if [ -z "${TIZEN_SDK_INSTALL_PATH}" ]
then
echo "There is no TIZEN_SDK_PATH ENV"
exit 2;
fi

TMP_FILE=init_tizen-kvm.sh
echo "#!/bin/bash -ex" >> ${TMP_FILE}
echo "cp \"${TIZEN_SDK_INSTALL_PATH}/tools/emulator/etc/tizen-kvm\" /etc/init.d/" >> ${TMP_FILE}
echo "cp \"${TIZEN_SDK_INSTALL_PATH}/tools/emulator/etc/45-tizen-kvm.rules\" /lib/udev/rules.d/" >> ${TMP_FILE}
echo "/etc/init.d/tizen-kvm start" >> ${TMP_FILE}
if [ "ubuntu" = "${OS_NAME}" ] ; then
    echo "update-rc.d tizen-kvm defaults" >> ${TMP_FILE}
fi

chmod +x ${TMP_FILE}

if [ "${TSUDO}" != "" ] # since installer v2.27
then
    TSUDO_MSG="Enter your password to enable kvm module if your machine supports hardware virtualization."
    TMP_PATH="`pwd`/${TMP_FILE}"
    "${TSUDO}" -m "${TSUDO_MSG}" sh "${TMP_PATH}"
else
    GKSUDO=`which gksudo`
    if [ "${GKSUDO}" = "" ]
    then
        echo "there is no gksudo."
        sudo ./${TMP_FILE}
    else
        gksudo ./${TMP_FILE}
    fi
fi

rm ${TMP_FILE}

# run check-gl and show pop-up if using gallium driver.
CHECK_GL_CMD=${TIZEN_SDK_INSTALL_PATH}/tools/emulator/bin/check-gl

GL_WARNING_MSG="You are using invalid graphic card driver for the emulator.
You have to use the lastest vendor-provided graphic card driver.

For more information, see under ubuntu driver help page.
https://help.ubuntu.com/community/BinaryDriverHowto/ "

showGraphicDriverWarning()
{
    zenity --error --no-wrap --text="$GL_WARNING_MSG"
}

"$CHECK_GL_CMD"
RET=$?
echo "check_gl return : $RET"
if [ "$RET" = "0" ] ; then
    echo "check-gl ... OK."
elif [ "$RET" = "2" ] ; then
    # show warning dialog
    echo "check-gl ... fail."
    if [ "$INSTALLMANAGER_UI" = "GUI" ] ; then
        showGraphicDriverWarning
    else
        echo "Warning : $GL_WARNING_MSG"
    fi
fi
