/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.enventor.executer;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.HostUtil;
import org.tizen.nativecommon.ProjectUtil;
import org.tizen.nativecore.build.NativeCoreConfigurationManager;
import org.tizen.nativecore.enventor.Messages;

public class EDCEditorExecuter {
    private static final String cmdFormat = "%s %s %s %s";
    private static final String templateWizardArg = "--to";

    public static void executeTool(final IPath path, final boolean withTemplateWizard) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                HostUtil.returnExecute((String)EDCEditorExecuter.getCommand(path, withTemplateWizard), null, (boolean)false);
            }
        }).start();
    }

    public static String checkTool() {
        String msg = "";
        String tool = EDCEditorExecuter.getFullpathOfTool();
        if (!EDCEditorExecuter.isInstallation(tool)) {
            return NLS.bind((String)Messages.CANNOT_FIND_TOOL, (Object)tool);
        }
        tool = EDCEditorExecuter.getFullpathOfEflTool();
        if (!EDCEditorExecuter.isInstallation(tool)) {
            return NLS.bind((String)Messages.CANNOT_FIND_TOOL, (Object)tool);
        }
        return msg;
    }

    private static boolean isInstallation(String tool) {
        return new File(tool).exists();
    }

    private static String getCommand(IPath path, boolean withTemplateWizard) {
        String fullpathOfTool = EDCEditorExecuter.getFullpathOfTool();
        String env = EDCEditorExecuter.getEnv();
        IPath edj_path = path.removeFileExtension().addFileExtension("edj");
        String redirectStream = null;
        redirectStream = System.getProperty("os.name").startsWith("Windows") ? " 1> NUL 2> NUL" : " 1> /dev/null 2> /dev/null";
        if (withTemplateWizard) {
            return String.valueOf(String.format(cmdFormat, env, fullpathOfTool, path.toOSString(), edj_path.toOSString())) + " " + EDCEditorExecuter.getOptions(path) + " " + templateWizardArg + redirectStream;
        }
        return String.valueOf(String.format(cmdFormat, env, fullpathOfTool, path.toOSString(), edj_path.toOSString())) + " " + EDCEditorExecuter.getOptions(path) + redirectStream;
    }

    private static String[] trimOption(String[] option) {
        String[] trimOptions = new String[option.length];
        int i = 0;
        while (i < option.length) {
            trimOptions[i] = option[i].trim();
            ++i;
        }
        return trimOptions;
    }

    private static String getOptions(IPath path) {
        String autocompEet;
        String autocompDirPath;
        String autocompEetPath;
        TizenProjectDescription tizenDesc;
        String option = "";
        IFile projectFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (projectFile == null) {
            return null;
        }
        IProject project = projectFile.getProject();
        String workspaceDir = project.getLocation().toOSString();
        if (!workspaceDir.isEmpty()) {
            option = String.valueOf(option) + "-w " + workspaceDir + " ";
        }
        IConfiguration config = ProjectUtil.getDefaultConfiguration((IProject)project);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        IPath projectRelativePath = null;
        if (file != null) {
            projectRelativePath = file.getProjectRelativePath();
        }
        if (config != null && projectRelativePath != null) {
            String[] fontDirs = EDCEditorExecuter.trimOption(NativeCoreConfigurationManager.getEdcFontDirs((IConfiguration)config, (IPath)projectRelativePath));
            String[] imageDirs = EDCEditorExecuter.trimOption(NativeCoreConfigurationManager.getEdcImageDirs((IConfiguration)config, (IPath)projectRelativePath));
            String[] soundDirs = EDCEditorExecuter.trimOption(NativeCoreConfigurationManager.getEdcSoundDirs((IConfiguration)config, (IPath)projectRelativePath));
            int i = 0;
            while (i < fontDirs.length) {
                if (!fontDirs[i].isEmpty()) {
                    option = System.getProperty("os.name").startsWith("Windows") ? (fontDirs[i].charAt(0) == '\\' || fontDirs[i].charAt(0) == '\"' && fontDirs[i].charAt(1) == '\\' || fontDirs[i].length() >= 3 && fontDirs[i].charAt(1) == ':' && fontDirs[i].charAt(2) == '\\' || fontDirs[i].length() >= 4 && fontDirs[i].charAt(0) == '\"' && fontDirs[i].charAt(2) == ':' && fontDirs[i].charAt(3) == '\\' ? String.valueOf(option) + "--fd " + fontDirs[i] + " " : String.valueOf(option) + "--fd " + path.removeLastSegments(1) + "\\" + fontDirs[i] + " ") : (fontDirs[i].charAt(0) == '/' || fontDirs[i].charAt(0) == '\"' && fontDirs[i].charAt(1) == '/' ? String.valueOf(option) + "--fd " + fontDirs[i] + " " : String.valueOf(option) + "--fd " + path.removeLastSegments(1) + "/" + fontDirs[i] + " ");
                }
                ++i;
            }
            i = 0;
            while (i < imageDirs.length) {
                if (!imageDirs[i].isEmpty()) {
                    option = System.getProperty("os.name").startsWith("Windows") ? (imageDirs[i].charAt(0) == '\\' || imageDirs[i].charAt(0) == '\"' && imageDirs[i].charAt(1) == '\\' || imageDirs[i].length() >= 3 && imageDirs[i].charAt(1) == ':' && imageDirs[i].charAt(2) == '\\' || imageDirs[i].length() >= 4 && imageDirs[i].charAt(0) == '\"' && imageDirs[i].charAt(2) == ':' && imageDirs[i].charAt(3) == '\\' ? String.valueOf(option) + "--id " + imageDirs[i] + " " : String.valueOf(option) + "--id " + path.removeLastSegments(1) + "\\" + imageDirs[i] + " ") : (imageDirs[i].charAt(0) == '/' || imageDirs[i].charAt(0) == '\"' && imageDirs[i].charAt(1) == '/' ? String.valueOf(option) + "--id " + imageDirs[i] + " " : String.valueOf(option) + "--id " + path.removeLastSegments(1) + "/" + imageDirs[i] + " ");
                }
                ++i;
            }
            i = 0;
            while (i < soundDirs.length) {
                if (!soundDirs[i].isEmpty()) {
                    option = System.getProperty("os.name").startsWith("Windows") ? (soundDirs[i].charAt(0) == '\\' || soundDirs[i].charAt(0) == '\"' && soundDirs[i].charAt(1) == '\\' || soundDirs[i].length() >= 3 && soundDirs[i].charAt(1) == ':' && soundDirs[i].charAt(2) == '\\' || soundDirs[i].length() >= 4 && soundDirs[i].charAt(0) == '\"' && soundDirs[i].charAt(2) == ':' && soundDirs[i].charAt(3) == '\\' ? String.valueOf(option) + "--sd " + soundDirs[i] + " " : String.valueOf(option) + "--sd " + path.removeLastSegments(1) + "\\" + soundDirs[i] + " ") : (soundDirs[i].charAt(0) == '/' || soundDirs[i].charAt(0) == '\"' && soundDirs[i].charAt(1) == '/' ? String.valueOf(option) + "--sd " + soundDirs[i] + " " : String.valueOf(option) + "--sd " + path.removeLastSegments(1) + "/" + soundDirs[i] + " ");
                }
                ++i;
            }
        }
        if ((tizenDesc = org.tizen.common.util.ProjectUtil.getTizenProjectDescription((IProject)project)) == null) {
            return null;
        }
        String platformToolsPath = InstallPathConfig.getPlatformToolsPath((String)tizenDesc.getProfileName(), (String)tizenDesc.getVersion());
        if (platformToolsPath == null) {
            return null;
        }
        String edje_ccDirPath = FileUtil.appendPath((String)platformToolsPath, (String)"efl-tool/efl-tools/bin");
        String edje_ccPath = "";
        edje_ccPath = System.getProperty("os.name").startsWith("Windows") ? FileUtil.appendPath((String)edje_ccDirPath, (String)"edje_cc.exe") : FileUtil.appendPath((String)edje_ccDirPath, (String)"edje_cc");
        if (!edje_ccPath.isEmpty()) {
            option = String.valueOf(option) + "-e" + new Path(edje_ccPath).toOSString() + " ";
        }
        if (!(autocompEetPath = FileUtil.appendPath((String)(autocompDirPath = FileUtil.appendPath((String)EDCEditorExecuter.getFullpathOfEnventor(), (String)"share/enventor/autocomp")), (String)(autocompEet = String.valueOf(tizenDesc.getVersion()) + "-autocomp.eet"))).isEmpty()) {
            option = String.valueOf(option) + "-a" + new Path(autocompEetPath).toOSString() + " ";
        }
        if (tizenDesc.getVersion() != null && !tizenDesc.getVersion().isEmpty()) {
            option = String.valueOf(option) + "-z" + tizenDesc.getVersion() + " ";
        }
        return option;
    }

    private static String getDirectoryOfTool() {
        String dir = FileUtil.appendPath((String)InstallPathConfig.getToolsPath(), (String)"edc-editor/bin");
        Path path = new Path(dir);
        return path.toOSString();
    }

    private static String getFullpathOfTool() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return FileUtil.appendPath((String)EDCEditorExecuter.getDirectoryOfTool(), (String)"enventor.exe");
        }
        return FileUtil.appendPath((String)EDCEditorExecuter.getDirectoryOfTool(), (String)"enventor");
    }

    private static String getFullpathOfEflTool() {
        String dir = FileUtil.appendPath((String)InstallPathConfig.getToolsPath(), (String)"efl-tools");
        Path path = new Path(dir);
        return path.toOSString();
    }

    private static String getFullpathOfEnventor() {
        String dir = FileUtil.appendPath((String)InstallPathConfig.getToolsPath(), (String)"edc-editor");
        Path path = new Path(dir);
        return path.toOSString();
    }

    private static String getEnv() {
        String fullpathOfEflTool = EDCEditorExecuter.getFullpathOfEflTool();
        String fullpathOfEnventor = EDCEditorExecuter.getFullpathOfEnventor();
        if (System.getProperty("os.name").startsWith("Windows")) {
            String envFormat = "set path=%s;%s;%s && set FONTCONFIG_PATH=%s &&";
            String eflToolBin = FileUtil.appendPath((String)fullpathOfEflTool, (String)"bin");
            String enventorBin = FileUtil.appendPath((String)fullpathOfEnventor, (String)"bin");
            String fontconfigDir = FileUtil.appendPath((String)fullpathOfEflTool, (String)"etc/fonts");
            return String.format(envFormat, eflToolBin, enventorBin, "%path%", fontconfigDir);
        }
        if (System.getProperty("os.name").contains("OS X")) {
            String envFormat = "PATH=%s:$PATH DYLD_LIBRARY_PATH=%s:%s:$DYLD_LIBRARY_PATH FONTCONFIG_PATH=%s";
            String eflToolBin = FileUtil.appendPath((String)fullpathOfEflTool, (String)"bin");
            String eflToolLib = FileUtil.appendPath((String)fullpathOfEflTool, (String)"lib");
            String enventorLib = FileUtil.appendPath((String)fullpathOfEnventor, (String)"lib");
            String fontconfigDir = FileUtil.appendPath((String)fullpathOfEflTool, (String)"etc/fonts");
            return String.format(envFormat, eflToolBin, eflToolLib, enventorLib, fontconfigDir);
        }
        String envFormat = "PATH=%s:$PATH LD_LIBRARY_PATH=%s:%s:$LD_LIBRARY_PATH";
        String eflToolBin = FileUtil.appendPath((String)fullpathOfEflTool, (String)"bin");
        String eflToolLib = FileUtil.appendPath((String)fullpathOfEflTool, (String)"lib");
        String enventorLib = FileUtil.appendPath((String)fullpathOfEnventor, (String)"lib");
        return String.format(envFormat, eflToolBin, eflToolLib, enventorLib);
    }
}

