/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativecore.enventor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.DialogUtil;
import org.tizen.common.util.ProjectUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.nativecore.enventor.Messages;
import org.tizen.nativecore.enventor.executer.EDCEditorExecuter;

public class Launcher
implements IEditorLauncher {
    protected static Logger logger = LoggerFactory.getLogger(Launcher.class);
    private IProject tproject;

    public void open(IPath path) {
        this.open(path, false);
    }

    public void open(IPath path, boolean withTemplateWizard) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        if (file == null) {
            return;
        }
        this.tproject = file.getProject();
        String msg = EDCEditorExecuter.checkTool();
        TizenProjectDescription tizenDesc = ProjectUtil.getTizenProjectDescription((IProject)this.tproject);
        if (tizenDesc == null) {
            return;
        }
        String version = tizenDesc.getVersion();
        if (!StringUtil.isEmpty((CharSequence)msg)) {
            this.openWithDefaultEditor(file);
            if (System.getProperty("os.name").startsWith("Windows")) {
                DialogUtil.openMessageDialog((String)String.format("In Tizen %s, Enventor is not supported in Windows.", version));
            } else if (System.getProperty("os.name").contains("OS X")) {
                DialogUtil.openMessageDialog((String)String.format("In Tizen %s, Enventor is not supported in Mac OS X.", version));
            }
        } else if (version != null && Integer.parseInt(version.split("\\.")[0]) >= 5) {
            if (DialogUtil.openQuestionDialog((String)String.format(Messages.EDC_EDITOR_SUPPORT, version)) == 64) {
                this.openWithDefaultEditor(file);
            }
        } else {
            EDCEditorExecuter.executeTool(path, withTemplateWizard);
        }
    }

    private void openWithDefaultEditor(IFile file) {
        IWorkbenchPage activePage = SWTUtil.getActivePage();
        if (activePage == null) {
            return;
        }
        try {
            activePage.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.ui.DefaultTextEditor");
        }
        catch (PartInitException partInitException) {
            logger.error("Failed to open file by using TextEditor: " + file);
        }
    }
}

