=begin
 
 optparser.rb

Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.

Contact:
Taejun Ha <taejun.ha@samsung.com>
Jiil Hyoun <jiil.hyoun@samsung.com>
Donghyuk Yang <donghyuk.yang@samsung.com>
DongHee Yang <donghee.yang@samsung.com>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
- S-Core Co., Ltd
=end

require 'optparse'

def read_cfg (options)
    if options[:name].nil? then 
        options[:name] = get_value_from_file options[:cfg], "name"

        if options[:name].empty?
            options[:name] = "tizen-emulator-1.0.sb2"
        end
    end 
    if options[:arch].nil? then 
        options[:arch] = get_value_from_file options[:cfg], "arch"

        if options[:arch].empty?
            options[:arch] = "i386"
        end
    end 
    if options[:pkglist].nil? then 
        options[:pkglist] = get_value_from_file options[:cfg], "pkglist"

        if options[:pkglist].empty?
            options[:pkglist] = "./pkglist_arm"
        end
    end 
    if options[:gen].nil? then 
        options[:gen] = get_value_from_file options[:cfg], "generator"

        if options[:gen].empty?
            options[:gen] = "TizenPlatform"
        end
    end 
    if options[:ctrl].nil? then 
        options[:ctrl] = get_value_from_file options[:cfg], "controller"

        if options[:ctrl].empty?
            options[:ctrl] = "SBS"
        end
    end 
    if options[:protocol].nil? then 
        options[:protocol] = get_value_from_file options[:cfg], "default_protocol"

        if options[:protocol].empty?
            options[:protocol] = "deb"
        end
    end 
    if options[:url].nil? then 
        options[:url] = get_value_from_file options[:cfg], "default_url"

        if options[:url].empty?
            options[:url] = "ssh://165.213.180.233/home/slp2.0/debian/www/apt.open.test/i386 slp2-target main contrib non-free"
        end
    end 
    if options[:http_proxy].nil? then 
        options[:http_proxy] = get_value_from_file options[:cfg], "http_proxy"

        if options[:http_proxy].empty?
            options[:http_proxy] = nil
        end
    end 
    if options[:save].nil? then 
        options[:save] = true if get_value_from_file( options[:cfg], "save").strip =~ /true/i

        if options[:save].nil?
            options[:save] = false
        end
    end 
end 

def set_default (options)
    if options[:name].nil? then 
        options[:name] = "slp-emulator-1.0.sb2"
    end 
    if options[:arch].nil? then 
        options[:arch] = "i386"
    end 
    if options[:pkglist].nil? then 
        options[:pkglist] = "./pkglist_arm"
    end 
    if options[:gen].nil? then 
        options[:gen] = "TizenPlatform"
    end 
    if options[:ctrl].nil? then 
        options[:ctrl] = "SBS"
    end 
    if options[:protocol].nil? then 
        options[:protocol] = "deb"
    end 
    if options[:url].nil? then 
        options[:url] = "ssh://165.213.180.233/home/slp2.0/debian/www/apt.open.test/i386 slp2-target main contrib non-free"
    end 
    if options[:save].nil? then 
        options[:save] = false
    end 
end 


def option_parse 
    options = {}
    optparse = OptionParser.new do|opts|
        # Set a banner, displayed at the top
        # of the help screen.
        opts.banner = "Usage: rootstrap-gnerator -n <name> -a <arch> -l <packagelist> -g <generator> -t <controller> -u <default_url> -p <default_protocol> -c <cfg_file> -s <save>  -d <build configuration file>"

        # Define the options, and what they do
        opts.on( '-n', '--name <name>', 'name' ) do|name|
            options[:name] = name
        end

        opts.on( '-a', '--arch <arch>', 'architecture <arm/i386>' ) do|arch|
            options[:arch] = arch
        end

        opts.on( '-l', '--pkglist <package_list>', 'package list file' ) do|pkglist|
            options[:pkglist] = pkglist
        end

        opts.on( '-g', '--gen <image generator folder>', 'image generator type' ) do|gen|
            options[:gen] = gen
        end

        opts.on( '-t', '--ctrl <rootstrap controller folder>', 'rootstrap controller type' ) do|ctrl|
            options[:ctrl] = ctrl
        end

        opts.on( '-u', '--default_url <default_url>', 'package repository url list delemeta (\";\")') do|url|
            options[:url] = url
        end

        opts.on( '-x', '--http_proxy <http_proxy>', 'http proxy') do|http_proxy|
            options[:http_proxy] =  http_proxy
        end

		opts.on( '-p', '--default_protocol <default_protocol>', 'how to get package' ) do|protocol|
			options[:protocol] = protocol
		end

		opts.on( '-c', '--config <cfg_file>', 'config file' ) do|cfg|
			options[:cfg] = cfg
		end

		opts.on( '-s', '--save', 'save ctrl cache' ) do
			options[:save] = true
		end

		options[:dist] = nil
		opts.on( '-d', '--dist <configuration file>', '(build) configuration file' ) do|dist|
			options[:dist] = dist
		end

		# This displays the help screen, all programs are
		# assumed to have this option.
		opts.on( '-h', '--help', 'Display this information ' ) do
			puts opts
			exit
		end
	end

	$log.info "option parsing start" 
	$log.info "option is : " + ARGV * "," 

	optparse.parse!

	$log.info "option parsing end" 

	################# parameter error check start ######################

	options_path = $WORKING_DIR +  "/"
	if not options[:cfg].nil? then 
		if File.exist?(options[:cfg]) then
			$log.info "cfg file path is [#{options[:cfg]}]" 
			read_cfg options
			options_path = File.dirname(options[:cfg]) + "/"
		else
			$log.error "cfg file is not exist input : [#{options[:cfg]}]" 
			raise ArgumentError, "cfg file does not exist, your input is [#{options[:cfg]}]" 
		end 
	else 
		$log.info options_path
		set_default options
	end 

    if options[:name].nil? or options[:name].empty? then 
        $log.error "-n option is not setted"
        raise ArgumentError, "-n option is not setted"
	end 

	if options[:arch].nil? or options[:arch].empty? then 
		$log.error "-a option is not setted"
		raise ArgumentError, "-a option is not setted"
	end 

    if File.exist?(options_path + options[:pkglist]) then
        $log.info "pkglist file path is [#{options[:pkglist]}]" 
    else
        $log.warn "pkglist file is not exist input : [#{options[:pkglist]}]" 
    end 

    if File.directory?(File.dirname(__FILE__) + "/generators/#{options[:gen]}") then
        $log.info "generator path is [#{options[:gen]}]" 
    else
        $log.error " generator path is not exist input : [#{options[:gen]}]" 
        raise ArgumentError, "generator path path does not exist, your input is [#{options[:gen]}]" 
    end 

    if File.directory?(File.dirname(__FILE__) + "/controllers/#{options[:ctrl]}") then
        $log.info "controller path is [#{options[:ctrl]}]" 
    else
        $log.error "controller path is not exist input : [#{options[:ctrl]}]" 
        raise ArgumentError, "controller path does not exist, your input is [#{options[:ctrl]}]" 
    end 

    if options[:url].nil? or options[:url].empty? then 
        $log.error "-u option is not setted"
        raise ArgumentError, "-u option is not setted"
    else
        $log.info "default sources.list [deb " + options[:url] + "]"
    end 

    if options[:protocol].nil? or options[:protocol].empty? then 
        $log.error "-p option is not setted"
        raise ArgumentError, "-p option is not setted"
    end 

    if options[:save].nil? then 
        $log.error "-s option is not setted"
        raise ArgumentError, "-s option is not setted"
    end 

	if not options[:dist].nil? then
		#check using GBS controller
		if options[:ctrl] == "GBS" then
			#check file exist
			if not File.exist? options[:dist] then
				$log.error "#{options[:dist]} is not exist"
				raise ArgumentError, "#{options[:dist]} is not exist"
			end

			if File.exist? File.dirname(__FILE__) + "/controllers/#{options[:ctrl]}/dist.conf" then
				FileUtils.mv File.dirname(__FILE__) + "/controllers/#{options[:ctrl]}/dist.conf", File.dirname(__FILE__) + "/controllers/#{options[:ctrl]}/dist.conf_old", :force => true
			end

			if not File.exist? options[:dist] then
				FileUtils.mv File.dirname(__FILE__) + "/controllers/#{options[:ctrl]}/dist.conf_old", File.dirname(__FILE__) + "/controllers/#{options[:ctrl]}/dist.conf", :force => true
			else
				FileUtils.cp options[:dist], File.dirname(__FILE__) + "/controllers/#{options[:ctrl]}/dist.conf"
			end
		end
	end

    return options
end
