=begin
 
 rootstrap.rb

Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.

Contact:
Taejun Ha <taejun.ha@samsung.com>
Jiil Hyoun <jiil.hyoun@samsung.com>
Donghyuk Yang <donghyuk.yang@samsung.com>
DongHee Yang <donghee.yang@samsung.com>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
- S-Core Co., Ltd
=end

require 'fileutils'

require File.dirname(__FILE__) + "/default_controller"

class Rootstrap
    attr_accessor :name, :path, :arch, :base_pkg_list, :http_proxy, :url_list, :ctrl, :remove_pkg_list 
	@name = ""
	@arch = ""
	@path = ""
	@ctrl = nil

	# initialize rootstrap
	def initialize  ( name, arch, pkg_list, ctrl, url_list, http_proxy )
		@base_pkg_list = []
		@remove_pkg_list = []
		@name = name
		@arch = arch
        @http_proxy = http_proxy
        @url_list = url_list
		@ctrl = ctrl
		if "#{@ctrl.type}" == "OBS" then
			if not pkg_list[0] =~ /.*\.ks/ then
				$log.error "ks file is not exist"
				exit 1
			end
			@base_pkg_list = pkg_list
		else
			for pkg in pkg_list
				if pkg.remove then
					@remove_pkg_list.push pkg
				else
					@base_pkg_list.push pkg
				end
			end
		end
		@path = $WORKING_DIR + "/" + name
	end

	# get all package list installed
	def get_all_installed_packages
		ctrl.get_all_installed_packages
	end


	# get all file list in package
	def get_all_package_files(pkg_name)
		ctrl.get_all_package_files pkg_name
	end


	# get all dependent packages
	def get_all_dependent_packages(pkg_name)
		ctrl.get_all_dependent_packages pkg_name
	end

    def generate()
		$log.info "Initialize rootstrap using controller"
		if @ctrl.create_new_rootstrap( self ) == false then
			$log.error "Creating new rootstrap failed!"
			exit 1
		end


		$log.info "Install packages"
		if @ctrl.install_packages == false then
			$log.error "install failed"
			exit 1
		end

		$log.info "Remove unnecessary packages"
		@ctrl.remove_packages
    end

    def regenerate()
        $log.info "reinitialize rootstrap using controller"
        @ctrl.reload( self )
    end
end
