=begin
 
 OBS/controller.rb

Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.

Contact:
Taejun Ha <taejun.ha@samsung.com>
Jiil Hyoun <jiil.hyoun@samsung.com>
Donghyuk Yang <donghyuk.yang@samsung.com>
DongHee Yang <donghee.yang@samsung.com>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
- S-Core Co., Ltd
=end

require 'fileutils'

class RootstrapController
	@@installed = false
	@@zypper_initiated = false
    attr_accessor :type

	@rootstrap = nil
    @arch=""
    @obs_http_proxy=""

	def initialize
        @type = File.basename(File.dirname(__FILE__))
		# Let's assume OBS is installed
	end


	# create new rootstrap
	def create_new_rootstrap( rootstrap )
		@rootstrap = rootstrap
		@arch = @rootstrap.arch

		# check mic
		if `which mic`.empty? then
			$log.error "mic is not installed"
			exit 1
		end

		# extract base image into rootstrap path
		path = @rootstrap.path
		system "sudo rm -rf #{path}"
		system "mkdir -p #{path}"
		system "sudo rm -rf mic-output/*"

        if @rootstrap.http_proxy.nil? then
            @obs_http_proxy=nil
        else
            @obs_http_proxy=@rootstrap.http_proxy
        end
        # extract base image
        # system "fakeroot tar -xpf #{$WORKING_DIR}/baseimage_#{arch}.tar.gz -C #{path}"

	end


	# install packages
	def install_packages
		# install packages
		result = system "sudo mic create fs -A #{@arch} #{@rootstrap.base_pkg_list[0]} --pkgmgr=zypp"
		if not result then return result end
		result = system "sudo cp -r mic-output/#{@rootstrap.base_pkg_list[0][0..-4]}*/* #{@rootstrap.path}"
		if not result then return result end

		# copy binary interpreter for chroot
		if @arch.include? "arm" then
			qemu_path = `which qemu-arm-static`.strip
			if qemu_path.empty? then
				qemu_path = `which qemu-user-static`.strip
			end
			if not qemu_path.empty? then
				puts "Copying #{qemu_path} ..."
				system "sudo cp #{qemu_path} #{@rootstrap.path}/usr/bin"
			end
		end
		return result
	end


	# remove packages
	def remove_packages
		@rootstrap.remove_pkg_list.each do |pkg|
			command("rpm -e --nodeps #{pkg.name}")
		end
	end


    def reload ( rootstrap )
        @rootstrap = rootstrap
    end

	# get all package list installed
	def get_all_installed_packages
		result = []
		command_and_return("rpm -qa --queryformat=\\\"%{NAME}\\n\\\"").each_line do |line|
			result.push line.strip
        end

		return result
	end


	# get all file list in package
	def get_all_package_files(pkg_name)
		result = []
		command_and_return("rpm -ql #{pkg_name}").each_line do |line|
			file_path = line.strip!
			result.push file_path
		end

        return result
	end


	# get all dependent packages
	def get_all_dependent_packages(pkg_name)
		result = []
        command_and_return("zypper info --requires #{pkg_name}").each_line do |line|
            if not line.include? "(" and
				(line.include? "==" or line.include? ">=" or line.include? "<=") then
                #remove "Depends: (xxx) , "
                package = line.split("==")[0].strip
				result.push package
			end
        end

        return result
	end


	# get include search paths of package
	def get_include_search_paths_using_pkgconfig(pc_list)
		result = []

		# default search path
        result = ["/usr/include"]

        # get package Include list using pkg-config
		pc_list.each do |x|
			result = result |
				((command_and_return "pkg-config --cflags-only-I #{x}").split.map {|i| i.sub("-I","")})
		end

		# remove dup
		result.uniq!

        return result
	end


    # write self information to file that will save
    def write_info ( file_path )
    end


    # compare saved information file with self
    def same_as? ( file_path )
        return false
    end


	# PRIVATE METHODS/VARIABLES
	private

	# zypper install ...
	def install_using_zypper pkg
		# prepare for installation if first entered
		if not @@zypper_initiated  then
			initiated_zypper_installation(pkg.protocol, pkg.url)
			@@zypper_initiated = true
		end

		# execute zypper command
        case pkg.protocol
        when "rpm" then
            if not @obs_http_proxy.nil? then
                $log.info "export http_proxy=#{@obs_http_proxy}; zypper --non-interactive install #{pkg.name}"
                command "export http_proxy=#{@obs_http_proxy}; zypper --non-interactive install #{pkg.name}"
            else
                $log.info "zypper --non-interactive install #{pkg.name}"
                command "zypper --non-interactive install #{pkg.name}"
            end
		when "cp" then
			system("sudo cp #{pkg.url} #{@rootstrap.path}")
			$log.info "rpm --install ./#{File.basename(pkg.url)}"
			command "rpm --install ./#{File.basename(pkg.url)}"
			system("sudo rm -rf #{@rootstrap.path}/#{File.basename(pkg.url)}")

			# Reset package db information
			$log.info "rm -rf /var/lib/rpm/*"
			command "rm -rf /var/lib/rpm/*"
		else $log.warn "pkg protocol is unknown #{pkg.protocol}"
		end
	end


	# command to SBOX2 target
	def command(cmd)
		path = @rootstrap.path
		$log.info "sudo chroot #{@rootstrap.path} sh -c \"#{cmd}\""
		system "sudo chroot #{@rootstrap.path} sh -c \"#{cmd}\""
	end


	# return result of command
    def command_and_return(cmd)
		path = @rootstrap.path
		$log.info "sudo chroot #{@rootstrap.path} sh -c \"#{cmd}\""
		return `sudo chroot #{@rootstrap.path} sh -c \"#{cmd}\"`
    end
end

