=begin  
  
 TizenPublic/pcfile.rb 
 
Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved. 
 
Contact: 
Taejun Ha <taejun.ha@samsung.com> 
Jiil Hyoun <jiil.hyoun@samsung.com> 
Donghyuk Yang <donghyuk.yang@samsung.com> 
DongHee Yang <donghee.yang@samsung.com> 
 
Licensed under the Apache License, Version 2.0 (the "License"); 
you may not use this file except in compliance with the License. 
You may obtain a copy of the License at 
 
http://www.apache.org/licenses/LICENSE-2.0 
 
Unless required by applicable law or agreed to in writing, software 
distributed under the License is distributed on an "AS IS" BASIS, 
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
See the License for the specific language governing permissions and 
limitations under the License. 
 
Contributors: 
- S-Core Co., Ltd 
=end 

class PcFile 
    attr_accessor :name, :cflags_I, :cflags_other, :lflags_l, :lflags_L, :lflags_other, :description
    attr_accessor :parent 		# ref of parent package
    attr_accessor :alias_name 	# alias name
	attr_accessor :ignored		# ignored or not in public frameworks pages

    def initialize (pc_file_path)
        @name = pc_file_path.split('/')[-1][0..-4] #basename remove extension (.pc)
        @cflags_I = []
        @cflags_other = []
        @lflags_l = []
        @lflags_L = []
        @lflags_other = []
        @description = ""
		@alias_name = @name
		@ignored = false
		@parent = nil
	end


	def load_from_file(pc_file_path)

        File.open(pc_file_path,"r") do |f|
            doc = []
            f.each_line do |line|
                if line =~ /^\s*#/ then next end 

                doc.each do |d|
                    line.gsub!(d[0],d[1]) if line.include? d[0]
                end 
                # if line is macro like this "dest=src"
                if line =~ /=/ then  
                    l = line.strip.split('=') 
                    # about dest 
                    l[0] = "${" + l[0].strip + "}"

                    # about src
                    if l[1].nil? then 
                        l[1] = "" 
                    else 
                        l[1] = l[1].strip 
                    end 

                    #then l is likt this [${dest},src]
                    doc.push l
                end 

                #line is Cflags: xxxx then
                line_split = line.split(":")
                if line_split[1].nil? then next end 
                line_split[1].gsub!(","," ")
                line_split[1].strip!

                case line_split[0].strip
                when "Cflags" then  
                    line_split[1].split.each do |c| 
                        if c.strip.start_with?("-I") then 
                            include_path = c.strip.sub("-I","")
                            @cflags_I.push include_path
                        else 
                            @cflags_other.push c.strip
                        end 
                    end 
                when "Libs" then 
                    line_split[1].split.each do |l| 
                        if l.strip.start_with?("-l") then 
                            library = "lib" + l.strip.sub("-l","") + ".so"
                            @lflags_l.push library
                        elsif l.strip.start_with?("-L") then 
                            library_path = l.strip.sub("-L","")
                            @lflags_L.push library_path
                        else 
                            @lflags_other.push l.strip
                        end 
                    end 
                when "Description" then 
                    @description = line.sub(/Description[\t\s]*:/,"").strip
                end
            end 
            @cflags_I.uniq!
            @cflags_other.uniq!
            @lflags_l.uniq!
            @lflags_L.uniq!
            @lflags_other.uniq!
        end
    end 

    def print
        $log.info "name: #{@name}"
        $log.info "cflags_I: #{@cflags_I}"
        $log.info "cflag_other: #{@cflags_other}"
        $log.info "lflags_l: #{@lflags_l}"
        $log.info "lflags_L: #{@lflags_L}"
        $log.info "lflags_other: #{@lflags_other}"
        $log.info "description: #{@description}"
    end 

    #def macro_resolving(line)
    #    if (has_macro? line) then 
    #        macro.each do |mac|
    #            if line.contain(mac) then 
    #                line.gsub(mac.key,mac.value)
    #            end 
    #        end 
    #    end 
    #end 
end 
