=begin
 
 package.rb

Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.

Contact:
Taejun Ha <taejun.ha@samsung.com>
Jiil Hyoun <jiil.hyoun@samsung.com>
Donghyuk Yang <donghyuk.yang@samsung.com>
DongHee Yang <donghee.yang@samsung.com>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
- S-Core Co., Ltd
=end

class Package
    attr_accessor :name, :url, :header_list, :pc_file_list, :require_package_list, :protocol, :remove
    def initialize ( name, protocol ,url )
        @name = name
        @url = url
        @protocol = protocol
        @pc_file_list = []
        @header_list = []
        @require_package_list = []
        @remove = false
    end

	def Package.load_package_list_from_file (file, protocol)
		list = []
		case protocol
		when "mic" then
			return [file,"mic"]
		else
			if not File.exist? file  then
				return [];
			end
			File.open(file,"r") do |f|
				f.each_line do |line|
					# check install or remove
					if line.start_with?("-") then
						remove_flag = true
						line = line[1..-1]
					elsif line.start_with?("+") then
						remove_flag = false
						line = line[1..-1]
					else
						remove_flag = false
					end
					l = line.split(',')
					if l[0].empty? then
						$log.warn "blank is set in pkg_list"
					else
						if l[1].nil? then
							p = Package.new l[0].strip, protocol.strip, nil
						elsif l[2].nil? then
							p = Package.new l[0].strip, l[1].strip, nil
						else
							p = Package.new l[0].strip, l[1].strip, l[2].strip
						end
						p.remove = remove_flag
						list.push p
					end
				end
			end
			return list
		end
	end

    def ==(other)
        if  @name == other.name and @url == other.url and @protocol == other.protocol then return true
        else return false
        end
    end
end
