#!/usr/bin/ruby 
=begin
 
 rogen.rb

Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.

Contact:
Taejun Ha <taejun.ha@samsung.com>
Jiil Hyoun <jiil.hyoun@samsung.com>
Donghyuk Yang <donghyuk.yang@samsung.com>
DongHee Yang <donghee.yang@samsung.com>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
- S-Core Co., Ltd
=end

# A script that will pretend to resize a number of images
require 'fileutils'
require 'logger'

#library
require File.dirname(__FILE__) + "/util"
require File.dirname(__FILE__) + "/optparser"
require File.dirname(__FILE__) + "/rootstrapmanager"
require File.dirname(__FILE__) + "/package"
require File.dirname(__FILE__) + "/rootstrap"
require File.dirname(__FILE__) + "/image"



# set global variable
$HOME = `echo $HOME`.strip
$WORKING_DIR = `pwd`.strip

$log = Logger.new STDOUT

# This hash will hold all of the option
# parsed from the command-line by
# OptionParser.
begin
	option = option_parse
rescue => e
	$log.info "\n=============== Option parsing Error ========================"
	$log.info e.message
	$log.info "=============================================================\n\n"
	exit 0
end

# Load package list
pkglist = Package.load_package_list_from_file( option[:pkglist], option[:protocol] )

# create rootstrap
t = RootstrapManager.create(option[:name], option[:arch], pkglist, option[:ctrl], option[:url].split(","), option[:http_proxy], option[:save])

# load generator class
load File.dirname(__FILE__) + "/generators/" + option[:gen] + "/generator.rb"

# create new image
r = Image.new( t, ImageGenerator.new )
r.build

$log.info "!!!Image is generated!!!"
$log.info "========================================================"

