=begin
 
 defaut_controller.rb

Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.

Contact:
Taejun Ha <taejun.ha@samsung.com>
Jiil Hyoun <jiil.hyoun@samsung.com>
Donghyuk Yang <donghyuk.yang@samsung.com>
DongHee Yang <donghee.yang@samsung.com>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
- S-Core Co., Ltd
=end

class RootstrapController
    attr_accessor :type
	@rootstrap = nil

    def initialize
        @type = File.basename(File.dirname(__FILE__))
		# Let's assume OBS is installed
    end 

	# create new rootstrap
	def create_new_rootstrap ( rootstrap )
		@rootstrap = rootstrap
	end

	# install packages
	def install_packages
		raise "You must overide this method!"
	end

	# remove packages
	def remove_packages
		raise "You must overide this method!"
	end

	# get all package list installed
	def get_all_installed_packages
		raise "You must overide this method!"
	end

	# get all file list in package
	def get_all_package_files(pkg_name)
		raise "You must overide this method!"
	end

	# get all dependent packages
	def get_all_dependent_packages(pkg_name)
		raise "You must overide this method!"
	end

    # recreate using saved rootstrap
    def reload ( rootstrap )
		raise "You must overide this method!"
    end 

    # write self information to file that will save
    def write_info ( file_path )
		raise "You must overide this method!"
    end 

    # compare saved information file with self
    def same_as? ( file_path )
		raise "You must overide this method!"
    end 
end
