=begin 
  
 TizenBase/generator.rb 
 
Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved. 
 
Contact: 
Taejun Ha <taejun.ha@samsung.com> 
Jiil Hyoun <jiil.hyoun@samsung.com> 
Donghyuk Yang <donghyuk.yang@samsung.com> 
DongHee Yang <donghee.yang@samsung.com> 
 
Licensed under the Apache License, Version 2.0 (the "License"); 
you may not use this file except in compliance with the License. 
You may obtain a copy of the License at 
 
http://www.apache.org/licenses/LICENSE-2.0 
 
Unless required by applicable law or agreed to in writing, software 
distributed under the License is distributed on an "AS IS" BASIS, 
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
See the License for the specific language governing permissions and 
limitations under the License. 
 
Contributors: 
- S-Core Co., Ltd 
=end 

class ImageGenerator
	@analyzer = nil
	@image = nil
	@rootstrap = nil

	# process rootstrap
	def post_process(image)
		@image = image
		@rootstrap = @image.rootstrap

		# change permission if OBS
        if @rootstrap.ctrl.type.eql? "OBS" then
			username=`whoami`
			puts "===>sudo chown -R #{username.strip}:#{username.strip} #{@rootstrap.path}"
			system "sudo chown -R #{username.strip}:#{username.strip} #{@rootstrap.path}"
			system "sudo chmod -R +rw #{@rootstrap.path}"
		end
		# remove unnecessary files
		remove_files

		# fix symbolic links
		fix_symbolic_links
	end


	# make package
	def zip
		FileUtils.cd @rootstrap.name
        system "tar cvfz ../#{@rootstrap.name}.tar.gz ."
		FileUtils.cd ".."
	end


	#
	# PRIVATE
	#
	private



	# remove unnecessary files
	def remove_files
		#remove aclocal m4 files
		#ls -F show when link file with @ character at last
		if File.exist? "#{@rootstrap.name}/usr/share/aclocal" then
			aclocal = `ls -F #{@rootstrap.name}/usr/share/aclocal/*`
			aclocal.each_line do |ac|
				if ac.include? "@" then
					FileUtils.rm_rf ac.strip[0..-2]
				end
			end
		end
		#remove .build files
		if @rootstrap.ctrl.type.eql? "OBS"  then 
			$log.info "remove build files"
			FileUtils.rm_rf "#{@rootstrap.name}/.build"
			FileUtils.rm_rf "#{@rootstrap.name}/.build.command"
			FileUtils.rm_rf "#{@rootstrap.name}/.build.log"
			FileUtils.rm_rf "#{@rootstrap.name}/.build.packages"
			FileUtils.rm_rf "#{@rootstrap.name}/.buildenv"
			FileUtils.rm_rf "#{@rootstrap.name}/.guessed_dist"
			FileUtils.rm_rf "#{@rootstrap.name}/dev"
			FileUtils.rm_rf "#{@rootstrap.name}/home"
			FileUtils.mkdir_p "#{@rootstrap.name}/home"
			FileUtils.rm_rf "#{@rootstrap.name}/usr/bin"
			FileUtils.rm_rf "#{@rootstrap.name}/usr/sbin"
			FileUtils.rm_rf "#{@rootstrap.name}/usr/lib/locale"
			FileUtils.rm_rf "#{@rootstrap.name}/usr/lib/perl5"
			FileUtils.rm_rf "#{@rootstrap.name}/usr/share"
			FileUtils.rm_rf "#{@rootstrap.name}/mnt"
			FileUtils.rm_rf "#{@rootstrap.name}/installed-pkg"
			FileUtils.rm_rf "#{@rootstrap.name}/emul"
		end 

		#remove static libray files when dynamic library is exist
		d = Dir.entries("#{@rootstrap.name}/usr/lib")
		s = d.select {|a| a.include? ".a" or a.include? ".la" }
		s.each do |a|
			if File.exist? "#{@rootstrap.name}/usr/lib/#{a.sub(/\.l*a/,".so")}" then 
                if File.exist?("#{@rootstrap.name}/usr/lib/#{a}") then 
                    if File.stat("#{@rootstrap.name}/usr/lib/#{a}").owned? then
                        system "rm -rf #{@rootstrap.name}/usr/lib/#{a}"
                    else
                        system "sudo rm -rf #{@rootstrap.name}/usr/lib/#{a}"
                    end
                else
                    system "unlink #{@rootstrap.name}/usr/lib/#{a}"
                end
            end
        end
    end




	# fix symbolic links
	def fix_symbolic_links

        #delete toolchain link
        FileUtils.cd @rootstrap.name

        #show link type 
        links = `find -type l`
        links.each_line do |f|
            l = `file #{f}`.split(':')
            link = l[0]
            if not l[1].include? "`" then next end 
            src = l[1].split('`')[1].strip[0..-2]

			#fix link only absolute path link 
			if src.start_with? "/"  then 
				depth = "/.." * (link.count("/") -1)
				if File.exist?("#{File.dirname(link)}/.#{depth}#{src}") then
					puts "-> sudo unlink #{link}" 
					system "sudo unlink #{link}" 
					puts "-> sudo ln -s .#{depth}#{src} #{link}" 
					system "sudo ln -s .#{depth}#{src} #{link}" 
				else
					puts "-> sudo unlink #{link} : #{File.dirname(link)}/.#{depth}#{src}" 
					system "sudo unlink #{link}" 
				end
			else
				if not File.exist?("#{File.dirname(link)}/#{src}") then
					puts "-> sudo unlink #{link} : #{File.dirname(link)}/#{src}" 
					system "sudo unlink #{link}" 
				end
			end 
		end 
		FileUtils.cd ".."
	end
end
