=begin 
  
 TizenPlatform/generator.rb 
 
Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved. 
 
Contact: 
Taejun Ha <taejun.ha@samsung.com> 
Jiil Hyoun <jiil.hyoun@samsung.com> 
Donghyuk Yang <donghyuk.yang@samsung.com> 
DongHee Yang <donghee.yang@samsung.com> 
 
Licensed under the Apache License, Version 2.0 (the "License"); 
you may not use this file except in compliance with the License. 
You may obtain a copy of the License at 
 
http://www.apache.org/licenses/LICENSE-2.0 
 
Unless required by applicable law or agreed to in writing, software 
distributed under the License is distributed on an "AS IS" BASIS, 
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
See the License for the specific language governing permissions and 
limitations under the License. 
 
Contributors: 
- S-Core Co., Ltd 
=end 

class ImageGenerator
	@image = nil     
	@rootstrap = nil 

	# process rootstrap
	def post_process(image) 
		@image = image
		@rootstrap = @image.rootstrap 

        # overwrite prelinked ld.so if ARM
        # prelink ld.so for compatibility to ARM device
        if @rootstrap.arch == "arm" and @rootstrap.ctrl.respond_to?("make_ldso_prelinked") then 
            @rootstrap.ctrl.make_ldso_prelinked
        end
	end


	# make package
	def zip
		#FileUtils.cd @rootstrap.name
		#system "sudo tar cvfz ../#{@rootstrap.name}.tar.gz ."
		#FileUtils.cd ".."
	end


	# PRIVATE
	private




end
