@echo off

setlocal ENABLEEXTENSIONS

REM set local variables
  set OLD_PATH=%PATH%
  set PATH=%OLD_PATH%;%WINDIR%\System32
  set haxm_path=%INSTALLED_PATH%
  set haxm_file=tools\emulator\etc\IntelHaxm.exe
  set haxm_path=###%haxm_path%###
  set haxm_path=%haxm_path:"###=%
  set haxm_path=%haxm_path:###"=%
  set haxm_path=%haxm_path:###=%
  set haxm_full_path=%haxm_path%\%haxm_file%
  set KEY_NAME="HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Installer\UserData\S-1-5-18\Products"
  set SEARCH_NAME="Intel Hardware Accelerated Execution Manager"
  set VALUE1_NAME=DisplayName
  set VALUE2_NAME=DisplayVersion
  set TEMP_FILE=HAXM_REG.TXT
  set extract_folder=%TEMP%\TizenSDK\IntelHAXM\silent
  set install_log=%haxm_path%\haxm_silent_install.log
REM finish.

@echo start tizen intelhaxm install script.
@echo.

@echo check if "%haxm_file%" exists or not.
if exist "%haxm_full_path%" (
	@echo "%haxm_full_path%" does exist.
) else (
	@echo "%haxm_full_path%" does not exist.
	goto :errorexit
)
@echo.

@echo check if msiexec.exe is available.
REG 2> NUL
if "x%ERRORLEVEL%" == "x1" (
	@echo msiexec.exe is available.
) else (
	@echo msiexec.exe is not available.
	goto :errorexit
)
@echo.
@echo check if reg.exe is available.
REG 2> NUL
if "x%ERRORLEVEL%" == "x1" (
	@echo reg.exe is available.
) else (
	@echo reg.exe is not available.
	@echo try to force install the intelhaxm.
	goto :install
)
@echo.
@echo check if findstr.exe is available.
FINDSTR 2> NUL
if "x%ERRORLEVEL%" == "x2" (
	@echo findstr.exe is available.
) else (
	@echo findstr.exe is not available.
	@echo try to force install the intelhaxm.
	goto :install
)
@echo.

@echo query registry.
REG QUERY %KEY_NAME% /s /f %SEARCH_NAME% | FINDSTR HKEY > %TEMP_FILE%
FOR /F %%A IN (%TEMP_FILE%) DO (
	set FULL_KEY_NAME=%%A
)
del "%TEMP_FILE%"
if defined FULL_KEY_NAME (
	@echo intelhaxm is already installed.
	@echo FULL_KEY_NAME = %FULL_KEY_NAME%
) else (
	@echo failed to search intelhaxm registry.
	@echo intelhaxm is not running. install intelhaxm.
	goto :install
)

REM query haxm driver existance
FOR /F "tokens=2*" %%A IN ('REG QUERY %FULL_KEY_NAME% /v %VALUE1_NAME% 2^>nul') DO (
	set Value1Type=%%A
	set Value1Value="%%B"
)

REM Value1Value: DisplayName
if defined Value1Value (
	@echo Value1 Type = %Value1Type%
	@echo Value1 Value = %Value1Value%
)

REM query haxm driver version
FOR /F "tokens=2*" %%A IN ('REG QUERY %FULL_KEY_NAME% /v %VALUE2_NAME% 2^>nul') DO (
	set Value2Type=%%A
	set Value2Value="%%B"
)

REM Value2Value: DisplayVersion
if defined Value2Value (
	@echo Value2 Type = %Value2Type%
	@echo Value2 Value = %Value2Value%
)
@echo.

set PKG_VERSION="6.0.4"

REM parse package version
FOR /F "tokens=1-4 delims=. " %%A IN ( %PKG_VERSION% ) DO (
	set PKG_MAJOR_NUM=%%A
	set PKG_MINOR_NUM=%%B
	set PKG_BUILD_NUM=%%C
)

REM parse installed haxm driver version
FOR /F "tokens=1-3 delims=. " %%A IN ( %Value2Value% ) DO (
	set INSTALLED_HAXM_MAJOR_NUM=%%A
	set INSTALLED_HAXM_MINOR_NUM=%%B
	set INSTALLED_HAXM_BUILD_NUM=%%C
)

REM compare DisplayName and DisplayVersion
if %SEARCH_NAME% == %Value1Value% (
	@echo intelhaxm is running. check installed version.

	if %PKG_MAJOR_NUM% GTR %INSTALLED_HAXM_MAJOR_NUM% (
		@echo lower major version intelhaxm has installed.
		goto :install
	) else (
		if %PKG_MAJOR_NUM% EQU %INSTALLED_HAXM_MAJOR_NUM% (
			if %PKG_MINOR_NUM% GTR %INSTALLED_HAXM_MINOR_NUM% (
				@echo lower minor version intelhaxm has installed.
				goto :install
			) else (
				if %PKG_MINOR_NUM% EQU %INSTALLED_HAXM_MINOR_NUM% (
					if %PKG_BUILD_NUM% GTR %INSTALLED_HAXM_BUILD_NUM% (
						@echo lower build version intelhaxm has installed.
						goto :install
					) else (
						@echo same or higher version intelhaxm has installed.
					)
				) else (
					@echo higher minor version intelhaxm has installed.
				)
			)
		) else (
			@echo higher major version intelhaxm has installed.
		)
	)
	@echo skip intelhaxm installation.
)
goto :exit


REM labels

:check_log
	if exist "%install_log%" del "%install_log%"
	if exist "%install_log%" (
		@echo cannot write log to ["%install_log%"].
		exit /b 1
	)
	echo generate new "%install_log%" file. > "%install_log%"
	if not exist "%install_log%" (
		@echo invalid log path: "%install_log%".
		exit /b 1
	)
	@echo "%install_log%" file is created.
	goto :eof

:clean_and_extract
	if exist "%extract_folder%" rd /s /q "%extract_folder%"
	if exist "%extract_folder%" (
		@echo failed to cleanup temporary folder "%extract_folder%".
		exit /b 1
	)

	if "%1"=="clean" goto :eof

	"%haxm_full_path%" -s -f "%extract_folder%" -x

	if errorlevel 1 (
		@echo failed to extract haxm.
		exit /b 1
	)
	@echo extract msi files to "%extract_folder%".
	goto :eof

:install
	@echo start intelhaxm installation.
	@echo.
	call :check_log
	if errorlevel 1 goto :errorexit

	call :clean_and_extract
	if errorlevel 1 goto :errorexit

	if %PROCESSOR_ARCHITECTURE%==AMD64 (
		set msi_name=hax64.msi
	) else (
		set msi_name=hax.msi
	)
	@echo this processor's architecture is %PROCESSOR_ARCHITECTURE%, selected MSI file is %msi_name%.

	if not exist "%extract_folder%\%msi_name%" (
		@echo failed to find "%extract_folder%\%msi_name%".
		goto :errorexit
	)

	@echo try to install "%extract_folder%\%msi_name%".
	msiexec /i "%extract_folder%\%msi_name%" /qn /le "%install_log%" MEMSIZETYPE=1 CUSTOMMEMSIZE=0

	if errorlevel 1 (
		@echo failed to install HAXM! Please check the log "%install_log%" for detail!
		goto :errorexit
	) else (
		@echo HAXM is installed successfully!
	)

:exit
	@echo.
	set PATH=%OLD_PATH%
	@echo #################### Local Environment Variables ####################
	SET
	@echo #####################################################################
	@echo.
	@echo finish the tizen intelhaxm installation.
	exit /b 0

:errorexit
	@echo.
	set PATH=%OLD_PATH%
	@echo #################### Local Environment Variables ####################
	SET
	@echo #####################################################################
	@echo.
	@echo failed to install tizen intelhaxm driver.
	exit /b 99

