#!/bin/sh -x


check_os_version()
{
OS_VER=`sw_vers -productVersion`
second="`echo ${OS_VER} | cut -d . -f2`"

INTELHAXM_BIN=IntelHAXM_7.6.1.dmg

TMP_INSTALLER=tmp-tizen-haxm-installer.sh

echo $INTELHAXM_BIN
}

do_unmount()
{
	MOUNTED_HAXM=`ls /Volumes/ | grep 'IntelHAXM'`
	if [ "x${MOUNTED_HAXM}" != "x" ]
	then
		echo "try to unmount Intel Haxm driver installer for Tizen."
		ls /Volumes/ | grep 'IntelHAXM'	| awk '{system("hdiutil detach /Volumes/" $0)}'
	fi
}

TIZEN_SDK_INSTALL_PATH=`echo ${INSTALLED_PATH}`
if [ -z "${TIZEN_SDK_INSTALL_PATH}" ]
then
	echo "there is no TIZEN_SDK_PATH ENV."
	echo "fail to install HAXM."
	exit 99
fi

check_os_version

COCOASUDO_BIN_PATH=${TIZEN_SDK_INSTALL_PATH}/tools/emulator/bin/cocoasudo
INTELHAXM_BIN_PATH=${TIZEN_SDK_INSTALL_PATH}/tools/emulator/etc/${INTELHAXM_BIN}
if [ -e "${INTELHAXM_BIN_PATH}" ]
then
	do_unmount

	echo "mount Intel Haxm driver installer for Tizen."
	hdiutil attach "${INTELHAXM_BIN_PATH}"

	INTELHAXM_PKG_PATH=`ls /Volumes/IntelHAXM*/*.mpkg`
	if [ "x${INTELHAXM_PKG_PATH}" = "x" ]
	then
		echo "cannot find IntelHAXM mpkg file!!"
		echo "fail to install HAXM."
		exit 99
	fi

	if [ -e "${COCOASUDO_BIN_PATH}" ]
	then
		echo "cocoasudo exist."
		if [ -x "${COCOASUDO_BIN_PATH}" ]
		then
			echo "create the $TMP_INSTALLER file."
			if [ -e "$TMP_INSTALLER" ]
			then
				echo "remove the old $TMP_INSTALLER file, first."
				rm -f "$TMP_INSTALLER"
			fi
			echo "#!/bin/sh" > "$TMP_INSTALLER"
			echo "if [ -e /System/Library/LaunchDaemons/com.intel.haxm.plist ]; then" >> "$TMP_INSTALLER"
			echo "launchctl unload /System/Library/LaunchDaemons/com.intel.haxm.plist" >> "$TMP_INSTALLER"
			echo "rm -rf /System/Library/LaunchDaemons/com.intel.haxm.plist" >> "$TMP_INSTALLER"
			echo "fi" >> "$TMP_INSTALLER"
			echo "installer -pkg \"${INTELHAXM_PKG_PATH}\" -target /" >> "$TMP_INSTALLER"
			echo "create done"
			echo ">>>"
			cat "$TMP_INSTALLER"
			echo "<<<"
			echo ""

			echo "try to install the HAXM driver."
			echo "this could take several minutes. please wait..."
			"${COCOASUDO_BIN_PATH}" --prompt="Please enter your password to install HAXM Driver." sh -x "$TMP_INSTALLER"
			echo ""

			echo "remove the $TMP_INSTALLER file."
			rm -f "$TMP_INSTALLER"
		else
			echo "cocoasudo is not executable."
			echo "fail to install HAXM."
			exit 99
		fi
	else
		echo "cocoasudo does not exist."
		echo "fail to install HAXM."
		exit 99
	fi

	do_unmount
else
	echo "there is no ${INTELHAXM_BIN_PATH}."
	echo "fail to install HAXM."
	exit 99
fi

echo "HAXM is installed successfully!"
