/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.io;

import com.ibm.wala.util.collections.HashSetFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class AbstractAsyncTraceWriter {
    private final AsynchronousFileChannel out;
    protected StringBuilder builder = new StringBuilder();
    private static final int CHAR_LIMIT = 64000;
    private long byteOffset = 0L;
    private final ExecutorService ioExecutor;

    public AbstractAsyncTraceWriter(Path path) throws IOException {
        Files.deleteIfExists(path);
        this.ioExecutor = Executors.newSingleThreadExecutor();
        StandardOpenOption[] options = new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE};
        this.out = AsynchronousFileChannel.open(path, HashSetFactory.make(Arrays.asList(options)), this.ioExecutor, new FileAttribute[0]);
    }

    public void flushIfNeeded() {
        if (this.builder.length() >= 64000) {
            this.doFlush();
        }
    }

    private void doFlush() {
        byte[] bytes = this.builder.toString().getBytes();
        int curLen = bytes.length;
        this.out.write(ByteBuffer.wrap(bytes), this.byteOffset);
        this.byteOffset += (long)curLen;
        this.builder.setLength(0);
    }

    public void close() throws IOException {
        this.doFlush();
        this.out.force(true);
        this.ioExecutor.shutdown();
        try {
            this.ioExecutor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.out.close();
    }
}

