/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.plt.concurrent;

import edu.rice.cs.plt.concurrent.ConcurrentUtil;
import edu.rice.cs.plt.lambda.Condition;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ConditionMonitor
implements Condition {
    private final Condition _condition;

    public ConditionMonitor(Condition condition) {
        this._condition = condition;
    }

    public boolean isTrue() {
        return this._condition.isTrue();
    }

    public synchronized void check() {
        if (this._condition.isTrue()) {
            this.notifyAll();
        }
    }

    public synchronized void ensureTrue() throws InterruptedException {
        while (!this._condition.isTrue()) {
            this.wait();
        }
    }

    public void ensureTrue(long timeout) throws InterruptedException, TimeoutException {
        this.ensureTrue(timeout, TimeUnit.MILLISECONDS);
    }

    public synchronized void ensureTrue(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (!this._condition.isTrue()) {
            long timeoutTime = ConcurrentUtil.futureTimeNanos(timeout, unit);
            do {
                ConcurrentUtil.waitUntilNanos(this, timeoutTime);
            } while (!this._condition.isTrue());
        }
    }

    public boolean attemptEnsureTrue() {
        try {
            this.ensureTrue();
            return true;
        }
        catch (InterruptedException e) {
            return this._condition.isTrue();
        }
    }

    public boolean attemptEnsureTrue(long timeout) {
        try {
            this.ensureTrue(timeout, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (InterruptedException e) {
            return this._condition.isTrue();
        }
        catch (TimeoutException e) {
            return this._condition.isTrue();
        }
    }

    public boolean attemptEnsureTrue(long timeout, TimeUnit unit) {
        try {
            this.ensureTrue(timeout, unit);
            return true;
        }
        catch (InterruptedException e) {
            return this._condition.isTrue();
        }
        catch (TimeoutException e) {
            return this._condition.isTrue();
        }
    }
}

