/*
 * Decompiled with CFR 0.152.
 */
package com.samsung.memoryanalysis.traceparser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.functions.VoidFunction;
import com.samsung.memoryanalysis.traceparser.FreeVariables;
import com.samsung.memoryanalysis.traceparser.IIDMap;
import com.samsung.memoryanalysis.traceparser.ProgressMonitor;
import com.samsung.memoryanalysis.traceparser.SourceLocation;
import com.samsung.memoryanalysis.traceparser.Timer;
import com.samsung.memoryanalysis.traceparser.TraceAnalysis;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class TraceAnalysisRunner {
    private final DataInputStream trace;
    private final JsonParser parser = new JsonParser();
    private final FreeVariables fvMap;
    private final IIDMap iidMap;
    private final ProgressMonitor progress;
    private int traceSize = 0;
    private byte[] buf = new byte[4];
    private ByteBuffer byteBuf = ByteBuffer.wrap(this.buf);

    public TraceAnalysisRunner(InputStream trace, ProgressMonitor progress, File dir) throws FileNotFoundException, IOException {
        this.trace = new DataInputStream(trace);
        this.fvMap = this.buildFVMap(dir);
        this.iidMap = IIDMap.parseIIDFile(dir);
        this.progress = progress;
    }

    private int getInt(JsonArray arr, int idx) {
        return arr.get(idx).getAsInt();
    }

    private String getString(JsonArray arr, int idx) {
        return arr.get(idx).getAsString();
    }

    private FreeVariables buildFVMap(File dir) throws IOException {
        File fvFile = new File(dir, "freevars.json");
        FreeVariables res = new FreeVariables();
        if (fvFile.exists()) {
            JsonObject json = null;
            try {
                json = this.parser.parse((Reader)new BufferedReader(new FileReader(fvFile))).getAsJsonObject();
            }
            catch (JsonParseException ex) {
                throw new IOException("Invalid free-variables map file: " + ex.getMessage());
            }
            for (Map.Entry entry : json.entrySet()) {
                JsonElement o = (JsonElement)entry.getValue();
                if (o.isJsonPrimitive() && o.getAsJsonPrimitive().isString()) {
                    res.put(Integer.parseInt((String)entry.getKey()), FreeVariables.ANY);
                    continue;
                }
                JsonArray a = o.getAsJsonArray();
                HashSet freeVars = HashSetFactory.make();
                for (int i = 0; i < a.size(); ++i) {
                    JsonElement jsonElement = a.get(i);
                    freeVars.add(jsonElement.getAsString());
                }
                res.put(Integer.parseInt((String)entry.getKey()), freeVars);
            }
        }
        return res;
    }

    private int readInt() throws IOException {
        this.byteBuf.rewind();
        this.trace.readFully(this.buf);
        return this.byteBuf.getInt();
    }

    private String readString() throws IOException {
        int length = this.readInt();
        byte[] strData = new byte[length];
        this.trace.readFully(strData);
        return new String(strData, "UnicodeLittleUnmarked");
    }

    public <T> T runAnalysis(TraceAnalysis<T> a) throws FileNotFoundException, IOException {
        TraceTimer timer = new TraceTimer();
        a.init(timer, this.iidMap);
        int counter = 0;
        if (this.progress != null) {
            this.progress.start(this.traceSize);
        }
        int evtTypeInt = 0;
        TraceEntry[] vals = TraceEntry.values();
        while ((evtTypeInt = this.trace.read()) != -1) {
            TraceEntry evtType = vals[evtTypeInt];
            switch (evtType) {
                case DECLARE: {
                    int iid = this.readInt();
                    String name = this.readString();
                    int objId = this.readInt();
                    a.declare(iid, name, objId);
                    break;
                }
                case CREATE_OBJ: {
                    int iid = this.readInt();
                    int objId = this.readInt();
                    a.create(iid, objId);
                    break;
                }
                case CREATE_FUN: {
                    int iid = this.readInt();
                    int funcEnterIID = this.readInt();
                    int objId = this.readInt();
                    int protoId = objId + 1;
                    a.createFun(iid, objId, protoId, funcEnterIID, this.fvMap.getFreeVariables(funcEnterIID));
                    break;
                }
                case PUTFIELD: {
                    int iid = this.readInt();
                    int baseid = this.readInt();
                    String propName = null;
                    propName = this.readString();
                    int objId = this.readInt();
                    a.putField(iid, baseid, propName, objId);
                    break;
                }
                case WRITE: {
                    int iid = this.readInt();
                    String name = this.readString();
                    int objId = this.readInt();
                    a.write(iid, name, objId);
                    break;
                }
                case LAST_USE: {
                    int objId = this.readInt();
                    int time = this.readInt();
                    int iid = this.readInt();
                    a.lastUse(objId, iid, time);
                    break;
                }
                case FUNCTION_ENTER: {
                    int iid = this.readInt();
                    int funId = this.readInt();
                    a.functionEnter(iid, funId, -1);
                    break;
                }
                case FUNCTION_EXIT: {
                    int iid = this.readInt();
                    a.functionExit(iid);
                    break;
                }
                case TOP_LEVEL_FLUSH: {
                    int iid = this.readInt();
                    a.topLevelFlush(iid);
                    break;
                }
                case UPDATE_IID: {
                    int objId = this.readInt();
                    int newIID = this.readInt();
                    a.updateIID(objId, newIID);
                    break;
                }
                case DEBUG: {
                    int iid = this.readInt();
                    int o = this.readInt();
                    a.debug(iid, o);
                    break;
                }
                case RETURN: {
                    int retVal = this.readInt();
                    a.returnStmt(retVal);
                    break;
                }
                case CREATE_DOM_NODE: {
                    int iid = this.readInt();
                    int o = this.readInt();
                    a.createDomNode(iid, o);
                    break;
                }
                case ADD_DOM_CHILD: {
                    int parent = this.readInt();
                    int child = this.readInt();
                    a.addDOMChild(parent, child);
                    break;
                }
                case REMOVE_DOM_CHILD: {
                    int parent = this.readInt();
                    int child = this.readInt();
                    a.removeDOMChild(parent, child);
                    break;
                }
                case ADD_TO_CHILD_SET: {
                    int iid = this.readInt();
                    int parent = this.readInt();
                    String name = this.readString();
                    int child = this.readInt();
                    a.addToChildSet(iid, parent, name, child);
                    break;
                }
                case REMOVE_FROM_CHILD_SET: {
                    int iid = this.readInt();
                    int parent = this.readInt();
                    String name = this.readString();
                    int child = this.readInt();
                    a.removeFromChildSet(iid, parent, name, child);
                    break;
                }
                case DOM_ROOT: {
                    int nodeId = this.readInt();
                    a.domRoot(nodeId);
                    break;
                }
                case CALL: {
                    int iid = this.readInt();
                    int funObjId = this.readInt();
                    int funEnterIID = this.readInt();
                    a.functionEnter(funEnterIID, funObjId, iid);
                    break;
                }
                case SCRIPT_ENTER: {
                    int iid = this.readInt();
                    String filename = this.readString();
                    a.scriptEnter(iid, filename);
                    break;
                }
                case SCRIPT_EXIT: {
                    int iid = this.readInt();
                    a.scriptExit(iid);
                    break;
                }
                case FREE_VARS: {
                    int iid = this.readInt();
                    int len = this.readInt();
                    if (len == -1) {
                        this.readString();
                        this.fvMap.put(iid, FreeVariables.ANY);
                        break;
                    }
                    HashSet names = HashSetFactory.make((int)len);
                    for (int i = 0; i < len; ++i) {
                        names.add(this.readString());
                    }
                    this.fvMap.put(iid, names);
                    break;
                }
                case SOURCE_MAPPING: {
                    int iid = this.readInt();
                    String filename = this.readString();
                    int startLine = this.readInt();
                    int startColumn = this.readInt();
                    this.iidMap.addMapping(iid, new SourceLocation(filename, startLine, startColumn, -1L, -1L));
                    throw new RuntimeException("fix this case");
                }
            }
            if (evtType != TraceEntry.SOURCE_MAPPING && evtType != TraceEntry.FREE_VARS) {
                timer.tick();
            }
            if (this.progress != null) {
                this.progress.tick(counter);
            }
            ++counter;
        }
        if (this.progress != null) {
            this.progress.tick(this.traceSize);
        }
        this.trace.close();
        timer.rewindOneTick();
        return a.endExecution();
    }

    public <T> T runAnalysisJSON(TraceAnalysis<T> a) throws FileNotFoundException, IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(this.trace));
        TraceTimer timer = new TraceTimer();
        a.init(timer, this.iidMap);
        int counter = 0;
        if (this.progress != null) {
            this.progress.start(this.traceSize);
        }
        while ((line = in.readLine()) != null) {
            try {
                JsonArray arr = this.parser.parse(line).getAsJsonArray();
                TraceEntry evt = TraceEntry.values()[arr.get(0).getAsInt()];
                switch (evt) {
                    case DECLARE: {
                        int iid = this.getInt(arr, 1);
                        String name = this.getString(arr, 2);
                        int objId = this.getInt(arr, 3);
                        a.declare(iid, name, objId);
                        break;
                    }
                    case CREATE_OBJ: {
                        int iid = this.getInt(arr, 1);
                        int objId = this.getInt(arr, 2);
                        a.create(iid, objId);
                        break;
                    }
                    case CREATE_FUN: {
                        int iid = this.getInt(arr, 1);
                        int funcEnterIID = this.getInt(arr, 2);
                        int objId = this.getInt(arr, 3);
                        int protoId = objId + 1;
                        a.createFun(iid, objId, protoId, funcEnterIID, this.fvMap.getFreeVariables(funcEnterIID));
                        break;
                    }
                    case PUTFIELD: {
                        int iid = this.getInt(arr, 1);
                        int baseid = this.getInt(arr, 2);
                        String propName = null;
                        try {
                            propName = this.getString(arr, 3);
                        }
                        catch (Exception e) {
                            System.err.println("!!!" + line);
                            throw new RuntimeException(e);
                        }
                        int objId = this.getInt(arr, 4);
                        a.putField(iid, baseid, propName, objId);
                        break;
                    }
                    case WRITE: {
                        int iid = this.getInt(arr, 1);
                        String name = this.getString(arr, 2);
                        int objId = this.getInt(arr, 3);
                        a.write(iid, name, objId);
                        break;
                    }
                    case LAST_USE: {
                        int objId = this.getInt(arr, 1);
                        int time = this.getInt(arr, 2);
                        int iid = this.getInt(arr, 3);
                        a.lastUse(objId, iid, time);
                        break;
                    }
                    case FUNCTION_ENTER: {
                        int iid = this.getInt(arr, 1);
                        int funId = this.getInt(arr, 2);
                        a.functionEnter(iid, funId, -1);
                        break;
                    }
                    case FUNCTION_EXIT: {
                        int iid = this.getInt(arr, 1);
                        a.functionExit(iid);
                        break;
                    }
                    case TOP_LEVEL_FLUSH: {
                        int iid = this.getInt(arr, 1);
                        a.topLevelFlush(iid);
                        break;
                    }
                    case UPDATE_IID: {
                        int objId = this.getInt(arr, 1);
                        int newIID = this.getInt(arr, 2);
                        a.updateIID(objId, newIID);
                        break;
                    }
                    case DEBUG: {
                        int iid = this.getInt(arr, 1);
                        int o = this.getInt(arr, 2);
                        a.debug(iid, o);
                        break;
                    }
                    case RETURN: {
                        int retVal = this.getInt(arr, 1);
                        a.returnStmt(retVal);
                        break;
                    }
                    case CREATE_DOM_NODE: {
                        int iid = this.getInt(arr, 1);
                        int o = this.getInt(arr, 2);
                        a.createDomNode(iid, o);
                        break;
                    }
                    case ADD_DOM_CHILD: {
                        int parent = this.getInt(arr, 1);
                        int child = this.getInt(arr, 2);
                        a.addDOMChild(parent, child);
                        break;
                    }
                    case REMOVE_DOM_CHILD: {
                        int parent = this.getInt(arr, 1);
                        int child = this.getInt(arr, 2);
                        a.removeDOMChild(parent, child);
                        break;
                    }
                    case ADD_TO_CHILD_SET: {
                        int iid = this.getInt(arr, 1);
                        int parent = this.getInt(arr, 2);
                        String name = this.getString(arr, 3);
                        int child = this.getInt(arr, 4);
                        a.addToChildSet(iid, parent, name, child);
                        break;
                    }
                    case REMOVE_FROM_CHILD_SET: {
                        int iid = this.getInt(arr, 1);
                        int parent = this.getInt(arr, 2);
                        String name = this.getString(arr, 3);
                        int child = this.getInt(arr, 4);
                        a.removeFromChildSet(iid, parent, name, child);
                        break;
                    }
                    case DOM_ROOT: {
                        int nodeId = this.getInt(arr, 1);
                        a.domRoot(nodeId);
                        break;
                    }
                    case CALL: {
                        int iid = this.getInt(arr, 1);
                        int funObjId = this.getInt(arr, 2);
                        int funEnterIID = this.getInt(arr, 3);
                        a.functionEnter(funEnterIID, funObjId, iid);
                        break;
                    }
                    case SCRIPT_ENTER: {
                        int iid = this.getInt(arr, 1);
                        String filename = this.getString(arr, 2);
                        a.scriptEnter(iid, filename);
                        break;
                    }
                    case SCRIPT_EXIT: {
                        int iid = this.getInt(arr, 1);
                        a.scriptExit(iid);
                        break;
                    }
                    case FREE_VARS: {
                        int iid = this.getInt(arr, 1);
                        JsonElement names = arr.get(2);
                        if (names.isJsonPrimitive()) {
                            this.fvMap.put(iid, FreeVariables.ANY);
                            break;
                        }
                        JsonArray namesArray = names.getAsJsonArray();
                        HashSet fv = HashSetFactory.make();
                        for (int i = 0; i < namesArray.size(); ++i) {
                            fv.add(namesArray.get(i).getAsString());
                        }
                        this.fvMap.put(iid, fv);
                        break;
                    }
                    case SOURCE_MAPPING: {
                        int iid = this.getInt(arr, 1);
                        String filename = this.getString(arr, 2);
                        int startLine = this.getInt(arr, 3);
                        int startColumn = this.getInt(arr, 4);
                        throw new RuntimeException("fix this case");
                    }
                    case UNREACHABLE: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("? : " + (Object)((Object)evt)));
                    }
                }
                if (evt != TraceEntry.SOURCE_MAPPING && evt != TraceEntry.FREE_VARS) {
                    timer.tick();
                }
                if (this.progress != null) {
                    this.progress.tick(counter);
                }
                ++counter;
            }
            catch (JsonParseException ex) {
                in.close();
                throw new IOException("Invalid JSON line: " + line);
            }
        }
        if (this.progress != null) {
            this.progress.tick(this.traceSize);
        }
        in.close();
        timer.rewindOneTick();
        return a.endExecution();
    }

    public static enum TraceEntry {
        DECLARE,
        CREATE_OBJ,
        CREATE_FUN,
        PUTFIELD,
        WRITE,
        LAST_USE,
        FUNCTION_ENTER,
        FUNCTION_EXIT,
        TOP_LEVEL_FLUSH,
        UPDATE_IID,
        DEBUG,
        RETURN,
        CREATE_DOM_NODE,
        ADD_DOM_CHILD,
        REMOVE_DOM_CHILD,
        ADD_TO_CHILD_SET,
        REMOVE_FROM_CHILD_SET,
        DOM_ROOT,
        CALL,
        SCRIPT_ENTER,
        SCRIPT_EXIT,
        FREE_VARS,
        SOURCE_MAPPING,
        UNREACHABLE;

    }

    private static class TraceTimer
    implements Timer {
        private long timeInternal = 0L;
        private SortedMap<Long, List<VoidFunction<Long>>> alarms = null;

        private TraceTimer() {
        }

        @Override
        public long currentTime() {
            return this.timeInternal;
        }

        public void rewindOneTick() {
            --this.timeInternal;
        }

        @Override
        public void registerAlarm(long atTime, VoidFunction<Long> callback) {
            ArrayList<VoidFunction<Long>> cbs;
            if (this.alarms == null) {
                this.alarms = new TreeMap<Long, List<VoidFunction<Long>>>();
            }
            if ((cbs = (ArrayList<VoidFunction<Long>>)this.alarms.get(atTime)) == null) {
                cbs = new ArrayList<VoidFunction<Long>>();
                this.alarms.put(atTime, cbs);
            }
            cbs.add(callback);
        }

        private void tick() {
            if (this.alarms != null && this.alarms.firstKey() == this.timeInternal) {
                List list = (List)this.alarms.get(this.timeInternal);
                for (VoidFunction c : list) {
                    c.apply((Object)this.timeInternal);
                }
                this.alarms.remove(this.timeInternal);
                if (this.alarms.isEmpty()) {
                    this.alarms = null;
                }
            }
            ++this.timeInternal;
        }
    }

    private static class LastUseEntry
    implements Comparable<LastUseEntry> {
        public final int objectId;
        public final int time;
        public final int iid;

        public LastUseEntry(int objectId, int time, int iid) {
            this.objectId = objectId;
            this.time = time;
            this.iid = iid;
        }

        @Override
        public int compareTo(LastUseEntry o) {
            return this.time - o.time;
        }

        public String toJSONLine() {
            return String.format("[%d,%d,%d,%d]", 5, this.objectId, this.time, this.iid);
        }
    }
}

