/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.jsaf.useful;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ArrayBackedList<E>
extends AbstractList<E>
implements List<E> {
    E[] elements;
    int offset;
    int size;

    public static <T> List<T> fromImmutable(Collection<T> collection) {
        if (collection instanceof List) {
            return (List)collection;
        }
        return new ArrayBackedList<T>(collection);
    }

    public ArrayBackedList(Collection<E> collection) {
        this(collection.toArray(), 0, collection.size());
    }

    public ArrayBackedList(E[] elements) {
        this(elements, 0, elements.length);
    }

    public ArrayBackedList(E[] elements, int offset, int size) {
        this.elements = elements;
        this.offset = offset;
        this.size = size;
    }

    @Override
    public E get(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.elements[this.offset + index];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int nextIndex = 0;

            @Override
            public boolean hasNext() {
                return this.nextIndex < ArrayBackedList.this.size;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return ArrayBackedList.this.get(this.nextIndex++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("ArrayBackedLists do not support remove");
            }
        };
    }

    @Override
    public E set(int index, E element) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        E previous = this.elements[this.offset + index];
        this.elements[this.offset + index] = element;
        return previous;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return Collections.emptyList();
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("negative fromIndex " + fromIndex);
        }
        if (toIndex > this.size) {
            throw new IndexOutOfBoundsException("toIndex (" + toIndex + ") > size (" + this.size + ")");
        }
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex (" + fromIndex + ") > toIndex (" + toIndex + ")");
        }
        return new ArrayBackedList<E>(this.elements, this.offset + fromIndex, toIndex - fromIndex);
    }
}

